/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestDataGuessByExistingFilesUtil {
    private TestDataGuessByExistingFilesUtil() {
    }

    @Nullable
    static List<String> collectTestDataByExistingFiles(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "collectTestDataByExistingFiles"));
        }
        TestDataDescriptor descriptor = TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod);
        if (descriptor == null || !descriptor.isComplete()) {
            return null;
        }
        return descriptor.generate();
    }

    static String guessTestDataName(PsiMethod method) {
        String testName = TestDataGuessByExistingFilesUtil.getTestName(method);
        if (testName == null) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        int count = 5;
        PsiMethod prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)method, PsiMethod.class);
        while (prev != null && count-- > 0) {
            String s = TestDataGuessByExistingFilesUtil.getFilePath(prev, testName);
            if (s != null) {
                return s;
            }
            prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiMethod.class);
        }
        count = 5;
        PsiMethod next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)method, PsiMethod.class);
        while (next != null && count-- > 0) {
            String s = TestDataGuessByExistingFilesUtil.getFilePath(next, testName);
            if (s != null) {
                return s;
            }
            next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiMethod.class);
        }
        return null;
    }

    @Nullable
    private static String getFilePath(PsiMethod psiMethod, String testName) {
        List<String> strings = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(psiMethod);
        if (strings != null && !strings.isEmpty()) {
            String s = strings.get(0);
            return new File(new File(s).getParent(), testName + "." + FileUtilRt.getExtension((String)new File(s).getName())).getPath();
        }
        return null;
    }

    @Nullable
    private static String getTestName(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework == null || TestDataGuessByExistingFilesUtil.isUtilityMethod(method, psiClass, framework)) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.getTestName(method.getName());
    }

    private static boolean isUtilityMethod(@NotNull PsiMethod method, @NotNull PsiClass psiClass, @NotNull TestFramework framework) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "isUtilityMethod"));
        }
        if (method == framework.findSetUpMethod((PsiElement)psiClass) || method == framework.findTearDownMethod((PsiElement)psiClass)) {
            return true;
        }
        if (framework.getClass().getName().contains("JUnit3")) {
            return !method.getName().startsWith("test");
        }
        if (framework.getClass().getName().contains("JUnit4")) {
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)false);
        }
        return false;
    }

    @NotNull
    public static String getTestName(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        String string = StringUtil.trimStart((String)methodName, (String)"test");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getTestName"));
        }
        return string;
    }

    @Nullable
    private static TestDataDescriptor buildDescriptorFromExistingTestData(final @NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptorFromExistingTestData"));
        }
        TestDataDescriptor cachedValue = (TestDataDescriptor)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<TestDataDescriptor>(){

            @Nullable
            public CachedValueProvider.Result<TestDataDescriptor> compute() {
                return new CachedValueProvider.Result((Object)TestDataGuessByExistingFilesUtil.buildDescriptor(method), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        return cachedValue == TestDataDescriptor.NOTHING_FOUND ? null : cachedValue;
    }

    private static TestDataDescriptor buildDescriptor(PsiMethod psiMethod) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class);
        String testName = TestDataGuessByExistingFilesUtil.getTestName(psiMethod);
        if (testName == null || psiClass == null) {
            return TestDataDescriptor.NOTHING_FOUND;
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass);
    }

    public static List<String> suggestTestDataFiles(@NotNull String testName, String testDataPath, @NotNull PsiClass psiClass) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "suggestTestDataFiles"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "suggestTestDataFiles"));
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass).generate(testName, testDataPath);
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull String test, @NotNull PsiClass psiClass) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        GotoFileModel gotoModel = new GotoFileModel(psiClass.getProject());
        HashSet descriptors = new HashSet();
        String possibleFileName = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)test, (String)"$"), (Object)test);
        assert (possibleFileName != null);
        String possibleFilePath = test.replace('$', '/');
        Collection<String> fileNames = TestDataGuessByExistingFilesUtil.getAllFileNames(possibleFileName, gotoModel);
        for (String name : fileNames) {
            Object[] elements;
            ProgressManager.checkCanceled();
            boolean currentNameProcessed = false;
            for (Object element : elements = gotoModel.getElementsByName(name, false, name)) {
                String fileName;
                int i;
                String filePath;
                VirtualFile file;
                if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || fileIndex.isInSource(file) && !fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || !(filePath = file.getPath()).contains(possibleFilePath) && !filePath.contains(test) || (i = (fileName = PathUtil.getFileName((String)filePath).toLowerCase()).indexOf(possibleFileName.toLowerCase())) < 0 || i + possibleFileName.length() < fileName.length() && Character.isDigit(fileName.charAt(i + possibleFileName.length()))) continue;
                TestLocationDescriptor current = new TestLocationDescriptor();
                current.populate(possibleFileName, file);
                if (!current.isComplete()) continue;
                currentNameProcessed = true;
                if (descriptors.isEmpty() || ((TestLocationDescriptor)descriptors.iterator().next()).dir.equals(current.dir) && !descriptors.contains(current)) {
                    descriptors.add(current);
                    continue;
                }
                if (!TestDataGuessByExistingFilesUtil.moreRelevantPath(current, (Set<TestLocationDescriptor>)descriptors, psiClass)) continue;
                descriptors.clear();
                descriptors.add(current);
            }
            if (!currentNameProcessed) continue;
            break;
        }
        TestDataDescriptor testDataDescriptor = new TestDataDescriptor((Collection<TestLocationDescriptor>)descriptors, possibleFileName);
        if (testDataDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "buildDescriptor"));
        }
        return testDataDescriptor;
    }

    private static Collection<String> getAllFileNames(final String testName, GotoFileModel model) {
        CommonProcessors.CollectProcessor<String> processor = new CommonProcessors.CollectProcessor<String>(){

            public boolean accept(String name) {
                ProgressManager.checkCanceled();
                return StringUtil.containsIgnoreCase((String)name, (String)testName);
            }
        };
        model.processNames((Processor)processor, false);
        return processor.getResults();
    }

    @Nullable
    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "getSimpleClassName"));
        }
        String result = psiClass.getQualifiedName();
        if (result == null) {
            return null;
        }
        int i = (result = StringUtil.trimEnd((String)result, (String)"Test")).lastIndexOf(46);
        if (i >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private static boolean moreRelevantPath(@NotNull TestLocationDescriptor candidate, @NotNull Set<TestLocationDescriptor> currentDescriptors, @NotNull PsiClass psiClass) {
        String simpleName;
        boolean currentMatched;
        boolean candidateMatched;
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        if (currentDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptors", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil", "moreRelevantPath"));
        }
        String className = psiClass.getQualifiedName();
        if (className == null) {
            return false;
        }
        TestLocationDescriptor current = currentDescriptors.iterator().next();
        int i = className.lastIndexOf(".");
        if (i >= 0) {
            String packageAsPath = className.substring(0, i).replace('.', '/').toLowerCase();
            candidateMatched = candidate.dir.toLowerCase().contains(packageAsPath);
            if (candidateMatched ^ (currentMatched = current.dir.toLowerCase().contains(packageAsPath))) {
                return candidateMatched;
            }
        }
        if ((simpleName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass)) != null) {
            String pattern = simpleName.toLowerCase();
            candidateMatched = candidate.dir.toLowerCase().contains(pattern);
            if (candidateMatched ^ (currentMatched = current.dir.toLowerCase().contains(pattern))) {
                return candidateMatched;
            }
        }
        return false;
    }

    private static class TestDataDescriptor {
        private static final TestDataDescriptor NOTHING_FOUND = new TestDataDescriptor(Collections.<TestLocationDescriptor>emptyList(), null);
        private final List<TestLocationDescriptor> myDescriptors = new ArrayList<TestLocationDescriptor>();
        private final String myTestName;

        TestDataDescriptor(Collection<TestLocationDescriptor> descriptors, String testName) {
            this.myTestName = testName;
            this.myDescriptors.addAll(descriptors);
        }

        public boolean isComplete() {
            if (this.myDescriptors.isEmpty()) {
                return false;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (descriptor.isComplete()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public List<String> generate(@NotNull String testName) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            List<String> list = this.generate(testName, null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            return list;
        }

        @NotNull
        public List<String> generate() {
            List<String> list = this.generate(this.myTestName, null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            return list;
        }

        @NotNull
        public List<String> generate(@NotNull String testName, String root) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            ArrayList<String> result = new ArrayList<String>();
            if (StringUtil.isEmpty((String)testName)) {
                ArrayList<String> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
                }
                return arrayList;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (root != null && !root.equals(descriptor.dir)) continue;
                result.add(String.format("%s/%s%c%s%s.%s", descriptor.dir, descriptor.filePrefix, Character.valueOf(descriptor.startWithLowerCase ? Character.toLowerCase(testName.charAt(0)) : Character.toUpperCase(testName.charAt(0))), testName.substring(1), descriptor.fileSuffix, descriptor.ext));
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor", "generate"));
            }
            return arrayList;
        }

        public String toString() {
            return this.myDescriptors.toString();
        }
    }

    private static class TestLocationDescriptor {
        public String dir;
        public String filePrefix;
        public String fileSuffix;
        public String ext;
        public boolean startWithLowerCase;

        private TestLocationDescriptor() {
        }

        public boolean isComplete() {
            return this.dir != null && this.filePrefix != null && this.fileSuffix != null && this.ext != null;
        }

        public void populate(@NotNull String testName, @NotNull VirtualFile matched) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor", "populate"));
            }
            if (matched == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matched", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor", "populate"));
            }
            if (testName.isEmpty()) {
                return;
            }
            String withoutExtension = FileUtil.getNameWithoutExtension((String)testName);
            boolean excludeExtension = !withoutExtension.equals(testName);
            testName = withoutExtension;
            String fileName = matched.getNameWithoutExtension();
            int i = fileName.indexOf(testName);
            char firstChar = testName.charAt(0);
            boolean testNameStartsWithLowerCase = Character.isLowerCase(firstChar);
            if (i < 0) {
                i = fileName.indexOf((testNameStartsWithLowerCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + testName.substring(1));
                this.startWithLowerCase = !testNameStartsWithLowerCase;
            } else {
                this.startWithLowerCase = testNameStartsWithLowerCase;
            }
            if (i < 0) {
                return;
            }
            this.filePrefix = fileName.substring(0, i);
            this.fileSuffix = fileName.substring(i + testName.length());
            this.ext = excludeExtension ? "" : matched.getExtension();
            this.dir = matched.getParent().getPath();
        }

        public int hashCode() {
            int result = this.dir != null ? this.dir.hashCode() : 0;
            result = 31 * result + (this.filePrefix != null ? this.filePrefix.hashCode() : 0);
            result = 31 * result + (this.fileSuffix != null ? this.fileSuffix.hashCode() : 0);
            result = 31 * result + (this.ext != null ? this.ext.hashCode() : 0);
            result = 31 * result + (this.startWithLowerCase ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestLocationDescriptor that = (TestLocationDescriptor)o;
            if (this.startWithLowerCase != that.startWithLowerCase) {
                return false;
            }
            if (this.dir != null ? !this.dir.equals(that.dir) : that.dir != null) {
                return false;
            }
            if (this.ext != null ? !this.ext.equals(that.ext) : that.ext != null) {
                return false;
            }
            if (this.filePrefix != null ? !this.filePrefix.equals(that.filePrefix) : that.filePrefix != null) {
                return false;
            }
            return !(this.fileSuffix != null ? !this.fileSuffix.equals(that.fileSuffix) : that.fileSuffix != null);
        }

        public String toString() {
            return String.format("%s/%s[...]%s.%s", this.dir, this.filePrefix, this.fileSuffix, this.ext);
        }
    }
}

