/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ConstantValueFactory factory;
    private final ModuleDescriptor module;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        ConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map<ValueParameterDescriptor, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass) && (constructor = (ConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)annotationClass.getConstructors())) != null) {
            void destination$iv$iv;
            Object object;
            void var14_15;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = constructor.getValueParameters();
            void var7_7 = $receiver$iv;
            int capacity$iv$iv22 = RangesKt.coerceAtLeast((int)((float)CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, 10) / 0.75f + 1.0f), 16);
            Iterator iterator2 = $receiver$iv$iv;
            Map map2 = new LinkedHashMap(capacity$iv$iv22);
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv$iv;
                var14_15 = destination$iv$iv$iv;
                object = it.getName();
                var14_15.put(object, element$iv$iv$iv);
            }
            void parameterByName = destination$iv$iv$iv;
            $receiver$iv = proto.getArgumentList();
            $receiver$iv$iv = $receiver$iv;
            Collection capacity$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Annotation.Argument argument = (ProtoBuf.Annotation.Argument)item$iv$iv;
                var14_15 = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                object = this.resolveArgument((ProtoBuf.Annotation.Argument)v1, (Map<Name, ? extends ValueParameterDescriptor>)parameterByName, nameResolver);
                var14_15.add(object);
            }
            arguments2 = MapsKt.toMap(CollectionsKt.filterNotNull((List)destination$iv$iv));
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<ValueParameterDescriptor, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull(value, "proto.value");
        return new Pair(parameter, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = this.factory.createByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = this.factory.createCharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = this.factory.createShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = this.factory.createIntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = this.factory.createLongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = this.factory.createFloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = this.factory.createDoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = this.factory.createBooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull(v2, "nameResolver.getString(value.stringValue)");
                v1 = this.factory.createStringValue(v2);
                break;
            }
            case 10: {
                v3 = PreconditionsKt.error("Class literal annotation arguments are not supported yet (" + nameResolver.getClassId(value.getClassId()) + ")");
                throw null;
            }
            case 11: {
                v4 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull(v4, "nameResolver.getClassId(value.classId)");
                v5 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull(v5, "nameResolver.getName(value.enumValueId)");
                v1 = this.resolveEnumValue(v4, v5);
                break;
            }
            case 12: {
                v6 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull(v6, "value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v6, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                arrayElements = value.getArrayElementList();
                if (CollectionsKt.isNotEmpty((Collection)arrayElements)) {
                    v7 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull(v7, "arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v7, nameResolver);
                    v8 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v8 == null) {
                        v8 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                    }
                } else if (expectedIsArray) {
                    v8 = expectedType;
                } else {
                    v9 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    v8 = v9;
                    Intrinsics.checkExpressionValueIsNotNull(v9, "builtIns.getArrayType(Va\u2026T, builtIns.getAnyType())");
                }
                actualArrayType = v8;
                v10 = this.getBuiltIns();
                if (expectedIsArray) {
                    v11 = expectedType;
                } else {
                    v12 = actualArrayType;
                    v11 = v12;
                    Intrinsics.checkExpressionValueIsNotNull(v12, "actualArrayType");
                }
                expectedElementType = v10.getArrayElementType(v11);
                var8_8 = arrayElements;
                var9_9 = this.factory;
                var10_10 = $receiver$iv;
                var11_11 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_14 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var15_15 = destination$iv$iv;
                    v13 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull(v13, "expectedElementType");
                    v14 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v14, "it");
                    var16_16 = this.resolveValue(v13, (ProtoBuf.Annotation.Argument.Value)v14, nameResolver);
                    var15_15.add(var16_16);
                }
                var15_15 = (List)destination$iv$iv;
                v15 = actualArrayType;
                Intrinsics.checkExpressionValueIsNotNull(v15, "actualArrayType");
                v1 = var9_9.createArrayValue(var15_15, v15);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v16 = PreconditionsKt.error("Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ")");
                throw null;
            }
        }
        result = v1;
        if (TypeUtilsKt.isSubtypeOf(result.getType(), expectedType)) {
            return result;
        }
        return this.factory.createErrorValue("Unexpected argument value");
    }

    private final ConstantValue<?> resolveEnumValue(ClassId enumClassId, Name enumEntryName) {
        ClassifierDescriptor enumEntry;
        ClassDescriptor enumClass = this.resolveClass(enumClassId);
        if (Intrinsics.areEqual((Object)enumClass.getKind(), (Object)ClassKind.ENUM_CLASS) && (enumEntry = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(enumEntryName, NoLookupLocation.FROM_DESERIALIZATION)) instanceof ClassDescriptor) {
            return this.factory.createEnumValue((ClassDescriptor)enumEntry);
        }
        return this.factory.createErrorValue("Unresolved enum entry: " + enumClassId + "." + enumEntryName);
    }

    /*
     * Unable to fully structure code
     */
    private final KotlinType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        receiver$iv = this.getBuiltIns();
        $receiver = receiver$iv;
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
            case 1: {
                v1 = $receiver.getByteType();
                break;
            }
            case 2: {
                v1 = $receiver.getCharType();
                break;
            }
            case 3: {
                v1 = $receiver.getShortType();
                break;
            }
            case 4: {
                v1 = $receiver.getIntType();
                break;
            }
            case 5: {
                v1 = $receiver.getLongType();
                break;
            }
            case 6: {
                v1 = $receiver.getFloatType();
                break;
            }
            case 7: {
                v1 = $receiver.getDoubleType();
                break;
            }
            case 8: {
                v1 = $receiver.getBooleanType();
                break;
            }
            case 9: {
                v1 = $receiver.getStringType();
                break;
            }
            case 10: {
                v2 = PreconditionsKt.error("Arrays of class literals are not supported yet");
                throw null;
            }
            case 11: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull(v3, "nameResolver.getClassId(value.classId)");
                v1 = this.resolveClass(v3).getDefaultType();
                break;
            }
            case 12: {
                v4 = nameResolver.getClassId(value.getAnnotation().getId());
                Intrinsics.checkExpressionValueIsNotNull(v4, "nameResolver.getClassId(value.annotation.id)");
                v1 = this.resolveClass(v4).getDefaultType();
                break;
            }
            case 13: {
                v5 = PreconditionsKt.error("Array of arrays is impossible");
                throw null;
            }
            default: lbl-1000:
            // 2 sources

            {
                v6 = PreconditionsKt.error("Unknown type: " + value.getType());
                throw null;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(v1, "when (value.type) {\n    \u2026type}\")\n                }");
        Intrinsics.checkExpressionValueIsNotNull(v1, "with(builtIns) {\n       \u2026          }\n            }");
        return v1;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.module, classId);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = ErrorUtils.createErrorClass(classId.asSingleFqName().asString());
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "ErrorUtils.createErrorCl\u2026ingleFqName().asString())");
        }
        return classDescriptor;
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        this.module = module;
        this.factory = new ConstantValueFactory(this.getBuiltIns());
    }
}

