/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IndexedValue;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "getAlignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "cellName", "alignmentInfo", "rowNumber", "", "processNode", "Alignment", "Companion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "getAlignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "cellName", "alignmentInfo", "rowNumber", "", "processNode", "Alignment", "Companion"})
public final class TablesGeneratingProvider
implements GeneratingProvider {
    @NotNull
    private static final Alignment DEFAULT_ALIGNMENT;
    @NotNull
    private static final Regex SPLIT_REGEX;
    public static final Companion Companion;

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)Intrinsics.areEqual((Object)node.getType(), (Object)GFMElementTypes.Companion.getTABLE()));
        List<Alignment> alignmentInfo = this.getAlignmentInfo(text, node);
        int rowsPopulated = 0;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "table", new CharSequence[0], false, 8, null);
        for (ASTNode child : node.getChildren()) {
            if (Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.Companion.getHEADER())) {
                visitor.consumeHtml("<thead>");
                this.populateRow(visitor, child, "th", alignmentInfo, -1);
                visitor.consumeHtml("</thead>");
                continue;
            }
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.Companion.getROW())) continue;
            if (rowsPopulated == 0) {
                visitor.consumeHtml("<tbody>");
            }
            this.populateRow(visitor, child, "td", alignmentInfo, ++rowsPopulated);
        }
        if (rowsPopulated > 0) {
            visitor.consumeHtml("</tbody>");
        }
        visitor.consumeTagClose("table");
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRow(HtmlGenerator.HtmlGeneratingVisitor visitor, ASTNode node, String cellName, List<? extends Alignment> alignmentInfo, int rowNumber) {
        Object alignment;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        String parityAttribute = rowNumber > 0 && rowNumber % 2 == 0 ? "class=\"intellij-row-even\"" : (String)null;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "tr", new CharSequence[]{parityAttribute}, false, 8, null);
        Iterable iterable = node.getChildren();
        void var10_8 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IndexedValue child : CollectionsKt.withIndex((Iterable)((List)destination$iv$iv))) {
            if (child.getIndex() >= alignmentInfo.size()) {
                throw (Throwable)new IllegalStateException("Too many cells in a row! Should check parser.");
            }
            alignment = alignmentInfo.get(child.getIndex());
            String alignmentAttribute = ((Alignment)((Object)alignment)).isDefault() ? (String)null : "align=" + "\"" + ((Alignment)((Object)alignment)).getHtmlName() + "\"";
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, (ASTNode)child.getValue(), cellName, new CharSequence[]{alignmentAttribute}, false, 8, null);
            visitor.visitNode((ASTNode)child.getValue());
            visitor.consumeTagClose(cellName);
        }
        alignment = node.getChildren();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ASTNode it = (ASTNode)element$iv;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
            ++count$iv;
        }
        int child = count$iv;
        int n = alignmentInfo.size() - 1;
        if (child <= n) {
            while (true) {
                void i;
                visitor.consumeHtml("<td></td>");
                if (i == n) break;
                ++i;
            }
        }
        visitor.consumeTagClose("tr");
    }

    /*
     * WARNING - void declaration
     */
    private final List<Alignment> getAlignmentInfo(String text, ASTNode node) {
        ArrayList<Alignment> result;
        block7: {
            ASTNode aSTNode = ASTUtilKt.findChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
            if (aSTNode == null) {
                throw (Throwable)new IllegalStateException("Could not find table separator");
            }
            ASTNode separatorRow = aSTNode;
            result = new ArrayList<Alignment>();
            List cells = Regex.split$default((Regex)Companion.getSPLIT_REGEX(), (CharSequence)ASTUtilKt.getTextInNode(separatorRow, text), (int)0, (int)2, null);
            IntRange intRange = CollectionsKt.getIndices((Collection)cells);
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            if (n > n2) break block7;
            while (true) {
                void i;
                block9: {
                    String cell;
                    block8: {
                        if (!StringsKt.isBlank((CharSequence)(cell = (String)cells.get((int)i)))) break block8;
                        void v2 = i;
                        boolean bl = true;
                        if (v2 < true) {
                            bl = false;
                        }
                        boolean bl2 = true;
                        if (v2 > CollectionsKt.getLastIndex((List)cells) - 1) {
                            bl2 = false;
                        }
                        if (!(bl & bl2)) break block9;
                    }
                    String trimmed = StringsKt.trim((String)cell);
                    boolean starts = StringsKt.startsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
                    boolean ends = StringsKt.endsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
                    result.add(starts && ends ? Alignment.CENTER : (starts ? Alignment.LEFT : (ends ? Alignment.RIGHT : Companion.getDEFAULT_ALIGNMENT())));
                }
                if (i == n2) break;
                ++i;
            }
        }
        return result;
    }

    static {
        Object object;
        block2: {
            Companion = new Companion(null);
            Object[] $receiver$iv = (Object[])Alignment.values();
            Object[] $receiver$iv$iv = $receiver$iv;
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object element$iv$iv = $receiver$iv$iv[i];
                Alignment it = (Alignment)((Object)element$iv$iv);
                if (!it.isDefault()) continue;
                object = element$iv$iv;
                break block2;
            }
            object = null;
        }
        Alignment alignment = (Alignment)((Object)object);
        if (alignment == null) {
            throw (Throwable)new IllegalStateException("Must me default alignment");
        }
        DEFAULT_ALIGNMENT = alignment;
        SPLIT_REGEX = new Regex("\\|");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT"})
    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT;
        public static final /* enum */ Alignment CENTER;
        public static final /* enum */ Alignment RIGHT;
        private static final /* synthetic */ Alignment[] $VALUES;
        @NotNull
        private final String htmlName;
        private final boolean isDefault;

        static {
            Alignment[] alignmentArray = new Alignment[3];
            Alignment[] alignmentArray2 = alignmentArray;
            alignmentArray[0] = LEFT = new Alignment("left", true);
            alignmentArray[1] = CENTER = new Alignment("center", false);
            alignmentArray[2] = RIGHT = new Alignment("right", false);
            $VALUES = alignmentArray;
        }

        @NotNull
        public final String getHtmlName() {
            return this.htmlName;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        protected Alignment(String htmlName, boolean isDefault) {
            Intrinsics.checkParameterIsNotNull((Object)htmlName, (String)"htmlName");
            this.htmlName = htmlName;
            this.isDefault = isDefault;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n"}, strings={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"})
    public static final class Companion {
        @NotNull
        public final Alignment getDEFAULT_ALIGNMENT() {
            return DEFAULT_ALIGNMENT;
        }

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

