/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\n2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0014J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "tableColumnsNumber", "", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;I)V", "currentLine", "getCurrentLine", "()I", "setCurrentLine", "(I)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "fillCells", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "isTableLine", "line", "", "Companion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\n2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0014J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "tableColumnsNumber", "", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;I)V", "currentLine", "getCurrentLine", "()I", "setCurrentLine", "(I)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "fillCells", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "isTableLine", "line", "", "Companion"})
public final class GitHubTableMarkerBlock
extends MarkerBlockImpl {
    private int currentLine;
    private final ProductionHolder productionHolder;
    private final int tableColumnsNumber;
    @NotNull
    private static final Regex SPLIT_REGEX;
    public static final Companion Companion;

    public final int getCurrentLine() {
        return this.currentLine;
    }

    public final void setCurrentLine(int n) {
        this.currentLine = n;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        int n = this.currentLine++;
        if (this.currentLine == 1) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR)));
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String line = pos.getCurrentLine();
        if (!this.isTableLine(line)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        List<SequentialParser.Node> cellsAndSeps = this.fillCells(pos);
        this.productionHolder.addProduction(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(((Number)((SequentialParser.Node)CollectionsKt.first(cellsAndSeps)).getRange().getStart()).intValue(), ((Number)((SequentialParser.Node)CollectionsKt.last(cellsAndSeps)).getRange().getEndInclusive()).intValue()), GFMElementTypes.Companion.getROW())), (Iterable)cellsAndSeps));
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return GFMElementTypes.Companion.getTABLE();
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SequentialParser.Node> fillCells(LookaheadText.Position pos) {
        ArrayList<SequentialParser.Node> result;
        block9: {
            int n;
            result = new ArrayList<SequentialParser.Node>();
            int offset = pos.getOffset();
            if (pos.getOffsetInCurrentLine() == -1) {
                offset += 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine());
            }
            CharSequence line = this.getConstraints().eatItselfFromString(pos.getCurrentLine());
            List cells = Regex.split$default((Regex)Companion.getSPLIT_REGEX(), (CharSequence)line, (int)0, (int)2, null);
            int cellNodesAdded = 0;
            IntRange intRange = CollectionsKt.getIndices((Collection)cells);
            int n2 = intRange.getFirst();
            if (n2 > (n = intRange.getLast())) break block9;
            while (true) {
                void i;
                String cell;
                block11: {
                    block10: {
                        if (!StringsKt.isBlank((CharSequence)(cell = (String)cells.get((int)i)))) break block10;
                        void v1 = i;
                        boolean bl = true;
                        if (v1 < true) {
                            bl = false;
                        }
                        boolean bl2 = true;
                        if (v1 > CollectionsKt.getLastIndex((List)cells) - 1) {
                            bl2 = false;
                        }
                        if (!(bl & bl2)) break block11;
                    }
                    result.add(new SequentialParser.Node(new IntRange(offset, offset + cell.length()), GFMTokenTypes.CELL));
                    ++cellNodesAdded;
                }
                offset += cell.length();
                if (i < CollectionsKt.getLastIndex((List)cells)) {
                    result.add(new SequentialParser.Node(new IntRange(offset, offset + 1), GFMTokenTypes.TABLE_SEPARATOR));
                }
                ++offset;
                if (cellNodesAdded >= this.tableColumnsNumber) {
                    if (offset >= pos.getNextLineOrEofOffset()) break;
                    result.add(new SequentialParser.Node(new IntRange(offset, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR));
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }

    private final boolean isTableLine(CharSequence line) {
        return GitHubTableMarkerProvider.Companion.contains(line, '|');
    }

    public GitHubTableMarkerBlock(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder, int tableColumnsNumber) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        super(constraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.tableColumnsNumber = tableColumnsNumber;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset(), pos.getNextLineOrEofOffset()), GFMElementTypes.Companion.getHEADER())));
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)this.fillCells(pos));
    }

    static {
        Companion = new Companion(null);
        SPLIT_REGEX = new Regex("\\|");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock$Companion;", "", "()V", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock$Companion;", "", "()V", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"})
    public static final class Companion {
        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

