/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016"}, d2={"Lorg/intellij/markdown/html/CodeFenceGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;"})
@KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016"}, strings={"Lorg/intellij/markdown/html/CodeFenceGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;"})
public final class CodeFenceGeneratingProvider
implements GeneratingProvider {
    /*
     * WARNING - void declaration
     */
    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Object[] objectArray;
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor;
        ASTNode aSTNode;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        int indentBefore = StringsKt.commonPrefixWith$default((CharSequence)ASTUtilKt.getTextInNode(node, text), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)10), (boolean)false, (int)2, null).length();
        visitor.consumeHtml("<pre>");
        boolean state = false;
        List<ASTNode> childrenToConsider = node.getChildren();
        if (Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last(childrenToConsider)).getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) {
            childrenToConsider = childrenToConsider.subList(0, childrenToConsider.size() - 1);
        }
        boolean lastChildWasContent = false;
        ArrayList<String> attributes = new ArrayList<String>();
        for (ASTNode aSTNode2 : childrenToConsider) {
            void $receiver$iv;
            if (state && CollectionsKt.listOf((Object[])new IElementType[]{MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.EOL}).contains(aSTNode2.getType())) {
                visitor.consumeHtml(HtmlGenerator.Companion.trimIndents(HtmlGenerator.Companion.leafText(text, aSTNode2, false), indentBefore));
                lastChildWasContent = Intrinsics.areEqual((Object)aSTNode2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT);
            }
            if (!state && Intrinsics.areEqual((Object)aSTNode2.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) {
                attributes.add("class=" + "\"" + "language-" + (String)StringsKt.split$default((CharSequence)StringsKt.trim((String)((Object)HtmlGenerator.Companion.leafText$default(HtmlGenerator.Companion, text, aSTNode2, false, 4, null)).toString()), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null).get(0) + "\"");
            }
            if (state || !Intrinsics.areEqual((Object)aSTNode2.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            Collection collection = attributes;
            charSequence = "code";
            aSTNode = node;
            htmlGeneratingVisitor = visitor;
            Collection thisCollection$iv = (Collection)$receiver$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = stringArray;
            CharSequence[] charSequenceArray = (CharSequence[])objectArray;
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(htmlGeneratingVisitor, aSTNode, charSequence, Arrays.copyOf(charSequenceArray, charSequenceArray.length), false, 8, null);
            state = true;
        }
        if (!state) {
            Collection collection = attributes;
            charSequence = "code";
            aSTNode = node;
            htmlGeneratingVisitor = visitor;
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = stringArray;
            CharSequence[] charSequenceArray = (CharSequence[])objectArray;
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(htmlGeneratingVisitor, aSTNode, charSequence, Arrays.copyOf(charSequenceArray, charSequenceArray.length), false, 8, null);
        }
        if (lastChildWasContent) {
            visitor.consumeHtml("\n");
        }
        visitor.consumeHtml("</code></pre>");
    }
}

