/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes"})
@KotlinClass(version={1, 1, 0}, data={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, strings={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes"})
public final class EntityConverter {
    private static final String escapeAllowedString = "\\!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}\\~";
    private static final Map<Character, String> replacements;
    private static final Regex REGEX;
    private static final Regex REGEX_ESCAPES;
    public static final EntityConverter INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        String string;
        block23: {
            MatchResult matchResult;
            block22: {
                void this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Regex regex = processEscapes ? REGEX_ESCAPES : REGEX;
                matchResult = Regex.find$default((Regex)this_$iv, (CharSequence)text, (int)0, (int)2, null);
                if (matchResult != null) break block22;
                string = ((Object)text).toString();
                break block23;
            }
            MatchResult match$iv = matchResult;
            int lastStart$iv = 0;
            int length$iv = text.length();
            StringBuilder sb$iv = new StringBuilder(length$iv);
            do {
                Object object;
                StringBuilder stringBuilder;
                MatchResult foundMatch$iv;
                block25: {
                    void match;
                    block27: {
                        void $receiver$iv;
                        Integer code;
                        Integer n;
                        MatchGroupCollection g;
                        block26: {
                            block24: {
                                char c;
                                if (match$iv == null) {
                                    Intrinsics.throwNpe();
                                }
                                sb$iv.append(text, lastStart$iv, ((Number)foundMatch$iv.getRange().getStart()).intValue());
                                MatchResult matchResult2 = foundMatch$iv;
                                stringBuilder = sb$iv;
                                g = match.getGroups();
                                if (g.size() <= 5 || g.get(5) == null) break block24;
                                MatchGroup matchGroup = g.get(5);
                                if (matchGroup == null) {
                                    Intrinsics.throwNpe();
                                }
                                if ((object = replacements.get(Character.valueOf(c = matchGroup.getValue().charAt(0)))) == null) {
                                    object = String.valueOf(c);
                                }
                                break block25;
                            }
                            if (g.get(4) == null) break block26;
                            MatchGroup matchGroup = g.get(4);
                            if (matchGroup == null) {
                                Intrinsics.throwNpe();
                            }
                            if ((object = replacements.get(Character.valueOf(matchGroup.getValue().charAt(0)))) == null) {
                                object = match.getValue();
                            }
                            break block25;
                        }
                        if (!processEntities) {
                            n = null;
                        } else if (g.get(1) != null) {
                            n = Entities.INSTANCE.getMap().get(match.getValue());
                        } else if (g.get(2) != null) {
                            MatchGroup matchGroup = g.get(2);
                            if (matchGroup == null) {
                                Intrinsics.throwNpe();
                            }
                            n = Integer.parseInt(matchGroup.getValue());
                        } else if (g.get(3) != null) {
                            MatchGroup matchGroup = g.get(3);
                            if (matchGroup == null) {
                                Intrinsics.throwNpe();
                            }
                            n = Integer.parseInt(matchGroup.getValue(), 16);
                        } else {
                            n = null;
                        }
                        if ((object = (code = n)) == null) break block27;
                        Character c = Character.valueOf((char)((Number)object).intValue());
                        char it = ((Character)$receiver$iv).charValue();
                        Object object2 = replacements.get(Character.valueOf(it));
                        if (object2 == null) {
                            object2 = object = String.valueOf(it);
                        }
                        if (object2 != null) break block25;
                    }
                    object = "&amp;" + StringsKt.substring((String)match.getValue(), (int)1);
                }
                Object object3 = object;
                stringBuilder.append((CharSequence)object3);
                lastStart$iv = ((Number)foundMatch$iv.getRange().getEndInclusive()).intValue() + 1;
                match$iv = foundMatch$iv.next();
            } while (lastStart$iv < length$iv && match$iv != null);
            if (lastStart$iv < length$iv) {
                sb$iv.append(text, lastStart$iv, length$iv);
            }
            String string2 = sb$iv.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        }
        return string;
    }

    private EntityConverter() {
        INSTANCE = this;
        escapeAllowedString = escapeAllowedString;
        replacements = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)"&quot;"), TuplesKt.to((Object)Character.valueOf('&'), (Object)"&amp;"), TuplesKt.to((Object)Character.valueOf('<'), (Object)"&lt;"), TuplesKt.to((Object)Character.valueOf('>'), (Object)"&gt;")});
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|" + "\\" + "\\" + "([" + escapeAllowedString + "])");
    }

    static {
        new EntityConverter();
    }
}

