/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0002"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "calcTailStartPos", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "headerSize", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/ranges/IntRange;", "Companion"})
@KotlinClass(version={1, 1, 0}, data={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0006\u001a\u00060\u0007R\u00020\bH\u0002"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "calcTailStartPos", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "headerSize", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/ranges/IntRange;", "Companion"})
public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    private static final Regex REGEX;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        IntRange headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf((Object)new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, ((Number)headerRange.getEndInclusive()).intValue()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int offset;
        CharSequence line = pos.getCurrentLineFromPosition();
        for (offset = line.length() - 1; offset > headerSize && Character.isWhitespace(line.charAt(offset)); --offset) {
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            --offset;
        }
        if (offset + 1 < line.length() && Character.isWhitespace(line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.matches(pos) != null;
    }

    private final IntRange matches(LookaheadText.Position pos) {
        MatchResult matchResult;
        if (pos.getOffsetInCurrentLine() != -1 && (matchResult = Regex.find$default((Regex)Companion.getREGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2, null)) != null) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            if (matchGroup == null) {
                Intrinsics.throwNpe();
            }
            return matchGroup.getRange();
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("^ {0,3}(#{1,6})( |$)");
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"})
    public static final class Companion {
        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

