/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.hierarchy;

import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrStubIndexer {
    @Nullable
    public static IndexTree.Unit translate(int fileId, GrFileStub grFileStub) {
        if (grFileStub.isScript()) {
            return new IndexTree.Unit(fileId, null, IndexTree.GROOVY, IndexTree.Import.EMPTY_ARRAY, IndexTree.ClassDecl.EMPTY_ARRAY);
        }
        String pid = null;
        ArrayList<IndexTree.ClassDecl> classList = new ArrayList<IndexTree.ClassDecl>();
        HashSet<String> usedNames = new HashSet<String>();
        for (Object el : grFileStub.getChildrenStubs()) {
            IndexTree.ClassDecl classDecl;
            GrPackageDefinitionStub packageStub;
            String pkgName;
            if (el instanceof GrPackageDefinitionStub && (pkgName = (packageStub = (GrPackageDefinitionStub)((Object)el)).getPackageName()) != null) {
                pid = GrStubIndexer.id(pkgName, false, null);
            }
            if (!(el instanceof GrTypeDefinitionStub) || (classDecl = GrStubIndexer.processClassDecl((GrTypeDefinitionStub)((Object)el), usedNames)) == null) continue;
            classList.add(classDecl);
        }
        ArrayList<IndexTree.Import> importList = new ArrayList<IndexTree.Import>();
        for (StubElement el : grFileStub.getChildrenStubs()) {
            if (!(el instanceof GrImportStatementStub)) continue;
            GrStubIndexer.processImport((GrImportStatementStub)el, importList, usedNames);
        }
        IndexTree.ClassDecl[] classes = classList.isEmpty() ? IndexTree.ClassDecl.EMPTY_ARRAY : classList.toArray(new IndexTree.ClassDecl[classList.size()]);
        IndexTree.Import[] imports = importList.isEmpty() ? IndexTree.Import.EMPTY_ARRAY : importList.toArray(new IndexTree.Import[importList.size()]);
        return new IndexTree.Unit(fileId, pid, IndexTree.GROOVY, imports, classes);
    }

    @Nullable
    private static IndexTree.Decl processMember(StubElement<?> el, Set<String> namesCache) {
        GrTypeDefinitionStub classStub;
        if (el instanceof GrTypeDefinitionStub && !(classStub = (GrTypeDefinitionStub)el).isAnonymousInQualifiedNew()) {
            return GrStubIndexer.processClassDecl(classStub, namesCache);
        }
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        for (StubElement childElement : el.getChildrenStubs()) {
            IndexTree.Decl innerDef = GrStubIndexer.processMember(childElement, namesCache);
            if (innerDef == null) continue;
            innerList.add(innerDef);
        }
        return innerList.isEmpty() ? null : new IndexTree.MemberDecl(innerList.toArray(new IndexTree.Decl[innerList.size()]));
    }

    @Nullable
    private static IndexTree.ClassDecl processClassDecl(GrTypeDefinitionStub classStub, Set<String> namesCache) {
        ArrayList<String> superList = new ArrayList<String>();
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        if (classStub.isAnonymous()) {
            for (String s : classStub.getSuperClassNames()) {
                superList.add(GrStubIndexer.id(s, true, namesCache));
            }
        }
        for (StubElement el : classStub.getChildrenStubs()) {
            IndexTree.Decl member;
            if (el instanceof GrReferenceListStub) {
                GrReferenceListStub refList = (GrReferenceListStub)el;
                if (el.getStubType() == GroovyElementTypes.IMPLEMENTS_CLAUSE || el.getStubType() == GroovyElementTypes.EXTENDS_CLAUSE) {
                    for (String extName : refList.getBaseClasses()) {
                        superList.add(GrStubIndexer.id(extName, true, namesCache));
                    }
                }
            }
            if ((member = GrStubIndexer.processMember(el, namesCache)) == null) continue;
            innerList.add(member);
        }
        int flags = GrStubIndexer.translateFlags(classStub);
        String[] supers = superList.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(superList);
        IndexTree.Decl[] inners = innerList.isEmpty() ? IndexTree.Decl.EMPTY_ARRAY : innerList.toArray(new IndexTree.Decl[innerList.size()]);
        return new IndexTree.ClassDecl(classStub.id, flags, classStub.getName(), supers, inners);
    }

    private static int translateFlags(GrTypeDefinitionStub classStub) {
        int flags = 0;
        if (classStub.isInterface()) {
            flags |= 0x10;
        }
        if (classStub.isEnum()) {
            flags |= 0x40;
        }
        if (classStub.isAnnotationType()) {
            flags |= 0x20;
        }
        if (GrStubUtils.isGroovyStaticMemberStub(classStub)) {
            flags |= 8;
        }
        return flags;
    }

    private static void processImport(GrImportStatementStub imp, List<IndexTree.Import> imports, Set<String> namesCache) {
        String fullName = PsiNameHelper.getQualifiedClassName((String)imp.getReferenceText(), (boolean)true);
        if (imp.isOnDemand() || namesCache.contains(GrStubIndexer.shortName(fullName))) {
            imports.add(new IndexTree.Import(fullName, imp.isStatic(), imp.isOnDemand(), imp.getAliasName()));
        }
    }

    private static String id(String s, boolean cacheFirstId, Set<String> namesCache) {
        String id = PsiNameHelper.getQualifiedClassName((String)s, (boolean)true);
        if (cacheFirstId) {
            int index = id.indexOf(46);
            String firstId = index > 0 ? s.substring(0, index) : id;
            namesCache.add(firstId);
        }
        return id;
    }

    private static String shortName(String s) {
        int dotIndex = s.lastIndexOf(46);
        return dotIndex > 0 ? s.substring(dotIndex + 1) : null;
    }
}

