/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.ActivitySelector;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.GfxTracer;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import icons.AndroidIcons;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GfxTraceCaptureAction
extends ToggleAction {
    @NotNull
    protected final GpuMonitorView myView;
    @NotNull
    protected final String myText;
    private ListenableFuture<GfxTracer> myPending;
    private GfxTracer myActive;

    public GfxTraceCaptureAction(@NotNull GpuMonitorView view, @Nullable String text, @Nullable String description, @Nullable Icon icon) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction", "<init>"));
        }
        super(text, description, icon);
        this.myPending = null;
        this.myActive = null;
        this.myView = view;
        this.myText = text;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myPending != null || this.myActive != null;
    }

    public final void setSelected(AnActionEvent e, boolean state) {
        if (this.myPending != null) {
            this.myPending.cancel(true);
            this.myPending = null;
            return;
        }
        if (this.myActive != null) {
            this.myActive.stop();
            this.myActive = null;
            return;
        }
        this.myPending = this.start(e);
        this.myPending.addListener(new Runnable(){

            @Override
            public void run() {
                if (GfxTraceCaptureAction.this.myPending != null) {
                    GfxTraceCaptureAction.this.myActive = (GfxTracer)Futures.getUnchecked((Future)GfxTraceCaptureAction.this.myPending);
                    GfxTraceCaptureAction.this.myPending = null;
                }
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    public final void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!GapiPaths.isValid()) {
            presentation.setEnabled(false);
            presentation.setText(this.myText + " : GPU debugger tools not installed");
        } else if (this.myPending == null && this.myActive == null) {
            presentation.setEnabled(this.isEnabled());
            presentation.setText(this.myText + " : start tracing");
        } else {
            presentation.setEnabled(true);
            presentation.setText(this.myText + " : stop tracing");
        }
    }

    boolean isEnabled() {
        return this.myView.getDeviceContext().getSelectedDevice() != null && GapiPaths.isValid();
    }

    abstract ListenableFuture<GfxTracer> start(AnActionEvent var1);

    public static class Launch
    extends GfxTraceCaptureAction {
        private static final String NOTIFICATION_GROUP = "GPU trace";
        private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE = "Rooted device required";
        private static final String NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT = "The device needs to be rooted in order to launch an application for GPU tracing.<br/>To trace your own application on a non-rooted device, build your application with the GPU tracing library.";

        public Launch(@NotNull GpuMonitorView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Launch", "<init>"));
            }
            super(view, "Launch", "Launch in GFX trace mode", AndroidIcons.GfxTrace.InjectSpy);
        }

        @Override
        ListenableFuture<GfxTracer> start(AnActionEvent event) {
            final IDevice device = this.myView.getDeviceContext().getSelectedDevice();
            if (device == null) {
                return null;
            }
            final SettableFuture future = SettableFuture.create();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (device.root()) {
                            Launch.this.showLauncher(device, (SettableFuture<GfxTracer>)future);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            Notifications.Bus.notify((Notification)new Notification(Launch.NOTIFICATION_GROUP, Launch.NOTIFICATION_LAUNCH_REQUIRES_ROOT_TITLE, Launch.NOTIFICATION_LAUNCH_REQUIRES_ROOT_CONTENT, NotificationType.ERROR));
                        }
                    });
                    future.set(null);
                }
            });
            return future;
        }

        private ListenableFuture<GfxTracer> showLauncher(final IDevice device, final SettableFuture<GfxTracer> future) {
            DeviceInfo.PkgInfoProvider provider = new DeviceInfo.PkgInfoProvider(device);
            ActivitySelector.Listener listener = new ActivitySelector.Listener(){

                @Override
                public void OnLaunch(DeviceInfo.Package pkg, DeviceInfo.Activity act) {
                    GfxTracer.Options options = new GfxTracer.Options();
                    future.set((Object)GfxTracer.launch(Launch.this.myView.getProject(), device, pkg, act, options, Launch.this.myView.getEvents()));
                }

                @Override
                public void OnCancel() {
                    future.set(null);
                }
            };
            final ActivitySelector selector = new ActivitySelector(provider, listener);
            selector.setTitle("Launch activity...");
            selector.setVisible(true);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    selector.setVisible(false);
                }
            }, (Executor)EdtExecutor.INSTANCE);
            return future;
        }
    }

    public static class Listen
    extends GfxTraceCaptureAction {
        public Listen(@NotNull GpuMonitorView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/editors/gfxtrace/actions/GfxTraceCaptureAction$Listen", "<init>"));
            }
            super(view, "Listen", "Listen for GFX traces", AndroidIcons.GfxTrace.ListenForTrace);
        }

        @Override
        ListenableFuture<GfxTracer> start(AnActionEvent event) {
            IDevice device = this.myView.getDeviceContext().getSelectedDevice();
            if (device == null) {
                return null;
            }
            GfxTracer.Options options = new GfxTracer.Options();
            GfxTracer tracer = GfxTracer.listen(this.myView.getProject(), device, options, this.myView.getEvents());
            return Futures.immediateFuture((Object)tracer);
        }
    }
}

