/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.renderers.ImageCellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.widgets.CellComboBox;
import com.android.tools.idea.editors.gfxtrace.widgets.CellList;
import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintable;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public abstract class ImageCellController<T extends ImageCellList.Data>
extends Controller
implements CellWidget.SelectionListener<T>,
CellRenderer.CellLoader<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ImageCellController.class);
    @NotNull
    protected CellWidget<T, ?> myList;

    public ImageCellController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ImageCellController", "<init>"));
        }
        super(editor);
    }

    protected ImageCellController<T> usingListWidget(@NotNull CellList.Orientation orientation, String emptyText, final Dimension maxCellSize) {
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/editors/gfxtrace/controllers/ImageCellController", "usingListWidget"));
        }
        this.myList = new ImageCellList<T>(orientation, emptyText, this){

            @Override
            protected Dimension getMaxCellSize() {
                return maxCellSize;
            }
        };
        this.myList.addSelectionListener(this);
        return this;
    }

    protected ImageCellController<T> usingComboBoxWidget(final Dimension imageSize) {
        this.myList = new CellComboBox<T>(this){

            @Override
            protected CellRenderer<T> createCellRenderer(CellRenderer.CellLoader<T> loader) {
                return new ImageCellRenderer<T>(loader, imageSize){
                    {
                        this.setMinimumIconSize(imageSize);
                    }

                    @Override
                    protected Repaintable getRepaintable(JList list) {
                        return Repaintables.forComponents(list, myComponent);
                    }

                    @Override
                    public Dimension getInitialCellSize() {
                        return new Dimension(imageSize.width + 2 * ImageCellRenderer.BORDER_SIZE, imageSize.height + 2 * ImageCellRenderer.BORDER_SIZE);
                    }
                };
            }
        };
        this.myList.addSelectionListener(this);
        return this;
    }

    protected void loadCellImage(final T cell, ServiceClient client, Path imagePath, final Runnable onLoad) {
        ((CellWidget.Data)cell).startLoading();
        Futures.addCallback(FetchedImage.load(client, imagePath), (FutureCallback)new LoadingCallback<FetchedImage>(LOG, cell){

            public void onSuccess(final FetchedImage fetchedImage) {
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        cell.icon = fetchedImage.icon;
                        cell.stopLoading();
                        onLoad.run();
                        ImageCellController.this.myList.repaint();
                    }
                });
            }
        });
    }
}

