/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElementParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaProjectElementParser;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        buildDslFile.parse();
        GradleBuildModel gradleBuildModel = new GradleBuildModel(buildDslFile);
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "<init>"));
        }
        super(buildDslFile);
    }

    @Nullable
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getProperty("android", AndroidDslElement.class);
        return androidDslElement != null ? new AndroidModel(androidDslElement) : null;
    }

    @NotNull
    public GradleBuildModel addAndroidModel() {
        if (this.android() != null) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addAndroidModel"));
            }
            return gradleBuildModel;
        }
        AndroidDslElement androidDslElement = new AndroidDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("android", androidDslElement);
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addAndroidModel"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removeAndroidModel() {
        this.myGradleDslFile.removeProperty("android");
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removeAndroidModel"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public Dependencies dependencies() {
        Dependencies dependencies = ((GradleBuildDslFile)this.myGradleDslFile).myDependencies;
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "dependencies"));
        }
        return dependencies;
    }

    @Nullable
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getProperty("ext", ExtDslElement.class);
        return extDslElement != null ? new ExtModel(extDslElement) : null;
    }

    @NotNull
    public GradleBuildModel addExtModel() {
        if (this.ext() != null) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addExtModel"));
            }
            return gradleBuildModel;
        }
        ExtDslElement extDslElement = new ExtDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("ext", extDslElement);
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addExtModel"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removeExtModel() {
        this.myGradleDslFile.removeProperty("ext");
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removeExtModel"));
        }
        return gradleBuildModel;
    }

    @Nullable
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getProperty("java", JavaDslElement.class);
        return javaDslElement != null ? new JavaModel(javaDslElement) : null;
    }

    @NotNull
    public GradleBuildModel addJavaModel() {
        if (this.java() != null) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addJavaModel"));
            }
            return gradleBuildModel;
        }
        JavaDslElement javaDslElement = new JavaDslElement(this.myGradleDslFile);
        this.myGradleDslFile.setNewElement("java", javaDslElement);
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "addJavaModel"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removeJavaModel() {
        this.myGradleDslFile.removeProperty("java");
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removeJavaModel"));
        }
        return gradleBuildModel;
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        @NotNull
        private Dependencies myDependencies;
        private final GradleDslElementParser[] myParsers;

        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            super(file, project, moduleName);
            this.myDependencies = new Dependencies(this);
            this.myParsers = new GradleDslElementParser[]{new JavaProjectElementParser()};
        }

        @Override
        public void reparse() {
            this.myDependencies = new Dependencies(this);
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "parse"));
            }
            this.myDependencies.setPsiFile((PsiFile)psiFile);
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    if (GradleBuildDslFile.this.myDependencies.parse(e)) {
                        return;
                    }
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    boolean parsed = false;
                    for (GradleDslElementParser parser : GradleBuildDslFile.this.myParsers) {
                        if (!parser.parse(e, GradleBuildDslFile.this)) continue;
                        parsed = true;
                        break;
                    }
                    if (!parsed) {
                        GradleDslParser.parse(e, GradleBuildDslFile.this);
                    }
                }
            }));
        }

        @Override
        protected void reset() {
            super.reset();
            this.myDependencies.resetState();
        }

        @Override
        protected void apply() {
            super.apply();
            this.myDependencies.applyChanges();
        }
    }
}

