/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralMap;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public abstract class GradlePropertiesDslElement
extends GradleDslElement {
    @NotNull
    protected Map<String, GradleDslElement> myProperties;
    @NotNull
    protected Map<String, GradleDslElement> myToBeAddedProperties;
    @NotNull
    protected Set<String> myToBeRemovedProperties;

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "<init>"));
        }
        super(parent, psiElement, name);
        this.myProperties = Maps.newHashMap();
        this.myToBeAddedProperties = Maps.newHashMap();
        this.myToBeRemovedProperties = Sets.newHashSet();
    }

    public void setDslElement(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setDslElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setDslElement"));
        }
        this.myProperties.put(property, element);
    }

    public void addDslElement(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addDslElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addDslElement"));
        }
        this.myProperties.put(property, element);
    }

    protected void addAsDslLiteralList(@NotNull String property, GradleDslLiteral dslLiteral) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addAsDslLiteralList"));
        }
        GroovyPsiElement psiElement = dslLiteral.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslLiteralList literalList = new GradleDslLiteralList(this, psiElement, property, dslLiteral.getLiteral());
        this.myProperties.put(property, literalList);
    }

    public void addToDslLiteralList(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToDslLiteralList"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToDslLiteralList"));
        }
        GroovyPsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GrLiteral[] literalsToAdd = null;
        if (element instanceof GradleDslLiteral) {
            literalsToAdd = new GrLiteral[]{((GradleDslLiteral)element).getLiteral()};
        } else if (element instanceof GradleDslLiteralList) {
            List<GradleDslLiteral> gradleDslLiterals = ((GradleDslLiteralList)element).getElements();
            literalsToAdd = new GrLiteral[gradleDslLiterals.size()];
            for (int i = 0; i < gradleDslLiterals.size(); ++i) {
                literalsToAdd[i] = gradleDslLiterals.get(i).getLiteral();
            }
        }
        if (literalsToAdd == null) {
            return;
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.add(psiElement, property, literalsToAdd);
            return;
        }
        gradleDslLiteralList = new GradleDslLiteralList(this, psiElement, property, literalsToAdd);
        this.myProperties.put(property, gradleDslLiteralList);
    }

    @NotNull
    public GradlePropertiesDslElement setNewElement(@NotNull String property, @NotNull GradleDslElement newElement) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        this.myToBeAddedProperties.put(property, newElement);
        this.setModified(true);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public Collection<String> getProperties() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.myProperties.keySet());
        result.addAll(this.myToBeAddedProperties.keySet());
        result.removeAll(this.myToBeRemovedProperties);
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperties"));
        }
        return hashSet;
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyElement"));
        }
        if (!property.contains(".")) {
            if (this.myToBeRemovedProperties.contains(property)) {
                return null;
            }
            GradleDslElement toBeAddedElement = this.myToBeAddedProperties.get(property);
            return toBeAddedElement != null ? toBeAddedElement : this.myProperties.get(property);
        }
        List propertyNameSegments = Splitter.on((char)'.').splitToList((CharSequence)property);
        GradlePropertiesDslElement nestedElement = this;
        for (int i = 0; i < propertyNameSegments.size() - 1; ++i) {
            GradleDslElement element = nestedElement.getPropertyElement((String)propertyNameSegments.get(i));
            if (!(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            nestedElement = (GradlePropertiesDslElement)element;
        }
        return nestedElement.getPropertyElement((String)propertyNameSegments.get(propertyNameSegments.size() - 1));
    }

    @Nullable
    public <T> T getProperty(@NotNull String property, @NotNull Class<T> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperty"));
        }
        GradleDslElement propertyElement = this.getPropertyElement(property);
        if (propertyElement != null) {
            if (clazz.isInstance(propertyElement)) {
                return clazz.cast(propertyElement);
            }
            if (propertyElement instanceof GradleDslLiteral) {
                return ((GradleDslLiteral)propertyElement).getValue(clazz);
            }
        }
        return null;
    }

    @NotNull
    public GradlePropertiesDslElement setLiteralProperty(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setLiteralPropertyImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setLiteralProperty(@NotNull String property, @NotNull Integer value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setLiteralPropertyImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setLiteralProperty(@NotNull String property, @NotNull Boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setLiteralPropertyImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement setLiteralPropertyImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralPropertyImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralPropertyImpl"));
        }
        GradleDslLiteral literalElement = this.getProperty(property, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, property);
            this.myToBeAddedProperties.put(property, literalElement);
        }
        literalElement.setValue(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setLiteralPropertyImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement addToListProperty(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.addToListPropertyImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromListProperty(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.removeFromListPropertyImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInListProperty(@NotNull String property, @NotNull String oldValue, @NotNull String newValue) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListProperty"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListProperty"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.replaceInListPropertyImpl(property, oldValue, newValue);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement addToListPropertyImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListPropertyImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListPropertyImpl"));
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList == null) {
            gradleDslLiteralList = new GradleDslLiteralList(this, property);
            this.myToBeAddedProperties.put(property, gradleDslLiteralList);
        }
        gradleDslLiteralList.add(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToListPropertyImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement removeFromListPropertyImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListPropertyImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListPropertyImpl"));
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.remove(value);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromListPropertyImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement replaceInListPropertyImpl(@NotNull String property, @NotNull Object oldValue, @NotNull Object newValue) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListPropertyImpl"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListPropertyImpl"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListPropertyImpl"));
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.replace(oldValue, newValue);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInListPropertyImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInMapProperty(@NotNull String property, @NotNull String name, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInMapPropertyImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInMapProperty(@NotNull String property, @NotNull String name, @NotNull Integer value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInMapPropertyImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInMapProperty(@NotNull String property, @NotNull String name, @NotNull Boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInMapPropertyImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapProperty"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement setInMapPropertyImpl(@NotNull String property, @NotNull String name, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapPropertyImpl"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapPropertyImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapPropertyImpl"));
        }
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap == null) {
            gradleDslLiteralMap = new GradleDslLiteralMap(this, property);
            this.myToBeAddedProperties.put(property, gradleDslLiteralMap);
        }
        gradleDslLiteralMap.put(name, value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInMapPropertyImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromMapProperty(@NotNull String property, @NotNull String name) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromMapProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromMapProperty"));
        }
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap != null) {
            gradleDslLiteralMap.removeProperty(name);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromMapProperty"));
        }
        return gradlePropertiesDslElement;
    }

    public void removeProperty(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeProperty"));
        }
        this.myToBeRemovedProperties.add(property);
        this.setModified(true);
    }

    @Nullable
    public <E> List<E> getListProperty(@NotNull String property, @NotNull Class<E> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getListProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getListProperty"));
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            return gradleDslLiteralList.getValues(clazz);
        }
        return null;
    }

    @Nullable
    public <V> Map<String, V> getMapProperty(@NotNull String property, @NotNull Class<V> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getMapProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getMapProperty"));
        }
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap != null) {
            return gradleDslLiteralMap.getValues(clazz);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ArrayList children = Lists.newArrayList();
        for (String property : this.getProperties()) {
            GradleDslElement element = this.getPropertyElement(property);
            if (element == null) continue;
            children.add(element);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getChildren"));
        }
        return arrayList;
    }

    @Override
    protected void apply() {
        for (Map.Entry<String, GradleDslElement> entry : this.myToBeAddedProperties.entrySet()) {
            String property = entry.getKey();
            GradleDslElement element = entry.getValue();
            if (element.create() == null) continue;
            this.setDslElement(property, element);
        }
        this.myToBeAddedProperties.clear();
        for (String property : this.myToBeRemovedProperties) {
            GradleDslElement element = this.myProperties.remove(property);
            if (element == null) continue;
            element.delete();
        }
        this.myToBeRemovedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.resetState();
        }
    }

    protected void clear() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        this.myProperties.clear();
    }
}

