/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.LanguageLevelUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class JavaVersionDslElement
extends GradleDslElement {
    @Nullable
    private String myText;
    @Nullable
    private LanguageLevel myUnsavedValue;

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @Nullable GrExpression psiElement, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "<init>"));
        }
        super(parent, (GroovyPsiElement)psiElement, name);
        if (psiElement != null) {
            this.myText = psiElement.getText();
        }
    }

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "<init>"));
        }
        this(parent, (GrExpression)null, name);
    }

    @Override
    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
        super.setPsiElement(psiElement);
        if (psiElement != null) {
            this.myText = psiElement.getText();
        }
    }

    public GrExpression getPsiElement() {
        return (GrExpression)super.getPsiElement();
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "getChildren"));
        }
        return list;
    }

    @Nullable
    public LanguageLevel getVersion() {
        if (this.myText != null) {
            return LanguageLevelUtil.parseFromGradleString(this.myText);
        }
        return null;
    }

    public void setVersion(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "setVersion"));
        }
        this.myUnsavedValue = languageLevel;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        if (this.myUnsavedValue == null || this.getPsiElement() == null) {
            return;
        }
        String groovyString = LanguageLevelUtil.convertToGradleString(this.myUnsavedValue, this.myText);
        GrExpression expression = GroovyPsiElementFactory.getInstance((Project)this.getPsiElement().getProject()).createExpressionFromText((CharSequence)groovyString);
        this.setPsiElement((GroovyPsiElement)((GrExpression)this.getPsiElement().replace((PsiElement)expression)));
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        JavaDslElement java = (JavaDslElement)this.myParent;
        assert (java != null);
        GroovyPsiElement javaPsiElement = java.create();
        assert (javaPsiElement != null);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)javaPsiElement.getProject());
        GrExpression anchor = null;
        GrExpression value = null;
        JavaVersionDslElement javaVersionElement = java.getProperty(JavaModel.SOURCE_COMPATIBILITY_FIELD, JavaVersionDslElement.class);
        if (javaVersionElement != null) {
            anchor = javaVersionElement.getPsiElement();
            value = javaVersionElement.getPsiElement();
        }
        if (anchor == null && (javaVersionElement = java.getProperty(JavaModel.TARGET_COMPATIBILITY_FIELD, JavaVersionDslElement.class)) != null) {
            anchor = javaVersionElement.getPsiElement();
            value = javaVersionElement.getPsiElement();
        }
        if (anchor == null) {
            anchor = javaPsiElement.getLastChild();
            value = factory.createLiteralFromValue((Object)"1.6");
        }
        GrAssignmentExpression expression = (GrAssignmentExpression)factory.createExpressionFromText((CharSequence)(this.myName + " = " + value.getText()));
        GrAssignmentExpression added = (GrAssignmentExpression)javaPsiElement.addAfter((PsiElement)expression, anchor == null ? null : anchor.getParent());
        this.setPsiElement((GroovyPsiElement)added.getRValue());
        return this.getPsiElement();
    }

    @Override
    protected void delete() {
        GrExpression psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        if (psiElement.getParent() != null) {
            psiElement.getParent().delete();
        }
    }
}

