/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.quickfix.AbstractGradleDependencyFix;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddGradleJUnitDependencyFix
extends AbstractGradleDependencyFix {
    @NotNull
    private final String myClassName;
    private final boolean myIsJunit4;

    public AddGradleJUnitDependencyFix(@NotNull Module module, @NotNull PsiReference reference, @NotNull String className, boolean isJunit4) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleJUnitDependencyFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AddGradleJUnitDependencyFix", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/gradle/quickfix/AddGradleJUnitDependencyFix", "<init>"));
        }
        super(module, reference);
        this.myClassName = className;
        this.myIsJunit4 = isJunit4;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"orderEntry.fix.add.junit.jar.to.classpath", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleJUnitDependencyFix", "getText"));
        }
        return string;
    }

    public void invoke(final @NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleJUnitDependencyFix", "invoke"));
        }
        ExternalDependencySpec newDependency = new ExternalDependencySpec("junit", "junit", "3.8.1");
        if (this.myIsJunit4) {
            newDependency.version = "4.12";
        }
        String configurationName = AddGradleJUnitDependencyFix.getConfigurationName(this.myModule, AddGradleJUnitDependencyFix.isTestScope(this.myModule, this.myReference));
        this.addDependencyAndSync(configurationName, newDependency, new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                PsiClass[] psiClassArray;
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(AddGradleJUnitDependencyFix.this.myClassName, GlobalSearchScope.moduleWithLibrariesScope((Module)AddGradleJUnitDependencyFix.this.myModule));
                if (aClass != null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = aClass;
                } else {
                    psiClassArray = null;
                }
                return psiClassArray;
            }
        }, editor);
    }
}

