/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.resources.Density;
import com.android.tools.idea.npw.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.CommonAssetSetStep;
import com.android.tools.idea.npw.IconPicker;
import com.android.tools.idea.ui.VectorImageComponent;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorAssetSetStep
extends CommonAssetSetStep {
    private static final Logger LOG = Logger.getInstance(VectorAssetSetStep.class);
    public static final String ANDROID_DEFAULT_SIZE = "24";
    public static final int MAX_VECTOR_DRAWABLE_SIZE = 4096;
    public static final int MIN_VECTOR_DRAWABLE_SIZE = 1;
    private JPanel myPanel;
    private JLabel myError;
    private JLabel myDescription;
    private VectorImageComponent myImagePreview;
    private TextFieldWithBrowseButton myImageFile;
    private JLabel myImageFileLabel;
    private JLabel myResourceNameLabel;
    private JTextField myResourceNameField;
    private JPanel myErrorPanel;
    private JLabel myConvertError;
    private HyperlinkLabel myMoreErrors;
    private MoreErrorHyperlinkAdapter myMoreErrorHyperlinkAdapter;
    private JButton myIconPickerButton;
    private JLabel myIconLabel;
    private JPanel myIconPickerPanel;
    private JRadioButton myLocalSVGFilesRadioButton;
    private JRadioButton myMaterialIconsRadioButton;
    private JPanel myImageFileBrowserPanel;
    private JTextField myWidthTextField;
    private JTextField myHeightTextField;
    private JCheckBox myEnableAutoMirroredCheckBox;
    private JPanel myPreviewPanel;
    private JPanel myFilePanel;
    private JPanel myPropertyPanel;
    private JSlider myOpacitySlider;
    private JCheckBox myUseManualSizeCheckBox;
    private JPanel myResizePanel;
    private JPanel mySliderPanel;
    private JLabel myOpacityLabel;
    private JLabel mySizeLabel;
    private JLabel myDpXLabel;
    private JLabel myDpLabel;
    private JPanel myIconPickerAndFileBrowserPanel;
    private JPanel myResourceNamePanel;
    private AbstractAction myEnterKeyButtonAction;

    public VectorAssetSetStep(TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable VirtualFile invocationTarget) {
        super(state, project, module, sidePanelIcon, updateListener, invocationTarget);
        this.$$$setupUI$$$();
        this.myMoreErrorHyperlinkAdapter = new MoreErrorHyperlinkAdapter();
        this.myEnterKeyButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JButton) {
                    JButton button = (JButton)e.getSource();
                    button.doClick();
                }
            }
        };
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myPanel);
        this.myImageFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"svg"));
        this.myTemplateState.put("assetType", AssetStudioAssetGenerator.AssetType.ACTIONBAR.name());
        this.mySelectedAssetType = AssetStudioAssetGenerator.AssetType.ACTIONBAR;
        this.register("assetName", this.myResourceNameField);
        this.myMoreErrors.addHyperlinkListener((HyperlinkListener)((Object)this.myMoreErrorHyperlinkAdapter));
        this.myErrorPanel.setVisible(false);
        this.register("sourceType", this.myMaterialIconsRadioButton, (Object)AssetStudioAssetGenerator.SourceType.VECTORDRAWABLE);
        this.register("sourceType", this.myLocalSVGFilesRadioButton, (Object)AssetStudioAssetGenerator.SourceType.SVG);
        this.myEnableAutoMirroredCheckBox.setSelected(false);
        this.myWidthTextField.setText(ANDROID_DEFAULT_SIZE);
        this.myHeightTextField.setText(ANDROID_DEFAULT_SIZE);
        this.myWidthTextField.setEnabled(false);
        this.myHeightTextField.setEnabled(false);
        this.register("vectorDrawableWidth", this.myWidthTextField);
        this.register("vectorDrawableHeight", this.myHeightTextField);
        this.register("vectorDrawableOpacity", this.myOpacitySlider);
        this.register("vectorDrawableAutoMirror", this.myEnableAutoMirroredCheckBox);
        this.myIconPickerButton.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "DoClick");
        this.myIconPickerButton.getActionMap().put("DoClick", this.myEnterKeyButtonAction);
        this.myIconPickerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorAssetSetStep.this.displayVectorIconDialog();
            }
        });
        this.myTemplateState.put("originalWidth", 0);
        this.myTemplateState.put("originalHeight", 0);
        this.myUseManualSizeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String finalWidthString = VectorAssetSetStep.ANDROID_DEFAULT_SIZE;
                String finalHeightString = VectorAssetSetStep.ANDROID_DEFAULT_SIZE;
                if (event.getStateChange() == 1) {
                    int originalWidth = VectorAssetSetStep.this.myTemplateState.getInt("originalWidth");
                    int originalHeight = VectorAssetSetStep.this.myTemplateState.getInt("originalHeight");
                    if (originalWidth > 0 && originalHeight > 0) {
                        finalWidthString = String.valueOf(originalWidth);
                        finalHeightString = String.valueOf(originalHeight);
                    }
                    VectorAssetSetStep.this.myWidthTextField.setEnabled(true);
                    VectorAssetSetStep.this.myHeightTextField.setEnabled(true);
                } else {
                    VectorAssetSetStep.this.myWidthTextField.setEnabled(false);
                    VectorAssetSetStep.this.myHeightTextField.setEnabled(false);
                }
                VectorAssetSetStep.this.myWidthTextField.setText(finalWidthString);
                VectorAssetSetStep.this.myHeightTextField.setText(finalHeightString);
            }
        });
    }

    private boolean isVectorPathEmpty() {
        AssetStudioAssetGenerator.SourceType sourceType = (AssetStudioAssetGenerator.SourceType)((Object)this.myTemplateState.get("sourceType"));
        boolean isPathEmpty = sourceType == AssetStudioAssetGenerator.SourceType.SVG ? !this.myTemplateState.hasAttr("imagePath") || this.myTemplateState.getString("imagePath").isEmpty() : !this.myTemplateState.hasAttr("vectorLibIconPath") || this.myTemplateState.get("vectorLibIconPath") == null;
        return isPathEmpty;
    }

    @Nullable
    private String getVectorFileNameWithoutExtension() {
        URL url;
        String fileName = null;
        AssetStudioAssetGenerator.SourceType sourceType = (AssetStudioAssetGenerator.SourceType)((Object)this.myTemplateState.get("sourceType"));
        if (sourceType == AssetStudioAssetGenerator.SourceType.SVG) {
            String path;
            if (this.myTemplateState.hasAttr("imagePath") && !(path = this.myTemplateState.getString("imagePath")).isEmpty()) {
                fileName = PathUtil.getFileName((String)path);
                fileName = FileUtil.getNameWithoutExtension((String)fileName);
            }
        } else if (this.myTemplateState.hasAttr("vectorLibIconPath") && (url = (URL)this.myTemplateState.get("vectorLibIconPath")) != null) {
            fileName = PathUtil.getFileName((String)url.getPath());
            fileName = FileUtil.getNameWithoutExtension((String)fileName);
        }
        return fileName;
    }

    @Override
    public void deriveValues() {
        super.deriveValues();
        if (!this.myTemplateState.myModified.contains("assetName")) {
            this.updateDerivedValue("assetName", this.myResourceNameField, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return VectorAssetSetStep.this.computeResourceName();
                }
            });
        }
        this.togglePropertiesPanel(!this.isVectorPathEmpty());
        if (this.myMaterialIconsRadioButton.isSelected()) {
            ((CardLayout)this.myIconPickerAndFileBrowserPanel.getLayout()).show(this.myIconPickerAndFileBrowserPanel, "IconPicker");
        } else {
            assert (this.myLocalSVGFilesRadioButton.isSelected());
            ((CardLayout)this.myIconPickerAndFileBrowserPanel.getLayout()).show(this.myIconPickerAndFileBrowserPanel, "SvgFileBrowser");
        }
    }

    private void togglePropertiesPanel(boolean enable) {
        if (!enable) {
            if (this.myUseManualSizeCheckBox.isSelected()) {
                this.myUseManualSizeCheckBox.setSelected(false);
            }
            if (this.myEnableAutoMirroredCheckBox.isSelected()) {
                this.myEnableAutoMirroredCheckBox.setSelected(false);
            }
            if (this.myOpacitySlider.getValue() != 100) {
                this.myOpacitySlider.setValue(100);
            }
        }
        this.myUseManualSizeCheckBox.setEnabled(enable);
        this.myEnableAutoMirroredCheckBox.setEnabled(enable);
        this.myOpacitySlider.setEnabled(enable);
        this.myOpacityLabel.setEnabled(enable);
        this.myDpXLabel.setEnabled(enable);
        this.myDpLabel.setEnabled(enable);
        this.mySizeLabel.setEnabled(enable);
    }

    @Override
    protected void updatePreviewImages() {
        if (this.mySelectedAssetType != null && this.myImageMap != null && this.myImageMap.size() != 0 && !this.isVectorPathEmpty()) {
            String errorMessage = (String)this.myTemplateState.get("errorLog");
            if (Strings.isNullOrEmpty((String)errorMessage)) {
                this.myErrorPanel.setVisible(false);
                this.myIsValid = true;
            } else {
                this.myErrorPanel.setVisible(true);
                this.myIsValid = this.setupErrorMessages(errorMessage);
            }
            BufferedImage previewImage = VectorAssetSetStep.getImage(this.myImageMap, Density.ANYDPI.getResourceValue());
            VectorAssetSetStep.setIconOrClear(this.myImagePreview, previewImage);
        } else {
            this.myIsValid = false;
            VectorAssetSetStep.setIconOrClear(this.myImagePreview, null);
        }
        this.myUpdateListener.update();
    }

    private boolean setupErrorMessages(String errorMessage) {
        boolean isPreviewValid = this.myTemplateState.getBoolean("validPreview");
        int firstLineBreak = errorMessage.indexOf("\n");
        boolean moreErrors = firstLineBreak > 0 && firstLineBreak < errorMessage.length() - 1;
        String firstLineError = moreErrors ? errorMessage.substring(0, firstLineBreak) : errorMessage;
        this.myConvertError.setText(firstLineError);
        if (moreErrors) {
            this.myMoreErrors.setVisible(true);
            this.myMoreErrors.setHyperlinkText("More...");
            this.myMoreErrorHyperlinkAdapter.setErrorMessage(errorMessage);
        } else {
            this.myMoreErrors.setVisible(false);
        }
        return isPreviewValid;
    }

    @Nullable
    private static BufferedImage getImage(@NotNull Map<String, Map<String, BufferedImage>> map, @NotNull String name) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/npw/VectorAssetSetStep", "getImage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/VectorAssetSetStep", "getImage"));
        }
        Map<String, BufferedImage> images = map.get(name);
        if (images == null) {
            return null;
        }
        Collection<BufferedImage> values = images.values();
        return values.isEmpty() ? null : values.iterator().next();
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    protected void initialize() {
        this.register("imagePath", this.myImageFile);
    }

    @Override
    @NotNull
    protected String computeResourceName() {
        String resourceName = this.getVectorFileNameWithoutExtension();
        if (resourceName == null) {
            resourceName = "ic_vector_name";
        }
        if (this.drawableExists(resourceName)) {
            int i = 1;
            while (this.drawableExists(resourceName + Integer.toString(i))) {
                ++i;
            }
            resourceName = resourceName + Integer.toString(i);
        }
        String string = resourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/VectorAssetSetStep", "computeResourceName"));
        }
        return string;
    }

    @Override
    protected void generateAssetFiles(File targetResDir) {
        this.myAssetGenerator.outputXmlToRes(targetResDir);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myIconPickerButton;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/VectorAssetSetStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/VectorAssetSetStep", "getError"));
        }
        return jLabel;
    }

    private void displayVectorIconDialog() {
        DialogBuilder builder = new DialogBuilder((Component)this.myPanel);
        IconPicker ip = new IconPicker(builder);
        builder.setCenterPanel((JComponent)ip);
        builder.setTitle("Select Icon");
        if (!builder.showAndGet()) {
            return;
        }
        this.myTemplateState.put("vectorLibIconPath", ip.getSelectIcon().getURL());
        this.update();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        JSlider jSlider;
        JPanel jPanel2;
        JLabel jLabel4;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JButton jButton;
        JLabel jLabel5;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel6;
        JPanel jPanel5;
        JPanel jPanel6;
        JTextField jTextField;
        JLabel jLabel7;
        JPanel jPanel7;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel8;
        VectorImageComponent vectorImageComponent;
        JPanel jPanel9;
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JPanel jPanel10;
        JPanel jPanel11;
        this.myPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.setPreferredSize(new Dimension(-1, -1));
        jPanel11.setToolTipText("");
        jPanel11.setMinimumSize(new Dimension(720, 512));
        this.myErrorPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setEnabled(true);
        jPanel11.add((Component)jPanel10, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Error", 0, 0, null, null));
        this.myDescription = jLabel10 = new JLabel();
        jLabel10.setText("");
        ((Component)jLabel10).setVisible(false);
        jPanel10.add((Component)jLabel10, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 3, null, null, null));
        this.myError = jLabel9 = new JLabel();
        jLabel9.setVerticalTextPosition(3);
        jLabel9.setText(" ");
        jPanel10.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 3, null, null, null));
        this.myConvertError = jLabel8 = new JLabel();
        jLabel8.setText("");
        jPanel10.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myMoreErrors = hyperlinkLabel = new HyperlinkLabel();
        jPanel10.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myPreviewPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(20, 20, 20, 20), -1, -1, false, false));
        jPanel11.add((Component)jPanel9, new GridConstraints(1, 0, 1, 3, 1, 0, 6, 6, new Dimension(350, 350), null, null));
        this.myImagePreview = vectorImageComponent = new VectorImageComponent();
        jPanel9.add((Component)((Object)vectorImageComponent), new GridConstraints(0, 0, 1, 1, 1, 0, 3, 7, new Dimension(256, 256), new Dimension(256, 256), null, 1));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Vector Drawable Preview");
        jPanel9.add((Component)jLabel11, new GridConstraints(1, 0, 1, 1, 1, 0, 0, 0, null, null, null));
        this.myFilePanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 2, new Dimension(320, 160), null, null));
        this.myMaterialIconsRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Material Icon");
        jRadioButton2.setSelected(true);
        jPanel8.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(144, 60), null));
        this.myLocalSVGFilesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Local SVG file");
        jPanel8.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(124, 60), null));
        this.myResourceNamePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 2, new Dimension(150, 30), null, null));
        this.myResourceNameLabel = jLabel7 = new JLabel();
        jLabel7.setText("Resource name:");
        jPanel7.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 7, new Dimension(-1, 15), null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(-1, 20), null, null));
        this.myIconPickerAndFileBrowserPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new CardLayout(0, 0));
        jPanel8.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 2, new Dimension(150, 30), null, null));
        this.myImageFileBrowserPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, "SvgFileBrowser");
        this.myImageFileLabel = jLabel6 = new JLabel();
        jLabel6.setText("Image file:");
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 40), null, null));
        this.myImageFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myIconPickerPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, "IconPicker");
        this.myIconLabel = jLabel5 = new JLabel();
        jLabel5.setText("Icon:");
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIconPickerButton = jButton = new JButton();
        jButton.setText("Choose");
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPropertyPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 8, 2, 3, 2, new Dimension(320, 160), null, null));
        this.myEnableAutoMirroredCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable auto mirroring for RTL layout");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 6, new Dimension(-1, 20), null, null));
        this.myOpacityLabel = jLabel4 = new JLabel();
        jLabel4.setText("Opacity:");
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 18), null, null, 1));
        this.mySliderPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(-1, 20), null, null));
        this.myOpacitySlider = jSlider = new JSlider();
        jSlider.setMinorTickSpacing(10);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTrack(true);
        jSlider.setValue(100);
        jSlider.setMajorTickSpacing(20);
        jSlider.setPaintTicks(true);
        jPanel2.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, new Dimension(-1, 40), null, null, 3));
        this.myResizePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 20, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, new Dimension(150, 60), null, null));
        this.mySizeLabel = jLabel3 = new JLabel();
        jLabel3.setText("Size:");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(-1, 25), null, null));
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        this.myWidthTextField = jFormattedTextField;
        jFormattedTextField.setText("");
        jPanel12.add((Component)jFormattedTextField, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), null, null));
        this.myDpXLabel = jLabel2 = new JLabel();
        jLabel2.setText("dp  X");
        jPanel12.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JFormattedTextField jFormattedTextField2 = new JFormattedTextField();
        this.myHeightTextField = jFormattedTextField2;
        jPanel12.add((Component)jFormattedTextField2, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), null, null));
        this.myDpLabel = jLabel = new JLabel();
        jLabel.setText("dp");
        jPanel12.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseManualSizeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Override default size from Material Design");
        jCheckBox.setSelected(false);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(1);
        ((Component)jSeparator).setForeground(new Color(-16777216));
        ((Component)jSeparator).setBackground(new Color(-5987164));
        jSeparator.putClientProperty("html.disable", Boolean.FALSE);
        jPanel11.add((Component)jSeparator, new GridConstraints(0, 1, 1, 1, 0, 2, 6, 3, null, new Dimension(2, 100), null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public class MoreErrorHyperlinkAdapter
    extends HyperlinkAdapter {
        private String mErrorLog;

        public void setErrorMessage(String error) {
            this.mErrorLog = error;
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            JTextArea textArea = new JTextArea(25, 80);
            textArea.setText(this.mErrorLog);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textArea);
            JOptionPane.showMessageDialog(VectorAssetSetStep.this.myPanel, scrollPane);
        }
    }
}

