/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HaxmInstallSettingsStep
extends FirstRunWizardStep {
    private static final int MAJOR_TICKS = 4;
    private static final int MINOR_TICKS = 512;
    private static final int MAX_TICK_RESOLUTION = 32;
    private static final int MIN_EMULATOR_MEMORY = 512;
    private final ScopedStateStore.Key<Integer> myKeyEmulatorMemory;
    private final int myRecommendedMemorySize;
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<Boolean> myKeyInstallHaxm;
    private JPanel myRoot;
    private HyperlinkLabel myIntelHAXMDocumentationButton;
    private JSlider myMemorySlider;
    private JSpinner myMemorySize;
    private JLabel myUnitLabel;
    private JButton myRecommended;

    public HaxmInstallSettingsStep(ScopedStateStore.Key<Boolean> keyCustomInstall, ScopedStateStore.Key<Boolean> keyInstallHaxm, ScopedStateStore.Key<Integer> keyEmulatorMemory) {
        super("Emulator Settings");
        this.myKeyCustomInstall = keyCustomInstall;
        this.myKeyInstallHaxm = keyInstallHaxm;
        this.$$$setupUI$$$();
        this.myUnitLabel.setText(Haxm.UI_UNITS.toString());
        this.myKeyEmulatorMemory = keyEmulatorMemory;
        long memorySize = Haxm.getMemorySize();
        this.myIntelHAXMDocumentationButton.setHyperlinkText("Intel\u00ae HAXM Documentation");
        this.myIntelHAXMDocumentationButton.setHyperlinkTarget("https://software.intel.com/android/articles/intel-hardware-accelerated-execution-manager");
        this.myRecommendedMemorySize = HaxmInstallSettingsStep.setupSliderAndSpinner(memorySize, this.myMemorySlider, this.myMemorySize);
        this.setComponent(this.myRoot);
        this.myRecommended.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HaxmInstallSettingsStep.this.myState.put(HaxmInstallSettingsStep.this.myKeyEmulatorMemory, HaxmInstallSettingsStep.this.myRecommendedMemorySize);
            }
        });
    }

    private static int setupSliderAndSpinner(long memorySize, JSlider slider, JSpinner spinner) {
        int recommendedMemorySize = FirstRunWizardDefaults.getRecommendedHaxmMemory(memorySize);
        int maxMemory = Math.max(HaxmInstallSettingsStep.getMaxMemoryAllocation(memorySize), recommendedMemorySize);
        int ticks = Math.min(maxMemory / 32, 512);
        slider.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
        slider.setMinimum(512);
        slider.setMaximum(maxMemory);
        slider.setMinorTickSpacing(maxMemory / ticks);
        slider.setMajorTickSpacing(maxMemory / 4);
        Hashtable<Integer, JComponent> labels = new Hashtable<Integer, JComponent>();
        int totalMemory = (int)(memorySize / Haxm.UI_UNITS.getNumberOfBytes());
        int labelSpacing = totalMemory / 4;
        int minDistanceBetweenLabels = labelSpacing / 4;
        for (int i = maxMemory; i >= labelSpacing; i -= labelSpacing) {
            if (Math.abs(i - recommendedMemorySize) <= minDistanceBetweenLabels) continue;
            labels.put(i, new JLabel(HaxmInstallSettingsStep.getMemoryLabel(i)));
        }
        if (recommendedMemorySize > minDistanceBetweenLabels) {
            labels.put(512, new JLabel(HaxmInstallSettingsStep.getMemoryLabel(512)));
        }
        labels.put(recommendedMemorySize, HaxmInstallSettingsStep.createRecommendedSizeLabel(recommendedMemorySize));
        slider.setLabelTable(labels);
        spinner.setModel(new SpinnerNumberModel(512, 512, maxMemory, maxMemory / ticks));
        return recommendedMemorySize;
    }

    private static JComponent createRecommendedSizeLabel(int memorySize) {
        String labelText = String.format("<html><center>%s<br>(Recommended)<center></html>", HaxmInstallSettingsStep.getMemoryLabel(memorySize));
        final Font boldLabelFont = UIUtil.getLabelFont().deriveFont(1);
        return new JLabel(labelText){

            @Override
            public Font getFont() {
                return boldLabelFont;
            }
        };
    }

    private static int getMaxMemoryAllocation(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long maxMemory = memorySize > 4L * GB ? memorySize - 2L * GB : memorySize / 2L;
        return (int)(maxMemory / Haxm.UI_UNITS.getNumberOfBytes());
    }

    private static String getMemoryLabel(int memorySize) {
        return new Storage((long)memorySize * Haxm.UI_UNITS.getNumberOfBytes()).toString();
    }

    @Override
    public boolean isStepVisible() {
        return !SystemInfo.isLinux && Boolean.TRUE.equals(this.myState.get(this.myKeyCustomInstall)) && !Boolean.FALSE.equals(this.myState.get(this.myKeyInstallHaxm));
    }

    @Override
    public void init() {
        this.register(this.myKeyEmulatorMemory, this.myMemorySlider);
        this.register(this.myKeyEmulatorMemory, this.myMemorySize, new SpinnerBinding());
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemorySlider;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JSpinner jSpinner;
        HyperlinkLabel hyperlinkLabel;
        JSlider jSlider;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>We have detected that your system can run the Android emulator in an accelerated performance mode.</html>");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>Please set the maximum amount of RAM available for the Intel\u00ae Hardware Accelerated Execution Manager (HAXM) to use for all x86 emulator instances. You can change these settings at any time by running the Intel\u00ae HAXM installer.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(700, -1), null));
        this.myMemorySlider = jSlider = new JSlider();
        jSlider.setMaximum(512);
        jSlider.setPaintLabels(true);
        jSlider.setMajorTickSpacing(32);
        jSlider.setPaintTicks(false);
        jSlider.setSnapToTicks(true);
        jSlider.setMinorTickSpacing(0);
        jSlider.setValueIsAdjusting(false);
        jSlider.setPaintTrack(true);
        jPanel.add((Component)jSlider, new GridConstraints(5, 0, 1, 1, 0, 1, 0, 6, null, null, new Dimension(750, -1)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Please refer to the ");
        Component component = jPanel2.add(jLabel4);
        this.myIntelHAXMDocumentationButton = hyperlinkLabel = new HyperlinkLabel();
        Component component2 = jPanel2.add((Component)hyperlinkLabel);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(" for more information.");
        Component component3 = jPanel2.add(jLabel5);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 1, 4, 2, 0, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("RAM allocation: ");
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myMemorySize = jSpinner = new JSpinner();
        jPanel3.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myUnitLabel = jLabel = new JLabel();
        jLabel.setText("MiB");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecommended = jButton = new JButton();
        jButton.setText("Use recommended size");
        jPanel3.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class SpinnerBinding
    extends ScopedDataBinder.ComponentBinding<Integer, JSpinner> {
        private SpinnerBinding() {
        }

        @Override
        public void setValue(@Nullable Integer newValue, @NotNull JSpinner component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/wizard/HaxmInstallSettingsStep$SpinnerBinding", "setValue"));
            }
            component.setValue(newValue);
        }

        @Override
        @Nullable
        public Integer getValue(@NotNull JSpinner component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/wizard/HaxmInstallSettingsStep$SpinnerBinding", "getValue"));
            }
            return (Integer)component.getValue();
        }

        @Override
        public void addChangeListener(@NotNull ChangeListener listener, @NotNull JSpinner component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/welcome/wizard/HaxmInstallSettingsStep$SpinnerBinding", "addChangeListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/wizard/HaxmInstallSettingsStep$SpinnerBinding", "addChangeListener"));
            }
            component.addChangeListener(listener);
        }
    }
}

