/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.resources.FrameworkResources;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.resourceManagers.FilteredAttributeDefinitions;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.FrameworkResourceLoader;
import org.jetbrains.android.uipreview.LayoutLibraryLoader;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidTargetData");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private volatile AttributeDefinitionsImpl myAttrDefs;
    private volatile LayoutLibrary myLayoutLibrary;
    private final Object myPublicResourceCacheLock;
    private volatile Map<String, Set<String>> myPublicResourceCache;
    private TIntObjectHashMap<String> myPublicResourceIdMap;
    private volatile MyStaticConstantsData myStaticConstantsData;
    private FrameworkResources myFrameworkResources;

    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "org/jetbrains/android/sdk/AndroidTargetData", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidTargetData", "<init>"));
        }
        this.myPublicResourceCacheLock = new Object();
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @Nullable
    public AttributeDefinitions getPublicAttrDefs(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidTargetData", "getPublicAttrDefs"));
        }
        AttributeDefinitionsImpl attrDefs = this.getAllAttrDefs(project);
        return attrDefs != null ? new PublicAttributeDefinitions(attrDefs) : null;
    }

    @Nullable
    public AttributeDefinitionsImpl getAllAttrDefs(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidTargetData", "getAllAttrDefs"));
        }
        if (this.myAttrDefs == null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    String attrsPath = FileUtil.toSystemIndependentName((String)AndroidTargetData.this.myTarget.getPath(8));
                    String attrsManifestPath = FileUtil.toSystemIndependentName((String)AndroidTargetData.this.myTarget.getPath(9));
                    XmlFile[] files = AndroidTargetData.findXmlFiles(project, new String[]{attrsPath, attrsManifestPath});
                    if (files != null) {
                        AndroidTargetData.this.myAttrDefs = new AttributeDefinitionsImpl(files);
                    }
                }
            });
        }
        return this.myAttrDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Set<String>> getPublicResourceCache() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceCache == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TIntObjectHashMap<String> getPublicIdMap() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceIdMap == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceIdMap;
        }
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/sdk/AndroidTargetData", "isResourcePublic"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/sdk/AndroidTargetData", "isResourcePublic"));
        }
        Map<String, Set<String>> publicResourceCache = this.getPublicResourceCache();
        if (publicResourceCache == null) {
            return false;
        }
        Set<String> set = publicResourceCache.get(type);
        return set != null && set.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private void parsePublicResCache() {
        String resDirPath = this.myTarget.getPath(11);
        String publicXmlPath = resDirPath + '/' + "values" + "/public.xml";
        VirtualFile publicXml = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)publicXmlPath));
        if (publicXml != null) {
            try {
                MyPublicResourceCacheBuilder builder = new MyPublicResourceCacheBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder);
                Object object = this.myPublicResourceCacheLock;
                synchronized (object) {
                    this.myPublicResourceCache = builder.getPublicResourceCache();
                    this.myPublicResourceIdMap = builder.getIdMap();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    public synchronized LayoutLibrary getLayoutLibrary(@NotNull Project project) throws RenderingException, IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidTargetData", "getLayoutLibrary"));
        }
        if (this.myLayoutLibrary == null) {
            IAndroidTarget target;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = this.mySdkData.getTargetData(target = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(project);
                return this.myLayoutLibrary;
            }
            AttributeDefinitionsImpl attrDefs = this.getAllAttrDefs(project);
            if (attrDefs == null) {
                return null;
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load(this.myTarget, attrDefs.getEnumMap());
        }
        return this.myLayoutLibrary;
    }

    public void clearLayoutBitmapCache(Module module) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearCaches((Object)module);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidTargetData", "getTarget"));
        }
        return iAndroidTarget;
    }

    @Nullable
    private static XmlFile[] findXmlFiles(Project project, String ... paths) {
        XmlFile[] xmlFiles = new XmlFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            PsiFile psiFile;
            String path = paths[i];
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            PsiFile psiFile2 = psiFile = file != null ? AndroidPsiUtils.getPsiFileSafely(project, file) : null;
            if (psiFile == null) {
                LOG.info("File " + path + " is not found");
                return null;
            }
            if (!(psiFile instanceof XmlFile)) {
                LOG.info("File " + path + "  is not an xml psiFile");
                return null;
            }
            xmlFiles[i] = (XmlFile)psiFile;
        }
        return xmlFiles;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        MyStaticConstantsData myStaticConstantsData = this.myStaticConstantsData;
        if (myStaticConstantsData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidTargetData", "getStaticConstantsData"));
        }
        return myStaticConstantsData;
    }

    @Nullable
    public synchronized FrameworkResources getFrameworkResources() throws IOException {
        if (this.myFrameworkResources == null) {
            this.myFrameworkResources = FrameworkResourceLoader.load(this.myTarget);
        }
        return this.myFrameworkResources;
    }

    public synchronized void resetFrameworkResources() {
        this.myFrameworkResources = null;
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target, @NotNull Module module) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidTargetData", "getTargetData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidTargetData", "getTargetData"));
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        return platform != null ? platform.getSdkData().getTargetData(target) : null;
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Set<String> collectValues(int pathId) {
            HashSet result = new HashSet();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(AndroidTargetData.this.myTarget.getPath(pathId)));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                        result.add(line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                return null;
            }
            return result;
        }
    }

    static class MyPublicResourceCacheBuilder
    extends NanoXmlUtil.IXMLBuilderAdapter {
        private final Map<String, Set<String>> myResult = new HashMap();
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;

        MyPublicResourceCacheBuilder() {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
            if ("public".equals(name) && this.myName != null && this.myType != null) {
                HashSet set = this.myResult.get(this.myType);
                if (set == null) {
                    set = new HashSet();
                    this.myResult.put(this.myType, (Set<String>)set);
                }
                set.add(this.myName);
                if (this.myId != 0) {
                    this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
            if ("name".equals(key)) {
                this.myName = value;
            } else if ("type".endsWith(key)) {
                this.myType = value;
            } else if ("id".equals(key)) {
                try {
                    this.myId = Integer.decode(value);
                }
                catch (NumberFormatException e) {
                    this.myId = 0;
                }
            }
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myName = null;
            this.myType = null;
            this.myId = 0;
        }

        public Map<String, Set<String>> getPublicResourceCache() {
            return this.myResult;
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            if (wrappee == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "org/jetbrains/android/sdk/AndroidTargetData$PublicAttributeDefinitions", "<init>"));
            }
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/sdk/AndroidTargetData$PublicAttributeDefinitions", "isAttributeAcceptable"));
            }
            return AndroidTargetData.this.isResourcePublic(ResourceType.ATTR.getName(), name);
        }
    }
}

