/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinNotSurrounder
extends KotlinExpressionSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.not.template", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinNotSurrounder", "isApplicable"));
        }
        KotlinType type2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        return type2 != null && KotlinBuiltIns.isBoolean(type2);
    }

    @Override
    @Nullable
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull KtExpression expression2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinNotSurrounder", "surroundExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinNotSurrounder", "surroundExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinNotSurrounder", "surroundExpression"));
        }
        KtPrefixExpression prefixExpr = (KtPrefixExpression)KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2).createExpression("!(a)");
        KtParenthesizedExpression parenthesizedExpression = (KtParenthesizedExpression)prefixExpr.getBaseExpression();
        assert (parenthesizedExpression != null) : "JetParenthesizedExpression should exists for " + prefixExpr.getText() + " expression";
        KtExpression expressionWithoutParentheses = parenthesizedExpression.getExpression();
        assert (expressionWithoutParentheses != null) : "JetExpression should exists for " + parenthesizedExpression.getText() + " expression";
        expressionWithoutParentheses.replace((PsiElement)expression2);
        expression2 = (KtExpression)expression2.replace((PsiElement)prefixExpr);
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)expression2);
        int offset2 = expression2.getTextRange().getEndOffset();
        return new TextRange(offset2, offset2);
    }
}

