/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProvider;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J$\u0010\u001d\u001a\b\u0018\u00010\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u001d\u001a\b\u0018\u00010\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0007J(\u0010\u001d\u001a\b\u0018\u00010\u0016R\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0016\u0010!\u001a\u00020\u001f*\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0\b*\u00020\"H\u0002J\u0014\u0010%\u001a\u00020\u001f*\u00020\"2\u0006\u0010&\u001a\u00020\"H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "()V", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getInlineArgumentsIfAny", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inlineFunctionCalls", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getInlineFunctionCallsIfAny", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getInlineFunctionsIfAny", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "", "getStepOutCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "stepSize", "getStepOverCommand", "ignoreBreakpoints", "", "debuggerContext", "contains", "Lcom/intellij/psi/PsiElement;", "element", "getAdditionalElementsToSkip", "shouldNotUseStepOver", "elementAt", "idea"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = suspendContext.getDebugProcess().getDebuggerContext().getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition3);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull DebuggerContextImpl debuggerContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debuggerContext, (String)"debuggerContext");
        SourcePosition sourcePosition2 = debuggerContext.getSourcePosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition2, (String)"debuggerContext.sourcePosition");
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull SourcePosition sourcePosition2) {
        boolean bl;
        KtExpression it;
        Iterable $receiver$iv;
        List<KtFunction> inlineArguments;
        List<KtCallExpression> inlineFunctionCalls;
        IntRange linesRange;
        KtFile file;
        block13: {
            Object v2;
            block12: {
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
                Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
                PsiFile psiFile = sourcePosition2.getFile();
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return null;
                }
                file = ktFile;
                if (sourcePosition2.getLine() < 0) {
                    return null;
                }
                Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents(sourcePosition2.getElementAt());
                for (Object element$iv : $receiver$iv2) {
                    PsiElement it2 = (PsiElement)element$iv;
                    if (!(it2 instanceof KtNamedFunction && !((KtNamedFunction)it2).isLocal())) continue;
                    v2 = element$iv;
                    break block12;
                }
                v2 = null;
            }
            PsiElement psiElement2 = v2;
            if (psiElement2 == null) {
                return null;
            }
            PsiElement containingFunction = psiElement2;
            int startLineNumber = JetRefactoringUtilKt.getLineNumber(containingFunction, true);
            int endLineNumber = JetRefactoringUtilKt.getLineNumber(containingFunction, false);
            if (startLineNumber > endLineNumber) {
                return null;
            }
            linesRange = new IntRange(startLineNumber + 1, endLineNumber + 1);
            inlineFunctionCalls = this.getInlineFunctionCallsIfAny(sourcePosition2);
            if (inlineFunctionCalls.isEmpty()) {
                return null;
            }
            inlineArguments = this.getInlineArgumentsIfAny(inlineFunctionCalls);
            Iterable $i$f$firstOrNull = inlineArguments;
            for (Object element$iv : $receiver$iv) {
                it = (KtFunction)element$iv;
                PsiElement psiElement3 = it;
                PsiElement psiElement4 = sourcePosition2.getElementAt();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"sourcePosition.elementAt");
                if (!this.shouldNotUseStepOver(psiElement3, psiElement4)) continue;
                bl = true;
                break block13;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        if (inlineArguments.isEmpty()) {
            boolean bl2;
            block14: {
                $receiver$iv = inlineFunctionCalls;
                for (Object element$iv : $receiver$iv) {
                    it = (KtCallExpression)element$iv;
                    PsiElement psiElement5 = it;
                    PsiElement psiElement6 = sourcePosition2.getElementAt();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"sourcePosition.elementAt");
                    if (!this.shouldNotUseStepOver(psiElement5, psiElement6)) continue;
                    bl2 = true;
                    break block14;
                }
                bl2 = false;
            }
            if (bl2) {
                return null;
            }
        }
        List<PsiElement> additionalElementsToSkip = this.getAdditionalElementsToSkip(sourcePosition2.getElementAt());
        return DebuggerSteppingHelper.createStepOverCommand(suspendContext, ignoreBreakpoints, file, linesRange, inlineArguments, additionalElementsToSkip);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> getAdditionalElementsToSkip(PsiElement $receiver) {
        List list2;
        ArrayList arrayList;
        void strict$iv4;
        void strict$iv22;
        void $receiver$iv;
        void strict$iv3;
        Object $receiver$iv2;
        ArrayList result2 = CollectionsKt.arrayListOf((Object[])new PsiElement[0]);
        PsiElement psiElement2 = $receiver;
        boolean bl = false;
        KtIfExpression ifParent = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtIfExpression.class, (boolean)strict$iv3);
        if (ifParent != null && this.contains((PsiElement)ifParent.getThen(), $receiver)) {
            Boolean bl2;
            Boolean bl3;
            PsiElement psiElement3 = ifParent.getElseKeyword();
            if (psiElement3 != null) {
                $receiver$iv2 = psiElement3;
                PsiElement it = $receiver$iv2;
                bl3 = result2.add(it);
            } else {
                bl3 = null;
            }
            KtExpression ktExpression = ifParent.getElse();
            if (ktExpression != null) {
                $receiver$iv2 = ktExpression;
                KtExpression it = (KtExpression)$receiver$iv2;
                bl2 = result2.add(it);
            } else {
                bl2 = null;
            }
        }
        PsiElement it = $receiver;
        boolean $i$a$2 = false;
        KtTryExpression tryParent = (KtTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtTryExpression.class, (boolean)strict$iv22);
        if (tryParent != null) {
            Iterable $receiver$iv3;
            PsiElement strict$iv22 = $receiver;
            boolean $i$f$getParentOfType = false;
            KtCatchClause catchClause = (KtCatchClause)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtCatchClause.class, (boolean)strict$iv4);
            if (catchClause != null) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                $receiver$iv3 = tryParent.getCatchClauses();
                arrayList = result2;
                Iterable strict$iv4 = $receiver$iv3;
                Collection $i$f$getParentOfType2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KtCatchClause it2 = (KtCatchClause)element$iv$iv;
                    if (!(Intrinsics.areEqual((Object)it2, (Object)catchClause) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                arrayList.addAll(list2);
            }
        }
        PsiElement $receiver$iv4 = $receiver;
        boolean $receiver$iv$iv = false;
        KtWhenEntry whenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv4, KtWhenEntry.class, (boolean)strict$iv4);
        if (whenEntry != null && this.contains((PsiElement)whenEntry.getExpression(), $receiver)) {
            void strict$iv52;
            Iterable $receiver$iv5;
            PsiElement strict$iv6 = (PsiElement)whenEntry;
            boolean $i$f$getParentOfType = false;
            KtWhenExpression whenParent = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv5, KtWhenExpression.class, (boolean)strict$iv52);
            if (whenParent != null) {
                void destination$iv$iv;
                void $receiver$iv$iv2;
                $receiver$iv5 = whenParent.getEntries();
                arrayList = result2;
                Iterable strict$iv52 = $receiver$iv5;
                Collection $i$f$getParentOfType3 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    KtWhenEntry it3 = (KtWhenEntry)element$iv$iv;
                    if (!(Intrinsics.areEqual((Object)it3, (Object)whenEntry) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                arrayList.addAll(list2);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldNotUseStepOver(PsiElement $receiver, PsiElement elementAt) {
        Object object;
        int strict$iv5;
        Object[] $receiver$iv;
        boolean strict$iv2;
        void strict$iv32;
        void $receiver$iv2;
        PsiElement psiElement2 = $receiver;
        boolean bl = false;
        KtIfExpression ifParent = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtIfExpression.class, (boolean)strict$iv32);
        if (ifParent != null) {
            void $receiver$iv3;
            if (this.contains((PsiElement)ifParent.getCondition(), $receiver)) {
                return true;
            }
            PsiElement strict$iv32 = elementAt;
            boolean $i$f$getParentOfType = false;
            KtIfExpression ifParentElementAt = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtIfExpression.class, (boolean)strict$iv2);
            if (ifParentElementAt == null) {
                if (this.contains((PsiElement)ifParent.getThen(), $receiver)) {
                    return true;
                }
                if (this.contains((PsiElement)ifParent.getElse(), $receiver)) {
                    return true;
                }
            }
        }
        PsiElement $receiver$iv3 = $receiver;
        strict$iv2 = false;
        KtTryExpression tryParent = (KtTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtTryExpression.class, (boolean)strict$iv2);
        if (tryParent != null && this.contains((PsiElement)tryParent.getTryBlock(), $receiver)) {
            return true;
        }
        PsiElement strict$iv22 = $receiver;
        boolean $i$f$getParentOfType = false;
        KtWhenEntry whenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenEntry.class, strict$iv5 != 0);
        if (whenEntry != null) {
            $receiver$iv = whenEntry.getConditions();
            for (strict$iv5 = 0; strict$iv5 < $receiver$iv.length; ++strict$iv5) {
                Object element$iv = $receiver$iv[strict$iv5];
                KtWhenCondition it = (KtWhenCondition)element$iv;
                if (!this.contains((PsiElement)it, $receiver)) continue;
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            if (this.contains((PsiElement)whenEntry.getExpression(), $receiver)) {
                int strict$iv4;
                Object[] $receiver$iv4;
                PsiElement strict$iv5 = elementAt;
                boolean element$iv = false;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv4, KtWhenEntry.class, strict$iv4 != 0);
                if (ktWhenEntry == null) return true;
                KtWhenEntry parentEntryElementAt = ktWhenEntry;
                if (!Intrinsics.areEqual((Object)parentEntryElementAt, (Object)whenEntry)) return false;
                $receiver$iv4 = whenEntry.getConditions();
                strict$iv4 = 0;
                while (strict$iv4 < $receiver$iv4.length) {
                    Object element$iv2 = $receiver$iv4[strict$iv4];
                    KtWhenCondition it = (KtWhenCondition)element$iv2;
                    if (this.contains((PsiElement)it, elementAt)) {
                        return true;
                    }
                    ++strict$iv4;
                }
                return false;
            }
        }
        PsiElement $receiver$iv5 = $receiver;
        boolean strict$iv4 = false;
        KtWhileExpression whileParent = (KtWhileExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv5, KtWhileExpression.class, (boolean)strict$iv4);
        if (whileParent == null) return false;
        KtExpression ktExpression = whileParent.getBody();
        if (ktExpression instanceof KtBlockExpression) return Intrinsics.areEqual(object != null && (object = ((KtBlockExpression)object).getStatements()) != null && (object = (KtExpression)CollectionsKt.lastOrNull((List)object)) != null ? Integer.valueOf(JetRefactoringUtilKt.getLineNumber$default((PsiElement)object, false, 1, null)) : null, (Object)JetRefactoringUtilKt.getLineNumber$default(elementAt, false, 1, null));
        ktExpression = null;
        object = (KtBlockExpression)ktExpression;
        return Intrinsics.areEqual(object != null && (object = ((KtBlockExpression)object).getStatements()) != null && (object = (KtExpression)CollectionsKt.lastOrNull((List)object)) != null ? Integer.valueOf(JetRefactoringUtilKt.getLineNumber$default((PsiElement)object, false, 1, null)) : null, (Object)JetRefactoringUtilKt.getLineNumber$default(elementAt, false, 1, null));
    }

    private final boolean contains(PsiElement $receiver, PsiElement element2) {
        PsiElement psiElement2 = $receiver;
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.contains(element2.getTextRange()) : false;
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition2 = debugContext.getSourcePosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition2, (String)"debugContext.sourcePosition");
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = suspendContext.getDebugProcess().getDebuggerContext().getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        return this.getStepOutCommand(suspendContext, sourcePosition3);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition2) {
        PsiFile psiFile = sourcePosition2.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return null;
        }
        KtFile file = ktFile;
        if (sourcePosition2.getLine() < 0) {
            return null;
        }
        Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, sourcePosition2.getLine());
        if (n == null) {
            return null;
        }
        int lineStartOffset = ((Number)n).intValue();
        List<KtNamedFunction> inlineFunctions = this.getInlineFunctionsIfAny(file, lineStartOffset);
        KtFunctionLiteral inlinedArgument = KotlinSteppingCommandProviderKt.access$getInlineArgumentIfAny(sourcePosition2.getElementAt());
        if (inlineFunctions.isEmpty() && inlinedArgument == null) {
            return null;
        }
        return DebuggerSteppingHelper.createStepOutCommand(suspendContext, true, inlineFunctions, inlinedArgument);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedFunction> getInlineFunctionsIfAny(KtFile file, int offset2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void strict$iv;
        void $receiver$iv2;
        PsiElement elementAt;
        PsiElement psiElement2 = file.findElementAt(offset2);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        boolean bl = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtNamedFunction.class, (boolean)strict$iv);
        if (ktNamedFunction == null) {
            return CollectionsKt.emptyList();
        }
        KtNamedFunction containingFunction = ktNamedFunction;
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(containingFunction);
        if (!InlineUtil.isInline(descriptor2)) {
            return CollectionsKt.emptyList();
        }
        Iterable $i$f$getParentOfType = DebuggerUtils.INSTANCE.analyzeElementWithInline(ResolutionUtils.getResolutionFacade(containingFunction), ResolutionUtils.analyzeFully(containingFunction), containingFunction, false);
        void var8_9 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inlineFunctionsCalls = (List)destination$iv$iv;
        return inlineFunctionsCalls;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFunction> getInlineArgumentsIfAny(List<? extends KtCallExpression> inlineFunctionCalls) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = inlineFunctionCalls;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Collection destination$iv$iv2;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv2;
            KtCallExpression it = (KtCallExpression)element$iv$iv;
            Iterable iterable2 = it.getValueArguments();
            void var9_9 = $receiver$iv2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it2;
                KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                void var14_14 = destination$iv$iv2;
                ValueArgument valueArgument = (ValueArgument)it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"it");
                KtExpression ktExpression = this.getArgumentExpression(valueArgument);
                var14_14.add(ktExpression);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                if (!(element$iv$iv2 instanceof KtFunction)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpressionImpl ktExpressionImpl;
        KtExpression ktExpression = it.getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (ktExpressionImpl = (KtLambdaExpression)ktExpression) != null && (ktExpressionImpl = ktExpressionImpl.getFunctionLiteral()) != null ? (KtExpression)ktExpressionImpl : it.getArgumentExpression();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtCallExpression> getInlineFunctionCallsIfAny(SourcePosition sourcePosition2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtCallExpression it;
        Collection destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        PsiFile psiFile = sourcePosition2.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile;
        int lineNumber = sourcePosition2.getLine();
        PsiElement elementAt = sourcePosition2.getElementAt();
        Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber);
        Integer n2 = JetRefactoringUtilKt.getLineEndOffset((PsiFile)file, lineNumber);
        int endOffset = n2 != null ? ((Number)n2).intValue() : PsiUtilsKt.getEndOffset(elementAt);
        PsiElement topMostElement = null;
        for (int startOffset = (v783393) != null ? ((Number)(v783393)).intValue() : PsiUtilsKt.getStartOffset(elementAt); !(topMostElement instanceof KtElement) && startOffset < endOffset; ++startOffset) {
            elementAt = file.findElementAt(startOffset);
            if (elementAt == null) continue;
            topMostElement = CodeInsightUtils.getTopmostElementAtOffset(elementAt, startOffset);
        }
        if (!(topMostElement instanceof KtElement)) {
            return CollectionsKt.emptyList();
        }
        int start = PsiUtilsKt.getStartOffset(topMostElement);
        int end = PsiUtilsKt.getEndOffset(topMostElement);
        getInlineFunctionCallsIfAny.1 isInlineCall$ = getInlineFunctionCallsIfAny.1.INSTANCE;
        Iterable iterable = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file, start, end, KtExpression.class);
        void var13_12 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            PsiElement psiElement2 = (PsiElement)item$iv$iv;
            void var23_17 = destination$iv$iv2;
            void v4 = it;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)v4);
            var23_17.add(ktExpression);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            if (!(element$iv$iv instanceof KtCallExpression)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (KtCallExpression)element$iv$iv;
            if (!getInlineFunctionCallsIfAny.1.INSTANCE.invoke(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set allInlineFunctionCalls = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        $receiver$iv2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)$receiver$iv2).element = new IntRange(lineNumber, lineNumber);
        $receiver$iv$iv2 = allInlineFunctionCalls;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void linesRange;
            KtCallExpression it2 = (KtCallExpression)element$iv$iv;
            boolean shouldInclude = ((IntRange)linesRange.element).contains(JetRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1, null));
            if (shouldInclude) {
                linesRange.element = new IntRange(Math.min(((Number)((IntRange)linesRange.element).getStart()).intValue(), JetRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1, null)), Math.max(((Number)((IntRange)linesRange.element).getEndInclusive()).intValue(), JetRefactoringUtilKt.getLineNumber((PsiElement)it2, false)));
            }
            if (!shouldInclude) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

