/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a8\u0006\n"}, d2={"collectContainingClasses", "", "Lcom/intellij/psi/PsiClass;", "methods", "", "Lcom/intellij/psi/PsiMethod;", "getPsiClass", "element", "Lcom/intellij/psi/PsiElement;", "getPsiMethod", "idea"})
public final class JavaPsiUtilsKt {
    @NotNull
    public static final Set<PsiClass> collectContainingClasses(@NotNull Collection<? extends PsiMethod> methods2) {
        Intrinsics.checkParameterIsNotNull(methods2, (String)"methods");
        HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
        for (PsiMethod psiMethod : methods2) {
            ProgressManager.checkCanceled();
            PsiClass parentClass2 = psiMethod.getContainingClass();
            if (parentClass2 == null || !(Intrinsics.areEqual((Object)"java.lang.Object", (Object)parentClass2.getQualifiedName()) ^ true)) continue;
            classes2.add(parentClass2);
        }
        return classes2;
    }

    @Nullable
    public static final PsiClass getPsiClass(@Nullable PsiElement element2) {
        PsiClass psiClass;
        if (element2 == null) {
            psiClass = null;
        } else if (element2 instanceof PsiClass) {
            psiClass = (PsiClass)element2;
        } else if (element2 instanceof KtClass) {
            psiClass = LightClassUtilsKt.toLightClass((KtClassOrObject)element2);
        } else if (element2.getParent() instanceof KtClass) {
            PsiElement psiElement2 = element2.getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            psiClass = LightClassUtilsKt.toLightClass((KtClass)psiElement2);
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    @Nullable
    public static final PsiMethod getPsiMethod(@Nullable PsiElement element2) {
        PsiMethod psiMethod;
        PsiElement parent2;
        PsiElement psiElement2 = element2;
        Object object = parent2 = psiElement2 != null ? psiElement2.getParent() : null;
        if (element2 == null) {
            psiMethod = null;
        } else if (element2 instanceof PsiMethod) {
            psiMethod = (PsiMethod)element2;
        } else if (parent2 instanceof KtNamedFunction || parent2 instanceof KtSecondaryConstructor) {
            PsiElement psiElement3 = parent2;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)psiElement3);
        } else {
            psiMethod = null;
        }
        return psiMethod;
    }
}

