/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToForEachFunctionCallIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertToForEachFunctionCallIntention
extends SelfTargetingIntention<KtForExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtForExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement2 = element2.getRightParenthesis();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement rParen = psiElement2;
        if (caretOffset > PsiUtilsKt.getEndOffset(rParen)) {
            return false;
        }
        return element2.getLoopRange() != null && element2.getLoopParameter() != null && element2.getBody() != null;
    }

    @Override
    public void applyTo(@NotNull KtForExpression element2, @Nullable Editor editor) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        CommentSaver commentSaver = new CommentSaver((PsiElement)element2, false, 2, null);
        KtExpression ktExpression = element2.getBody();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression body2 = ktExpression;
        KtParameter ktParameter = element2.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter loopParameter = ktParameter;
        if (body2 instanceof KtBlockExpression) {
            object = KtPsiUtilKt.contentRange((KtBlockExpression)body2);
        } else {
            KtExpression ktExpression2 = body2;
            object = ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"body");
        }
        Object functionBodyArgument = object;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        Object[] objectArray = new Object[3];
        KtExpression ktExpression3 = element2.getLoopRange();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"element.loopRange!!");
        objectArray[0] = ktExpression3;
        KtParameter ktParameter2 = loopParameter;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"loopParameter");
        objectArray[1] = ktParameter2;
        objectArray[2] = functionBodyArgument;
        KtExpression foreachExpression = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0.forEach{$1->$2}", objectArray);
        PsiElement result2 = element2.replace((PsiElement)foreachExpression);
        CommentSaver.restore$default(commentSaver, result2, false, 2, null);
    }

    public ConvertToForEachFunctionCallIntention() {
        super(KtForExpression.class, "Replace with a 'forEach' function call", null, 4, null);
    }
}

