/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.CompilationResult;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorage;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageProvider;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u00b4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001aJ\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002\u001a(\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000b2\u0006\u0010/\u001a\u00020.2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030100H\u0002\u001a\u001b\u00102\u001a\u00020\"*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0082\b\u001a>\u00107\u001a\u00020\"*\u00020*2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010+\u001a\u00020,H\u0002\u001a<\u00108\u001a\u00020\"*\u00020*2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020,2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003010(H\u0002\u001aG\u00109\u001a\u00020\"\"\u0004\b\u0000\u0010:\"\u0004\b\u0001\u0010;*\b\u0012\u0004\u0012\u0002H:0<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H;0<2\u0018\u0010>\u001a\u0014\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u0002H;\u0012\u0004\u0012\u00020\"0?H\u0082\b\"J\u0010\u0000\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0002 \u0004*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"J\u0010\u0005\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0004*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00020\u0002 \u0004*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0004*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"ALL_COMPILED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "PROCESSED_TARGETS_WITH_REMOVED_FILES", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getAllCompiledFilesContainer", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getDependenciesRecursively", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "module", "kind", "Lorg/jetbrains/jps/model/java/JpsJavaClasspathKind;", "getDependentTargets", "compilingChunk", "Lorg/jetbrains/jps/ModuleChunk;", "getIncrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;", "chunk", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "getProcessedTargetsWithRemovedFilesContainer", "hasKotlinDirtyOrRemovedFiles", "", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "processChanges", "", "compiledFiles", "allCompiledFiles", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "caches", "", "compilationResult", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "withSubtypes", "Lorg/jetbrains/kotlin/name/FqName;", "typeFqName", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "debug", "Lcom/intellij/openapi/diagnostic/Logger;", "message", "Lkotlin/Function0;", "", "doProcessChanges", "doProcessChangesUsingLookups", "forAllPairs", "T", "R", "", "other", "fn", "Lkotlin/Function2;", "jps-plugin"})
public final class KotlinBuilderKt {
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_kotlin_compiled_files_");
    private static final Key<Set<ModuleBuildTarget>> PROCESSED_TARGETS_WITH_REMOVED_FILES = Key.create((String)"_processed_targets_with_removed_files_");

    private static final void processChanges(Set<? extends File> compiledFiles, Set<File> allCompiledFiles, BuildDataManager dataManager, Collection<JpsIncrementalCacheImpl> caches, CompilationResult compilationResult, FSOperationsHelper fsOperations) {
        if (IncrementalCompilation.isExperimental()) {
            KotlinBuilderKt.doProcessChangesUsingLookups(compilationResult, compiledFiles, dataManager, fsOperations, caches);
        } else {
            KotlinBuilderKt.doProcessChanges(compilationResult, compiledFiles, allCompiledFiles, caches, fsOperations);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void doProcessChanges(CompilationResult $receiver, Set<? extends File> compiledFiles, Set<File> allCompiledFiles, Collection<JpsIncrementalCacheImpl> caches, FSOperationsHelper fsOperations) {
        KotlinBuilder.Companion.getLOG().debug("compilationResult = " + $receiver);
        if ($receiver.getInlineAdded()) {
            allCompiledFiles.clear();
            fsOperations.markChunk(true, true, compiledFiles);
            return;
        }
        if ($receiver.getConstantsChanged()) {
            fsOperations.markChunk(true, false, allCompiledFiles);
            return;
        }
        if ($receiver.getProtoChanged()) {
            fsOperations.markChunk(false, true, allCompiledFiles);
        }
        if ($receiver.getInlineChanged()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = caches;
            void var7_6 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                JpsIncrementalCacheImpl it = (JpsIncrementalCacheImpl)element$iv$iv;
                Iterable list$iv$iv = it.getFilesToReinline();
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List files = (List)destination$iv$iv;
            fsOperations.markFiles(files, compiledFiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void doProcessChangesUsingLookups(CompilationResult $receiver, Set<? extends File> compiledFiles, BuildDataManager dataManager, FSOperationsHelper fsOperations, Collection<? extends IncrementalCacheImpl<?>> caches) {
        void $receiver$iv;
        Object cache2;
        Object object;
        FSOperationsHelper fSOperationsHelper;
        String name;
        Object name2;
        Iterator<Object> iterator2;
        Object fqNames;
        HashSet<LookupSymbol> dirtyLookupSymbols = new HashSet<LookupSymbol>();
        HashSet dirtyClassesFqNames = new HashSet();
        JpsLookupStorage lookupStorage = (JpsLookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)JpsLookupStorageProvider.INSTANCE);
        Sequence allCaches2 = SequencesKt.flatMap((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)caches), (Function1)doProcessChangesUsingLookups.allCaches.1.INSTANCE);
        KotlinBuilder.Companion.getLOG().debug("Start processing changes");
        for (ChangeInfo change : $receiver.getChanges()) {
            void $receiver$iv2;
            Iterable classFqName;
            KotlinBuilder.Companion.getLOG().debug("Process " + change);
            if (change instanceof ChangeInfo.SignatureChanged) {
                fqNames = !((ChangeInfo.SignatureChanged)change).getAreSubclassesAffected() ? (Collection)kotlin.collections.CollectionsKt.listOf((Object)change.getFqName()) : (Collection)KotlinBuilderKt.withSubtypes(change.getFqName(), allCaches2);
                iterator2 = fqNames.iterator();
                while (iterator2.hasNext()) {
                    Unit unit;
                    classFqName = (FqName)iterator2.next();
                    boolean bl = !classFqName.isRoot();
                    if (_Assertions.ENABLED) {
                        void value$iv;
                        if (value$iv == false) {
                            String message$iv = "classFqName is root when processing " + change;
                            throw (Throwable)((Object)new AssertionError((Object)message$iv));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    String scope = classFqName.parent().asString();
                    Object object2 = name2 = classFqName.shortName().getIdentifier();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"name");
                    String string = scope;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope");
                    dirtyLookupSymbols.add(new LookupSymbol((String)object2, string));
                }
                continue;
            }
            if (!(change instanceof ChangeInfo.MembersChanged)) continue;
            fqNames = KotlinBuilderKt.withSubtypes(change.getFqName(), allCaches2);
            dirtyClassesFqNames.addAll((Collection)fqNames);
            classFqName = ((ChangeInfo.MembersChanged)change).getNames();
            for (Object t$iv : $receiver$iv2) {
                name2 = ((Iterable)fqNames).iterator();
                while (name2.hasNext()) {
                    void fqName;
                    Object r$iv = name2.next();
                    FqName $i$f$assert = (FqName)r$iv;
                    name = (String)t$iv;
                    String string = fqName.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.asString()");
                    dirtyLookupSymbols.add(new LookupSymbol(name, string));
                }
            }
        }
        HashSet<File> dirtyFiles = new HashSet<File>();
        fqNames = dirtyLookupSymbols.iterator();
        while (fqNames.hasNext()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Logger $receiver$iv3;
            LookupSymbol lookup;
            Object t$iv;
            LookupSymbol lookupSymbol = lookup = (LookupSymbol)fqNames.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupSymbol, (String)"lookup");
            iterator2 = lookupStorage.get(lookupSymbol);
            t$iv = $receiver$iv3;
            name2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                name = (String)item$iv$iv;
                fSOperationsHelper = destination$iv$iv;
                object = new File((String)p1);
                fSOperationsHelper.add(object);
            }
            List affectedFiles = (List)destination$iv$iv;
            $receiver$iv3 = KotlinBuilder.Companion.getLOG();
            if ($receiver$iv3.isDebugEnabled()) {
                fSOperationsHelper = $receiver$iv3;
                object = lookup.getScope() + "#" + lookup.getName() + " caused recompilation of: " + affectedFiles;
                fSOperationsHelper.debug((String)object);
            }
            dirtyFiles.addAll(affectedFiles);
        }
        for (Object cache2 : allCaches2) {
            iterator2 = dirtyClassesFqNames.iterator();
            while (iterator2.hasNext()) {
                File srcFile;
                FqName dirtyClassFqName;
                FqName fqName = dirtyClassFqName = (FqName)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"dirtyClassFqName");
                if (((IncrementalCacheImpl)cache2).getSourceFileIfClass(fqName) == null) {
                    continue;
                }
                dirtyFiles.add(srcFile);
            }
        }
        cache2 = dirtyFiles;
        fSOperationsHelper = fsOperations;
        object = $receiver$iv;
        fSOperationsHelper.markFiles((Iterable<? extends File>)object, compiledFiles);
        KotlinBuilder.Companion.getLOG().debug("End of processing changes");
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<FqName> withSubtypes(FqName typeFqName, Sequence<? extends IncrementalCacheImpl<?>> caches) {
        LinkedList<FqName> types = new LinkedList<FqName>(kotlin.collections.CollectionsKt.listOf((Object)typeFqName));
        HashSet subtypes = SetsKt.hashSetOf((Object[])new FqName[0]);
        while (true) {
            void $receiver$iv;
            void $receiver$iv2;
            Collection collection = types;
            if (!(!$receiver$iv2.isEmpty())) break;
            FqName unprocessedType = (FqName)types.pollFirst();
            Sequence $i$f$isNotEmpty = SequencesKt.filter((Sequence)SequencesKt.flatMap(caches, (Function1)new Function1<IncrementalCacheImpl<?>, Sequence<? extends FqName>>(unprocessedType){
                final /* synthetic */ FqName $unprocessedType;

                @NotNull
                public final Sequence<FqName> invoke(@NotNull IncrementalCacheImpl<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    FqName fqName = this.$unprocessedType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"unprocessedType");
                    return it.getSubtypesOf(fqName);
                }
                {
                    this.$unprocessedType = fqName;
                    super(1);
                }
            }), (Function1)((Function1)new Function1<FqName, Boolean>(subtypes){
                final /* synthetic */ HashSet $subtypes;

                public final boolean invoke(@NotNull FqName it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$subtypes.contains(it) ^ true;
                }
                {
                    this.$subtypes = hashSet;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                types.addLast(it);
            }
            subtypes.add(unprocessedType);
        }
        return subtypes;
    }

    private static final LookupTracker getLookupTracker(JpsProject project) {
        LookupTracker lookupTracker = LookupTracker.Companion.getDO_NOTHING();
        if (StringsKt.equals((String)"true", (String)System.getProperty("kotlin.jps.tests"), (boolean)true)) {
            LookupTracker testTracker;
            JpsSimpleElement jpsSimpleElement = (JpsSimpleElement)project.getContainer().getChild((JpsElementChildRole)KotlinBuilder.Companion.getLOOKUP_TRACKER());
            Object object = testTracker = jpsSimpleElement != null ? (LookupTracker)jpsSimpleElement.getData() : null;
            if (testTracker != null) {
                lookupTracker = testTracker;
            }
        }
        if (IncrementalCompilation.isExperimental()) {
            return new LookupTrackerImpl(lookupTracker);
        }
        return lookupTracker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ModuleBuildTarget, JpsIncrementalCacheImpl> getIncrementalCaches(ModuleChunk chunk, CompileContext context) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Set<ModuleBuildTarget> dependentTargets = KotlinBuilderKt.getDependentTargets(chunk, context);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Map<ModuleBuildTarget, JpsIncrementalCacheImpl> chunkCaches2 = CollectionsKt.keysToMap(chunk.getTargets(), (Function1)new Function1<ModuleBuildTarget, JpsIncrementalCacheImpl>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @NotNull
            public final JpsIncrementalCacheImpl invoke(ModuleBuildTarget it) {
                ModuleBuildTarget moduleBuildTarget = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                return JpsIncrementalCacheImplKt.getKotlinCache(this.$dataManager, moduleBuildTarget);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        Iterable iterable = dependentTargets;
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item$iv$iv;
            void var15_11 = destination$iv$iv;
            JpsIncrementalCacheImpl jpsIncrementalCacheImpl = JpsIncrementalCacheImplKt.getKotlinCache(dataManager, (ModuleBuildTarget)it);
            var15_11.add(jpsIncrementalCacheImpl);
        }
        List dependentCaches = (List)destination$iv$iv;
        for (JpsIncrementalCacheImpl chunkCache : chunkCaches2.values()) {
            for (JpsIncrementalCacheImpl dependentCache : dependentCaches) {
                chunkCache.addDependentCache(dependentCache);
            }
        }
        return chunkCaches2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<ModuleBuildTarget> getDependentTargets(ModuleChunk compilingChunk, CompileContext context) {
        Iterable $receiver$iv;
        boolean bl;
        block5: {
            Iterable $receiver$iv2 = compilingChunk.getTargets();
            for (Object element$iv : $receiver$iv2) {
                ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                if (!it.isTests()) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)bl);
        Function1 dependsOnCompilingChunk$ = new Function1<BuildTarget<?>, Boolean>(classpathKind, compilingChunk){
            final /* synthetic */ JpsJavaClasspathKind $classpathKind;
            final /* synthetic */ ModuleChunk $compilingChunk;

            public final boolean invoke(@NotNull BuildTarget<?> target) {
                Intrinsics.checkParameterIsNotNull(target, (String)"target");
                if (!(target instanceof ModuleBuildTarget)) {
                    return false;
                }
                JpsModule jpsModule = ((ModuleBuildTarget)target).getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                JpsJavaClasspathKind jpsJavaClasspathKind = this.$classpathKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaClasspathKind, (String)"classpathKind");
                Set dependencies = KotlinBuilderKt.access$getDependenciesRecursively(jpsModule, jpsJavaClasspathKind);
                return ContainerUtil.intersects((Collection)dependencies, (Collection)this.$compilingChunk.getModules());
            }
            {
                this.$classpathKind = jpsJavaClasspathKind;
                this.$compilingChunk = moduleChunk;
                super(1);
            }
        };
        HashSet dependentTargets = new HashSet();
        Iterator sortedChunks = context.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(context).iterator();
        while (sortedChunks.hasNext() && !Intrinsics.areEqual((Object)((BuildTargetChunk)sortedChunks.next()).getTargets(), (Object)compilingChunk.getTargets())) {
        }
        Iterator $i$f$any = sortedChunks;
        void var7_8 = $receiver$iv;
        while (var7_8.hasNext()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            boolean bl2;
            Object element$iv2;
            BuildTargetChunk followingChunk;
            block6: {
                followingChunk = (BuildTargetChunk)var7_8.next();
                $receiver$iv = followingChunk.getTargets();
                for (Object element$iv2 : $receiver$iv) {
                    BuildTarget p1 = (BuildTarget)element$iv2;
                    if (!dependsOnCompilingChunk$.invoke(p1)) continue;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
            if (bl2) continue;
            $receiver$iv = followingChunk.getTargets();
            HashSet hashSet = dependentTargets;
            Iterable $i$f$iterator = $receiver$iv;
            element$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ModuleBuildTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            hashSet.addAll(list);
        }
        return dependentTargets;
    }

    private static final Set<JpsModule> getDependenciesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        Set set = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly().getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JpsJavaExtensionService.\u2026elyExportedOnly().modules");
        return set;
    }

    private static final Set<File> getAllCompiledFilesContainer(CompileContext context) {
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = (Set)new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        return allCompiledFiles;
    }

    private static final Set<ModuleBuildTarget> getProcessedTargetsWithRemovedFilesContainer(CompileContext context) {
        Set set = (Set)PROCESSED_TARGETS_WITH_REMOVED_FILES.get((UserDataHolder)context);
        if (set == null) {
            set = new HashSet();
            PROCESSED_TARGETS_WITH_REMOVED_FILES.set((UserDataHolder)context, (Object)set);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasKotlinDirtyOrRemovedFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk) {
        boolean bl;
        block3: {
            if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles()) {
                return false;
            }
            if (!KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder).isEmpty()) {
                return true;
            }
            Iterable $receiver$iv = chunk.getTargets();
            for (Object element$iv : $receiver$iv) {
                void $receiver$iv2;
                ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                Collection collection = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it);
                if (!(!$receiver$iv2.isEmpty())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static final <T, R> void forAllPairs(Iterable<? extends T> $receiver, Iterable<? extends R> other, Function2<? super T, ? super R, Unit> fn) {
        for (T t : $receiver) {
            for (R r : other) {
                fn.invoke(t, r);
            }
        }
    }

    private static final void debug(Logger $receiver, Function0<String> message) {
        if ($receiver.isDebugEnabled()) {
            $receiver.debug((String)message.invoke());
        }
    }

    public static final /* synthetic */ boolean access$hasKotlinDirtyOrRemovedFiles(@NotNull DirtyFilesHolder dirtyFilesHolder, @NotNull ModuleChunk chunk) {
        return KotlinBuilderKt.hasKotlinDirtyOrRemovedFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
    }

    @NotNull
    public static final /* synthetic */ LookupTracker access$getLookupTracker(@NotNull JpsProject project) {
        return KotlinBuilderKt.getLookupTracker(project);
    }

    @NotNull
    public static final /* synthetic */ Map access$getIncrementalCaches(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        return KotlinBuilderKt.getIncrementalCaches(chunk, context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getAllCompiledFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getAllCompiledFilesContainer(context);
    }

    public static final /* synthetic */ void access$processChanges(@NotNull Set compiledFiles, @NotNull Set allCompiledFiles, @NotNull BuildDataManager dataManager, @NotNull Collection caches, @NotNull CompilationResult compilationResult, @NotNull FSOperationsHelper fsOperations) {
        KotlinBuilderKt.processChanges(compiledFiles, allCompiledFiles, dataManager, caches, compilationResult, fsOperations);
    }

    @NotNull
    public static final /* synthetic */ Set access$getProcessedTargetsWithRemovedFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getProcessedTargetsWithRemovedFilesContainer(context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDependenciesRecursively(@NotNull JpsModule module, @NotNull JpsJavaClasspathKind kind) {
        return KotlinBuilderKt.getDependenciesRecursively(module, kind);
    }
}

