/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import java.io.File;
import java.util.Properties;

public class LocalAddonSysImgPkgInfo
extends LocalPkgInfo {
    private final IPkgDesc mDesc;

    public LocalAddonSysImgPkgInfo(LocalSdk localSdk, File localDir, Properties sourceProps, AndroidVersion version, IdDisplay addonVendor, IdDisplay addonName, String abi, MajorRevision revision) {
        super(localSdk, localDir, sourceProps);
        IdDisplay tag = new IdDisplay(sourceProps.getProperty("SystemImage.TagId"), sourceProps.getProperty("SystemImage.TagDisplay"));
        String listDisplay = sourceProps.getProperty("Pkg.ListDisplay");
        if (listDisplay == null) {
            listDisplay = "";
        }
        this.mDesc = PkgDesc.Builder.newAddonSysImg(version, addonVendor, addonName, abi, revision).setDescriptionShort(LocalSysImgPkgInfo.createShortDescription(listDisplay, abi, addonVendor, tag, version, revision, sourceProps.containsKey("Pkg.Obsolete"))).setListDisplay(LocalSysImgPkgInfo.createListDescription(listDisplay, tag, LocalSysImgPkgInfo.getAbiDisplayNameInternal(abi), sourceProps.containsKey("Pkg.Obsolete"))).create();
    }

    @Override
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    public ISystemImage getSystemImage() {
        return LocalSysImgPkgInfo.getSystemImage(this.mDesc, this.getLocalDir(), this.getLocalSdk().getFileOp());
    }
}

