/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00190\u00170\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0017J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0016\u0010\u001f\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0016H\u0007J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0017J\b\u0010$\u001a\u00020\u0014H\u0007J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010&\u001a\u00020\u0018H\u0007J\u0012\u0010'\u001a\u00020\u00142\b\b\u0002\u0010(\u001a\u00020#H\u0002J\u0016\u0010)\u001a\u00020\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030+H\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "(Ljava/io/File;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "size", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "addAll", "", "lookups", "", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "", "allPaths", "addFileIfNeeded", "file", "clean", "doRemoveGarbage", "dump", "lookupSymbols", "flush", "memoryCachesOnly", "", "forceGC", "get", "lookupSymbol", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "files", "Lkotlin/sequences/Sequence;", "Companion", "kotlin-build-common"})
public class LookupStorage
extends BasicMapsOwner {
    private final File countersFile;
    private final IdToFileMap idToFile;
    private final FileToIdMap fileToId;
    private final LookupMap lookupMap;
    private volatile int size;
    private volatile int deletedCount;
    private final File targetDataDir;
    private static final double DELETED_TO_SIZE_TRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    public static final Companion Companion = new Companion(null);

    private final File getStorageFile(String $receiver) {
        return new File(this.targetDataDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (lookupSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupSymbol", "org/jetbrains/kotlin/incremental/LookupStorage", "get"));
        }
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            Collection collection2 = SetsKt.emptySet();
            if (collection2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/LookupStorage", "get"));
            }
            return collection2;
        }
        Collection<Integer> fileIds = collection;
        Iterable iterable = fileIds;
        void var5_5 = $receiver$iv;
        Collection collection3 = new ArrayList();
        void var7_7 = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            int it = ((Number)element$iv$iv).intValue();
            File file = this.idToFile.get(it);
            if ((file != null ? file.getPath() : null) != null) {
                void $receiver$iv$iv$iv2;
                String string;
                string = string;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        Collection collection4 = (List)destination$iv$iv;
        if (collection4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/LookupStorage", "get"));
        }
        return collection4;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull Set<? extends Map.Entry<LookupSymbol, ? extends Collection<String>>> lookups, @NotNull Set<String> allPaths) {
        if (lookups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookups", "org/jetbrains/kotlin/incremental/LookupStorage", "addAll"));
        }
        if (allPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPaths", "org/jetbrains/kotlin/incremental/LookupStorage", "addAll"));
        }
        Intrinsics.checkParameterIsNotNull(lookups, (String)"lookups");
        Intrinsics.checkParameterIsNotNull(allPaths, (String)"allPaths");
        Map pathToId2 = CollectionsKt.keysToMap((Iterable)allPaths, (Function1)((Function1)new Function1<String, Integer>(this){
            final /* synthetic */ LookupStorage this$0;

            public final int invoke(@NotNull String it) {
                if (it == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "org/jetbrains/kotlin/incremental/LookupStorage$addAll$pathToId$1", "invoke"));
                }
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return LookupStorage.access$addFileIfNeeded(this.this$0, new File(it));
            }
            {
                this.this$0 = lookupStorage;
                super(1);
            }
        }));
        Iterator<? extends Map.Entry<LookupSymbol, ? extends Collection<String>>> iterator = lookups.iterator();
        while (iterator.hasNext()) {
            void destination$iv;
            void $receiver$iv;
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<LookupSymbol, ? extends Collection<String>> entry;
            Map.Entry<LookupSymbol, ? extends Collection<String>> entry2 = entry = iterator.next();
            LookupSymbol lookupSymbol = (LookupSymbol)$receiver$iv3.getKey();
            Map.Entry<LookupSymbol, ? extends Collection<String>> $i$f$component1 = entry;
            Collection paths = (Collection)$receiver$iv2.getValue();
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Iterable iterable = paths;
            Collection collection = new HashSet();
            for (Object item$iv : $receiver$iv) {
                void it;
                String string = (String)item$iv;
                void var17_15 = destination$iv;
                Object v = pathToId2.get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Integer n = ((Number)v).intValue();
                var17_15.add(n);
            }
            HashSet fileIds = (HashSet)destination$iv;
            Collection collection2 = this.lookupMap.get(key);
            if (collection2 == null) {
                collection2 = SetsKt.emptySet();
            }
            fileIds.addAll(collection2);
            this.lookupMap.set(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/incremental/LookupStorage", "removeLookupsFrom"));
        }
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        for (File file : files) {
            Integer n = this.fileToId.get(file);
            if (n == null) {
                continue;
            }
            int id = ((Number)n).intValue();
            this.idToFile.remove(id);
            this.fileToId.remove(file);
            int n2 = this.deletedCount++;
        }
    }

    @Override
    public synchronized void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        this.deletedCount = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        try {
            LookupStorage.removeGarbageIfNeeded$default(this, false, 1, null);
            if (this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)(this.size + "\n" + this.deletedCount), null, (int)2, null);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file) {
        Integer existing = this.fileToId.get(file);
        if (existing != null) {
            return ((Number)existing).intValue();
        }
        int id = this.size++;
        this.fileToId.set(file, id);
        this.idToFile.set(id, file);
        return id;
    }

    private final void removeGarbageIfNeeded(boolean force) {
        if (force || this.size > LookupStorage.Companion.getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() && (double)this.deletedCount / (double)this.size > LookupStorage.Companion.getDELETED_TO_SIZE_TRESHOLD()) {
            this.doRemoveGarbage();
        }
    }

    static /* bridge */ /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeGarbageIfNeeded");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        lookupStorage.removeGarbageIfNeeded(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void doRemoveGarbage() {
        void key$iv;
        Iterator<Object> iterator;
        Map.Entry<File, Integer> $receiver$iv;
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            LookupMap lookupMap = this.lookupMap;
            iterator = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            lookupMap.set(lookupSymbolKey, kotlin.collections.CollectionsKt.toSet((Iterable)list));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        this.deletedCount = 0;
        iterator = oldFileToId.entrySet().iterator();
        while (iterator.hasNext()) {
            void value$iv;
            void $receiver$iv2;
            void $receiver$iv3;
            void $receiver$iv4;
            Map.Entry<File, Integer> entry = $receiver$iv = iterator.next();
            File file = (File)$receiver$iv4.getKey();
            Map.Entry<File, Integer> $i$f$component1 = $receiver$iv;
            int oldId = ((Number)$receiver$iv3.getValue()).intValue();
            int newId = this.addFileIfNeeded(file);
            Map $i$f$component2 = oldIdToNewId;
            Integer $i$a$1 = oldId;
            Integer $i$f$filterTo = newId;
            $receiver$iv2.put(key$iv, value$iv);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv5;
            Collection<Integer> collection = this.lookupMap.get(lookup);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable oldId = collection;
            void newId = $receiver$iv5;
            Collection $receiver$iv2 = new ArrayList();
            key$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Boolean bl;
                Object element$iv$iv = element$iv$iv$iv;
                int it = ((Number)element$iv$iv).intValue();
                if ((Integer)oldIdToNewId.get(it) != null) {
                    void $receiver$iv$iv$iv2;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            Set fileIds = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageIfNeeded(true);
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        Object value$iv$iv$iv;
        void destination$iv$iv;
        LookupSymbol it;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (lookupSymbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupSymbols", "org/jetbrains/kotlin/incremental/LookupStorage", "dump"));
        }
        Intrinsics.checkParameterIsNotNull(lookupSymbols, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer((Appendable)sb);
        Iterable iterable = lookupSymbols;
        Iterator iterator = $receiver$iv;
        Map map = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            void $receiver$iv$iv$iv;
            it = (LookupSymbol)element$iv$iv;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Iterator iterator2 = destination$iv$iv;
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        void lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : kotlin.collections.CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Collection<Integer> fileIds;
            String string;
            Object object;
            void var20_18;
            void destination$iv$iv3;
            Iterable $receiver$iv$iv3;
            Iterable $receiver$iv3;
            Object element$iv$iv;
            if (this.lookupMap.get(lookup) == null) {
                Intrinsics.throwNpe();
            }
            element$iv$iv = lookupsStrings;
            it = $receiver$iv3;
            if (((Map)((Object)$receiver$iv$iv3)).containsKey(lookup)) {
                Object v = lookupsStrings.get(lookup);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                $receiver$iv3 = (Iterable)v;
                $receiver$iv$iv3 = $receiver$iv3;
                Collection $i$f$containsKey = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    void it2;
                    value$iv$iv$iv = (LookupSymbol)item$iv$iv;
                    var20_18 = destination$iv$iv3;
                    object = it2.getScope() + "#" + it2.getName();
                    var20_18.add(object);
                }
                string = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = lookup.toString();
            }
            String key = string;
            $receiver$iv$iv3 = fileIds;
            destination$iv$iv3 = $receiver$iv2;
            Collection $i$f$contains = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it3;
                int $i$a$1 = ((Number)item$iv$iv).intValue();
                var20_18 = destination$iv$iv2;
                Object object2 = this.idToFile.get((int)it3);
                if (object2 == null || (object2 = ((File)object2).getAbsolutePath()) == null) {
                    object2 = String.valueOf((int)it3);
                }
                object = object2;
                var20_18.add(object);
            }
            String value = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            p.println(new Object[]{key + " -> " + value});
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/incremental/LookupStorage", "dump"));
        }
        return string;
    }

    public LookupStorage(@NotNull File targetDataDir) {
        if (targetDataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDataDir", "org/jetbrains/kotlin/incremental/LookupStorage", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull((Object)targetDataDir, (String)"targetDataDir");
        this.targetDataDir = targetDataDir;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file")));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id")));
        this.lookupMap = (LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups")));
        if (this.countersFile.exists()) {
            String $receiver$iv;
            int n;
            List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
            String string = (String)lines.get(0);
            LookupStorage lookupStorage = this;
            lookupStorage.size = n = Integer.parseInt($receiver$iv);
            $receiver$iv = (String)lines.get(1);
            lookupStorage = this;
            lookupStorage.deletedCount = n = Integer.parseInt($receiver$iv);
        }
    }

    static {
        DELETED_TO_SIZE_TRESHOLD = 0.5;
        MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    }

    public static final /* synthetic */ int access$addFileIfNeeded(LookupStorage $this, @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/incremental/LookupStorage", "access$addFileIfNeeded"));
        }
        return $this.addFileIfNeeded(file);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "getDELETED_TO_SIZE_TRESHOLD", "()D", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "getMINIMUM_GARBAGE_COLLECTIBLE_SIZE", "()I", "kotlin-build-common"})
    public static final class Companion {
        private final double getDELETED_TO_SIZE_TRESHOLD() {
            return DELETED_TO_SIZE_TRESHOLD;
        }

        private final int getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() {
            return MINIMUM_GARBAGE_COLLECTIBLE_SIZE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

