/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery;

import com.intellij.rt.coverage.testDiscovery.InstrumentedMethodsFilter;
import java.util.ArrayList;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInstrumenter
extends ClassVisitor {
    private static final int ADDED_CODE_STACK_SIZE = 6;
    protected final ClassVisitor myClassVisitor;
    private final String myClassName;
    private final String myInternalClassName;
    private final InstrumentedMethodsFilter myMethodFilter;
    private final String[] myMethodNames;
    private int myCurrentMethodCount;
    private boolean myVisitedStaticBlock;
    private static final String METHODS_VISITED = "__$methodsVisited$__";
    private static final String METHODS_VISITED_CLASS = "[Z";

    public TestDiscoveryInstrumenter(ClassVisitor classVisitor, ClassReader cr, String className) {
        super(327680, classVisitor);
        this.myClassVisitor = classVisitor;
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = className.replace('$', '.');
        this.myInternalClassName = className.replace('.', '/');
        this.myMethodNames = this.collectMethodNames(cr, className);
    }

    private String[] collectMethodNames(ClassReader cr, final String className) {
        final ArrayList instrumentedMethods = new ArrayList();
        ClassVisitor instrumentedMethodCounter = new ClassVisitor(327680){
            final InstrumentedMethodsFilter methodsFilter;
            {
                super(x0);
                this.methodsFilter = new InstrumentedMethodsFilter(className);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.methodsFilter.visit(version, access, name, signature, superName, interfaces);
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (this.methodsFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
                    if ("<init>".equals(name)) {
                        int slashPos = className.lastIndexOf(46);
                        int $Pos = className.lastIndexOf(36);
                        name = className.substring(Math.max(slashPos, $Pos) + 1);
                    }
                    instrumentedMethods.add(name);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept(instrumentedMethodCounter, 0);
        return instrumentedMethods.toArray(new String[instrumentedMethods.size()]);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if ("<clinit>".equals(name)) {
            this.myVisitedStaticBlock = true;
            return new StaticBlockMethodVisitor(mv);
        }
        if (!this.myMethodFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
            return mv;
        }
        return new MethodVisitor(327680, mv){
            final int myMethodId;
            {
                this.myMethodId = TestDiscoveryInstrumenter.this.myCurrentMethodCount++;
            }

            public void visitCode() {
                this.visitFieldInsn(178, TestDiscoveryInstrumenter.this.myInternalClassName, TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
                TestDiscoveryInstrumenter.pushInstruction(this, this.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
    }

    public void visitEnd() {
        this.visitField(25, METHODS_VISITED, METHODS_VISITED_CLASS, null, null);
        if (!this.myVisitedStaticBlock) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv = new StaticBlockMethodVisitor(mv);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(6, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
        } else {
            mv.visitIntInsn(17, operand);
        }
    }

    private class StaticBlockMethodVisitor
    extends MethodVisitor {
        public StaticBlockMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            super.visitCode();
            this.visitLdcInsn(TestDiscoveryInstrumenter.this.myClassName);
            TestDiscoveryInstrumenter.pushInstruction(this, TestDiscoveryInstrumenter.this.myMethodNames.length);
            this.visitIntInsn(188, 4);
            TestDiscoveryInstrumenter.pushInstruction(this, TestDiscoveryInstrumenter.this.myMethodNames.length);
            this.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < TestDiscoveryInstrumenter.this.myMethodNames.length; ++i) {
                this.visitInsn(89);
                TestDiscoveryInstrumenter.pushInstruction(this, i);
                this.visitLdcInsn(TestDiscoveryInstrumenter.this.myMethodNames[i]);
                this.visitInsn(83);
            }
            this.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)[Z", false);
            this.visitFieldInsn(179, TestDiscoveryInstrumenter.this.myInternalClassName, TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            int ourMaxStack = 6;
            super.visitMaxs(Math.max(6, maxStack), maxLocals);
        }
    }
}

