/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitUntrackedFilesHolder;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    private GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir, @NotNull GitPlatformFacade facade, @NotNull Project project, @NotNull Disposable parentDisposable, boolean light) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "git4idea/repo/GitRepositoryImpl", "<init>"));
        }
        super(project, rootDir, parentDisposable);
        this.myPlatformFacade = facade;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.myGitDir = gitDir;
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        this.myReader = new GitRepositoryReader(this.myRepositoryFiles);
        this.myInfo = this.readRepoInfo();
        if (!light) {
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
        } else {
            this.myUntrackedFilesHolder = null;
        }
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        GitRepository gitRepository = GitRepositoryImpl.getInstance(root, (VirtualFile)ObjectUtils.assertNotNull((Object)GitUtil.findGitDir(root)), project, listenToRepoChanges);
        if (gitRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        return gitRepository;
    }

    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, boolean listenToRepoChanges) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        GitPlatformFacade platformFacade = (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class);
        GitRepositoryImpl repository = new GitRepositoryImpl(root, gitDir, platformFacade, project, (Disposable)project, !listenToRepoChanges);
        if (listenToRepoChanges) {
            repository.getUntrackedFilesHolder().setupVfsListener(project);
            repository.setupUpdater();
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
        GitRepositoryImpl gitRepositoryImpl = repository;
        if (gitRepositoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getInstance"));
        }
        return gitRepositoryImpl;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    @NotNull
    public VirtualFile getGitDir() {
        VirtualFile virtualFile = this.myGitDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getGitDir"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        GitUntrackedFilesHolder gitUntrackedFilesHolder = this.myUntrackedFilesHolder;
        if (gitUntrackedFilesHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getUntrackedFilesHolder"));
        }
        return gitUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        GitRepoInfo gitRepoInfo = this.myInfo;
        if (gitRepoInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getInfo"));
        }
        return gitRepoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getState"));
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @NotNull
    public AbstractVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getVcs"));
        }
        return gitVcs;
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        GitBranchesCollection gitBranchesCollection = new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes());
        if (gitBranchesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getBranches"));
        }
        return gitBranchesCollection;
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        Collection<GitRemote> collection = this.myInfo.getRemotes();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getRemotes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Collection<GitBranchTrackInfo> collection = this.myInfo.getBranchTrackInfos();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "getBranchTrackInfos"));
        }
        return collection;
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public void update() {
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyIfRepoChanged(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        File configFile = new File(FileUtil.toSystemDependentName((String)this.myRepositoryFiles.getConfigPath()));
        GitConfig config = GitConfig.read(this.myPlatformFacade, configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches().keySet(), state.getRemoteBranches().keySet());
        GitRepoInfo gitRepoInfo = new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), remotes, state.getLocalBranches(), state.getRemoteBranches(), trackInfos);
        if (gitRepoInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "readRepoInfo"));
        }
        return gitRepoInfo;
    }

    private static void notifyIfRepoChanged(@NotNull GitRepository repository, @NotNull GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/repo/GitRepositoryImpl", "notifyIfRepoChanged"));
        }
        if (previousInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousInfo", "git4idea/repo/GitRepositoryImpl", "notifyIfRepoChanged"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "git4idea/repo/GitRepositoryImpl", "notifyIfRepoChanged"));
        }
        if (!repository.getProject().isDisposed() && !info.equals(previousInfo)) {
            GitRepositoryImpl.notifyListenersAsync(repository);
        }
    }

    private static void notifyListenersAsync(final @NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/repo/GitRepositoryImpl", "notifyListenersAsync"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Project project = repository.getProject();
                if (!project.isDisposed()) {
                    ((GitRepositoryChangeListener)project.getMessageBus().syncPublisher(GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository);
                }
            }
        });
    }

    @NotNull
    public String toLogString() {
        String string = "GitRepository " + this.getRoot() + " : " + this.myInfo;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryImpl", "toLogString"));
        }
        return string;
    }
}

