/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InefficientWeightDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(InefficientWeightDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue INEFFICIENT_WEIGHT = Issue.create("InefficientWeight", "Inefficient layout weight", "When only a single widget in a LinearLayout defines a weight, it is more efficient to assign a width/height of `0dp` to it since it will absorb all the remaining space anyway. With a declared width/height of `0dp` it does not have to measure its own size first.", Category.PERFORMANCE, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue NESTED_WEIGHTS = Issue.create("NestedWeights", "Nested layout weights", "Layout weights require a widget to be measured twice. When a LinearLayout with non-zero weights is nested inside another LinearLayout with non-zero weights, then the number of measurements increase exponentially.", Category.PERFORMANCE, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue BASELINE_WEIGHTS = Issue.create("DisableBaselineAlignment", "Missing `baselineAligned` attribute", "When a LinearLayout is used to distribute the space proportionally between nested layouts, the baseline alignment property should be turned off to make the layout computation faster.", Category.PERFORMANCE, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue WRONG_0DP = Issue.create("Suspicious0dp", "Suspicious 0dp dimension", "Using 0dp as the width in a horizontal LinearLayout with weights is a useful trick to ensure that only the weights (and not the intrinsic sizes) are used when sizing the children.\n\nHowever, if you use 0dp for the opposite dimension, the view will be invisible. This can happen if you change the orientation of a layout without also flipping the 0dp dimension in all the children.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue ORIENTATION = Issue.create("Orientation", "Missing explicit orientation", "The default orientation of a LinearLayout is horizontal. It's pretty easy to believe that the layout is vertical, add multiple children to it, and wonder why only the first child is visible (when the subsequent children are off screen to the right). This lint rule helps pinpoint this issue by warning whenever a LinearLayout is used with an implicit orientation and multiple children.\n\nIt also checks for empty LinearLayouts without an `orientation` attribute that also defines an `id` attribute. This catches the scenarios where children will be added to the `LinearLayout` dynamically. ", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
    private final Map<Node, Boolean> mInsideWeight = new IdentityHashMap<Node, Boolean>();

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("LinearLayout");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        List<Element> children = LintUtils.getChildren(element);
        boolean multipleWeights = false;
        Element weightChild = null;
        boolean checkNesting = context.isEnabled(NESTED_WEIGHTS);
        for (Element child : children) {
            if (!child.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) continue;
            if (weightChild != null) {
                multipleWeights = true;
            } else if (!multipleWeights) {
                weightChild = child;
            }
            if (!checkNesting) continue;
            this.mInsideWeight.put(child, Boolean.TRUE);
            Boolean inside = this.mInsideWeight.get(element);
            if (inside == null) {
                this.mInsideWeight.put(element, Boolean.FALSE);
                continue;
            }
            if (!inside.booleanValue()) continue;
            Attr sizeNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_weight");
            context.report(NESTED_WEIGHTS, sizeNode, context.getLocation(sizeNode), "Nested weights are bad for performance");
            checkNesting = false;
        }
        String orientation = element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
        if (children.size() >= 2 && (orientation == null || orientation.isEmpty()) && context.isEnabled(ORIENTATION)) {
            boolean maxWidthSet = false;
            Iterator<Element> iterator = children.iterator();
            while (iterator.hasNext()) {
                Element child = iterator.next();
                if (!iterator.hasNext()) break;
                String width = child.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
                if (!"match_parent".equals(width) && !"fill_parent".equals(width) || child.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) continue;
                maxWidthSet = true;
                break;
            }
            if (maxWidthSet && !element.hasAttribute("style")) {
                String message = "Wrong orientation? No orientation specified, and the default is horizontal, yet this layout has multiple children where at least one has `layout_width=\"match_parent\"`";
                context.report(ORIENTATION, element, context.getLocation(element), message);
            }
        } else if (children.isEmpty() && (orientation == null || orientation.isEmpty()) && context.isEnabled(ORIENTATION) && element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id")) {
            List<ResourceValue> values;
            boolean ignore = element.hasAttribute("style") ? (context.getClient().supportsProjectResources() ? (values = LintUtils.getStyleAttributes(context.getMainProject(), context.getClient(), element.getAttribute("style"), "http://schemas.android.com/apk/res/android", "orientation")) != null && !values.isEmpty() : true) : false;
            if (!ignore) {
                String message = "No orientation specified, and the default is horizontal. This is a common source of bugs when children are added dynamically.";
                context.report(ORIENTATION, element, context.getLocation(element), message);
            }
        }
        if (context.isEnabled(BASELINE_WEIGHTS) && weightChild != null && !"vertical".equals(orientation) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "baselineAligned")) {
            boolean allChildrenAreLayouts = !children.isEmpty();
            SdkInfo sdkInfo = context.getClient().getSdkInfo(context.getProject());
            for (Element child : children) {
                String tagName = child.getTagName();
                if (sdkInfo.isLayout(tagName) && !tagName.equals("RadioGroup") || "fragment".equals(tagName) || "include".equals(tagName)) continue;
                allChildrenAreLayouts = false;
            }
            if (allChildrenAreLayouts) {
                context.report(BASELINE_WEIGHTS, element, context.getLocation(element), "Set `android:baselineAligned=\"false\"` on this element for better performance");
            }
        }
        if (context.isEnabled(INEFFICIENT_WEIGHT) && weightChild != null && !multipleWeights) {
            String size;
            String dimension = "vertical".equals(orientation) ? "layout_height" : "layout_width";
            Attr sizeNode = weightChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", dimension);
            String string = size = sizeNode != null ? sizeNode.getValue() : "(undefined)";
            if (sizeNode == null && weightChild.hasAttribute("style")) {
                String style = weightChild.getAttribute("style");
                List<ResourceValue> sizes = LintUtils.getStyleAttributes(context.getMainProject(), context.getClient(), style, "http://schemas.android.com/apk/res/android", dimension);
                if (sizes != null) {
                    for (ResourceValue value : sizes) {
                        String v = value.getValue();
                        if (v == null) continue;
                        size = v;
                        if (!v.startsWith("0")) continue;
                        break;
                    }
                }
            }
            if (!size.startsWith("0")) {
                String msg = String.format("Use a `%1$s` of `0dp` instead of `%2$s` for better performance", dimension, size);
                context.report(INEFFICIENT_WEIGHT, weightChild, context.getLocation(sizeNode != null ? sizeNode : weightChild), msg);
            }
        }
        if (context.isEnabled(WRONG_0DP)) {
            InefficientWeightDetector.checkWrong0Dp(context, element, children);
        }
    }

    private static void checkWrong0Dp(XmlContext context, Element element, List<Element> children) {
        boolean isVertical = false;
        String orientation = element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation");
        if ("vertical".equals(orientation)) {
            isVertical = true;
        }
        for (Element child : children) {
            String tagName = child.getTagName();
            if (tagName.equals("View")) {
                return;
            }
            if (tagName.indexOf(46) != -1 || tagName.equals("view")) {
                return;
            }
            boolean hasWeight = child.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight");
            Attr widthNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            Attr heightNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
            boolean noWidth = false;
            boolean noHeight = false;
            if (widthNode != null && widthNode.getValue().startsWith("0")) {
                noWidth = true;
            }
            if (heightNode != null && heightNode.getValue().startsWith("0")) {
                noHeight = true;
            } else if (!noWidth) {
                return;
            }
            if (noWidth && noHeight) {
                return;
            }
            if (noWidth) {
                if (!hasWeight) {
                    context.report(WRONG_0DP, widthNode, context.getLocation(widthNode), "Suspicious size: this will make the view invisible, should be used with `layout_weight`");
                    continue;
                }
                if (!isVertical) continue;
                context.report(WRONG_0DP, widthNode, context.getLocation(widthNode), "Suspicious size: this will make the view invisible, probably intended for `layout_height`");
                continue;
            }
            if (!hasWeight) {
                context.report(WRONG_0DP, widthNode, context.getLocation(heightNode), "Suspicious size: this will make the view invisible, should be used with `layout_weight`");
                continue;
            }
            if (isVertical) continue;
            context.report(WRONG_0DP, widthNode, context.getLocation(heightNode), "Suspicious size: this will make the view invisible, probably intended for `layout_width`");
        }
    }
}

