/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;
import org.jetbrains.idea.devkit.module.PluginModuleType;

@com.intellij.openapi.components.State(name="DevKit.ModuleBuildProperties", storages={@Storage(value="$MODULE_FILE$")})
public class PluginBuildConfiguration
implements PersistentStateComponent<State> {
    private final Module myModule;
    private final ConfigFileContainer myPluginXmlContainer;
    private VirtualFilePointer myManifestFilePointer;
    private boolean myUseUserManifest;
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";
    private State state;

    public PluginBuildConfiguration(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "<init>"));
        }
        this.myUseUserManifest = false;
        this.state = new State();
        this.myModule = module;
        this.myPluginXmlContainer = ConfigFileFactory.getInstance().createSingleFileContainer(this.myModule.getProject(), PluginDescriptorConstants.META_DATA);
        Disposer.register((Disposable)module, (Disposable)this.myPluginXmlContainer);
    }

    @Nullable
    public static PluginBuildConfiguration getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getInstance"));
        }
        return ModuleType.is((Module)module, (ModuleType)PluginModuleType.getInstance()) ? (PluginBuildConfiguration)ModuleServiceManager.getService((Module)module, PluginBuildConfiguration.class) : null;
    }

    @Nullable
    public State getState() {
        this.state.url = this.getPluginXmlUrl();
        this.state.manifest = this.myManifestFilePointer == null ? null : this.myManifestFilePointer.getUrl();
        return this.state;
    }

    public void loadState(State state) {
        this.state = state;
        if (state.url != null) {
            this.myPluginXmlContainer.getConfiguration().replaceConfigFile(PluginDescriptorConstants.META_DATA, state.url);
        }
        if (state.manifest != null) {
            this.setManifestPath(VfsUtilCore.urlToPath((String)state.manifest));
        }
    }

    @Nullable
    public ConfigFile getPluginXML() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    public void setPluginXmlFromVirtualFile(VirtualFile virtualFile) {
        this.myPluginXmlContainer.getConfiguration().replaceConfigFile(PluginDescriptorConstants.META_DATA, virtualFile.getUrl());
    }

    private void createDescriptor(String url) {
        ConfigFileInfo descriptor = new ConfigFileInfo(PluginDescriptorConstants.META_DATA, url);
        this.myPluginXmlContainer.getConfiguration().addConfigFile(descriptor);
        ConfigFileFactory.getInstance().createFile(this.myModule.getProject(), descriptor.getUrl(), PluginDescriptorConstants.META_DATA.getDefaultVersion(), false);
    }

    @Nullable
    public ConfigFile getPluginXmlConfigFile() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    @Nullable
    private String getPluginXmlUrl() {
        ConfigFile configFile = this.getPluginXmlConfigFile();
        return configFile != null ? configFile.getUrl() : null;
    }

    private String getDefaultLocation() {
        return new File(this.myModule.getModuleFilePath()).getParent() + File.separator + META_INF + File.separator + PLUGIN_XML;
    }

    @NotNull
    public String getPluginXmlPath() {
        String url = this.getPluginXmlUrl();
        if (url == null) {
            String string = this.getDefaultLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getPluginXmlPath"));
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getPluginXmlPath"));
        }
        return string;
    }

    public void setPluginXmlPathAndCreateDescriptorIfDoesntExist(final String pluginXmlPath) {
        this.myPluginXmlContainer.getConfiguration().removeConfigFiles(new ConfigFileMetaData[]{PluginDescriptorConstants.META_DATA});
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration$1", "run"));
                }
                PluginBuildConfiguration.this.createDescriptor(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)pluginXmlPath)));
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifestPath(@Nullable String manifestPath) {
        if (StringUtil.isEmpty((String)manifestPath)) {
            this.myManifestFilePointer = null;
            return;
        }
        VirtualFile manifest = LocalFileSystem.getInstance().findFileByPath(manifestPath);
        if (manifest == null) {
            Messages.showErrorDialog((Project)this.myModule.getProject(), (String)DevKitBundle.message("error.file.not.found.message", manifestPath), (String)DevKitBundle.message("error.file.not.found", new Object[0]));
            AccessToken token = ReadAction.start();
            try {
                this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)manifestPath)), (Disposable)this.myModule, null);
            }
            finally {
                token.finish();
            }
        }
        AccessToken token = ReadAction.start();
        try {
            this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(manifest, (Disposable)this.myModule, null);
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public String getManifestPath() {
        return this.myManifestFilePointer != null ? FileUtil.toSystemDependentName((String)this.myManifestFilePointer.getPresentableUrl()) : null;
    }

    @Nullable
    public VirtualFile getManifest() {
        return this.myManifestFilePointer != null ? this.myManifestFilePointer.getFile() : null;
    }

    public boolean isUseUserManifest() {
        return this.myUseUserManifest;
    }

    public void setUseUserManifest(boolean useUserManifest) {
        this.myUseUserManifest = useUserManifest;
    }

    static class State {
        @Attribute
        String url;
        @Attribute
        String manifest;

        State() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.url != null ? !this.url.equals(state.url) : state.url != null) {
                return false;
            }
            return !(this.manifest != null ? !this.manifest.equals(state.manifest) : state.manifest != null);
        }

        public int hashCode() {
            int result = this.url != null ? this.url.hashCode() : 0;
            result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
            return result;
        }
    }
}

