/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourcePosition
implements Navigatable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.SourcePosition");

    @NotNull
    public abstract PsiFile getFile();

    public abstract PsiElement getElementAt();

    public abstract int getLine();

    public abstract int getOffset();

    public abstract Editor openEditor(boolean var1);

    public static SourcePosition createFromLineComputable(@NotNull PsiFile file, final Computable<Integer> line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/SourcePosition", "createFromLineComputable"));
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcLine() {
                return (Integer)line.compute();
            }
        };
    }

    public static SourcePosition createFromLine(@NotNull PsiFile file, final int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/SourcePosition", "createFromLine"));
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcLine() {
                return line;
            }

            public String toString() {
                return this.getFile().getName() + ":" + line;
            }
        };
    }

    public static SourcePosition createFromOffset(@NotNull PsiFile file, final int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/SourcePosition", "createFromOffset"));
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcOffset() {
                return offset;
            }

            public String toString() {
                return this.getFile().getName() + " offset " + offset;
            }
        };
    }

    @Nullable
    public static SourcePosition createFromElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/SourcePosition", "createFromElement"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement navigationElement = element.getNavigationElement();
        final SmartPsiElementPointer<PsiElement> pointer = SmartPointerManager.getInstance(navigationElement.getProject()).createSmartPsiElementPointer(navigationElement);
        PsiFile psiFile = JspPsiUtil.isInJspFile(navigationElement) ? JspPsiUtil.getJspFile(navigationElement) : navigationElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return new SourcePositionCache(psiFile){

            @Override
            protected PsiElement calcPsiElement() {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                return pointer.getElement();
            }

            @Override
            protected int calcOffset() {
                return ApplicationManager.getApplication().runReadAction(new Computable<Integer>(){

                    public Integer compute() {
                        Object elem = pointer.getElement();
                        return elem != null ? elem.getTextOffset() : -1;
                    }
                });
            }
        };
    }

    public boolean equals(Object o) {
        if (o instanceof SourcePosition) {
            SourcePosition sourcePosition = (SourcePosition)o;
            return Comparing.equal((Object)sourcePosition.getFile(), (Object)this.getFile()) && sourcePosition.getOffset() == this.getOffset();
        }
        return false;
    }

    private static abstract class SourcePositionCache
    extends SourcePosition {
        @NotNull
        private final PsiFile myFile;
        private long myModificationStamp;
        private WeakReference<PsiElement> myPsiElementRef;
        private Integer myLine;
        private Integer myOffset;

        public SourcePositionCache(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/SourcePosition$SourcePositionCache", "<init>"));
            }
            this.myModificationStamp = -1L;
            this.myFile = file;
            this.updateData();
        }

        @Override
        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/SourcePosition$SourcePositionCache", "getFile"));
            }
            return psiFile;
        }

        @Override
        public boolean canNavigate() {
            return this.getFile().isValid();
        }

        @Override
        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        @Override
        public void navigate(final boolean requestFocus) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SourcePositionCache.this.canNavigate()) {
                        return;
                    }
                    SourcePositionCache.this.openEditor(requestFocus);
                }
            });
        }

        @Override
        public Editor openEditor(boolean requestFocus) {
            PsiFile psiFile = this.getFile();
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            int offset = this.getOffset();
            if (offset < 0) {
                return null;
            }
            return FileEditorManager.getInstance(project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), requestFocus);
        }

        private void updateData() {
            if (this.dataUpdateNeeded()) {
                this.myModificationStamp = this.myFile.getModificationStamp();
                this.myLine = null;
                this.myOffset = null;
                this.myPsiElementRef = null;
            }
        }

        private boolean dataUpdateNeeded() {
            if (this.myModificationStamp != this.myFile.getModificationStamp()) {
                return true;
            }
            final PsiElement psiElement = this.myPsiElementRef != null ? (PsiElement)this.myPsiElementRef.get() : null;
            return psiElement != null && ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                public Boolean compute() {
                    return psiElement.isValid();
                }
            }) == false;
        }

        @Override
        public int getLine() {
            this.updateData();
            if (this.myLine == null) {
                this.myLine = this.calcLine();
            }
            return this.myLine;
        }

        @Override
        public int getOffset() {
            this.updateData();
            if (this.myOffset == null) {
                this.myOffset = this.calcOffset();
            }
            return this.myOffset;
        }

        @Override
        public PsiElement getElementAt() {
            PsiElement element;
            this.updateData();
            PsiElement psiElement = element = this.myPsiElementRef != null ? (PsiElement)this.myPsiElementRef.get() : null;
            if (element == null) {
                element = this.calcPsiElement();
                this.myPsiElementRef = new WeakReference<PsiElement>(element);
                return element;
            }
            return element;
        }

        protected int calcLine() {
            PsiFile file = this.getFile();
            Document document = null;
            try {
                document = SourcePositionCache.getDocument(file);
                if (document == null) {
                    document = SourcePositionCache.getDocument(file.getOriginalFile());
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (document != null) {
                try {
                    return document.getLineNumber(this.calcOffset());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Nullable
        private static Document getDocument(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/SourcePosition$SourcePositionCache", "getDocument"));
            }
            Project project = file.getProject();
            if (project.isDisposed()) {
                return null;
            }
            return PsiDocumentManager.getInstance(project).getDocument(file);
        }

        protected int calcOffset() {
            PsiFile file = this.getFile();
            Document document = SourcePositionCache.getDocument(file);
            if (document != null) {
                try {
                    return document.getLineStartOffset(this.calcLine());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Nullable
        protected PsiElement calcPsiElement() {
            PsiFile origPsiFile = this.getFile();
            final PsiFile psiFile = origPsiFile instanceof PsiCompiledFile ? ((PsiCompiledFile)origPsiFile).getDecompiledPsiFile() : origPsiFile;
            int lineNumber = this.getLine();
            if (lineNumber < 0) {
                return psiFile;
            }
            final Document document = SourcePositionCache.getDocument(origPsiFile);
            if (document == null) {
                return null;
            }
            if (lineNumber >= document.getLineCount()) {
                return psiFile;
            }
            int startOffset = document.getLineStartOffset(lineNumber);
            if (startOffset == -1) {
                return null;
            }
            return ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

                public PsiElement compute() {
                    PsiClass[] classes;
                    PsiClassOwner owner;
                    NavigatablePsiElement rootElement = psiFile;
                    List<PsiFile> allFiles = psiFile.getViewProvider().getAllFiles();
                    if (allFiles.size() > 1 && (owner = (PsiClassOwner)ContainerUtil.findInstance(allFiles, PsiClassOwner.class)) != null && (classes = owner.getClasses()).length == 1 && classes[0] instanceof SyntheticElement) {
                        rootElement = classes[0];
                    }
                    PsiElement element = null;
                    int offset = SourcePositionCache.this.getOffset();
                    while (true) {
                        char c;
                        CharSequence charsSequence = document.getCharsSequence();
                        while (offset < charsSequence.length() && ((c = charsSequence.charAt(offset)) == ' ' || c == '\t')) {
                            ++offset;
                        }
                        if (offset >= charsSequence.length() || !((element = rootElement.findElementAt(offset)) instanceof PsiComment)) break;
                        offset = element.getTextRange().getEndOffset() + 1;
                    }
                    if (element != null && element.getParent() instanceof PsiForStatement) {
                        return ((PsiForStatement)element.getParent()).getInitialization();
                    }
                    return element;
                }
            });
        }
    }
}

