/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadonlySource;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0007R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/settingsRepository/ReadOnlySourcesManager;", "", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "rootDir", "Ljava/io/File;", "(Lorg/jetbrains/settingsRepository/IcsSettings;Ljava/io/File;)V", "_repositories", "", "Lorg/eclipse/jgit/lib/Repository;", "repositories", "getRepositories", "()Ljava/util/List;", "getRootDir", "()Ljava/io/File;", "setSources", "", "sources", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "sourceToDir", "source", "settings-repository"})
public final class ReadOnlySourcesManager {
    private List<? extends Repository> _repositories;
    private final IcsSettings settings;
    @NotNull
    private final File rootDir;

    @NotNull
    public final List<Repository> getRepositories() {
        List r = this._repositories;
        if (r == null) {
            if (this.settings.getReadOnlySources().isEmpty()) {
                r = CollectionsKt.emptyList();
            } else {
                r = (List)new SmartList();
                for (ReadonlySource source : this.settings.getReadOnlySources()) {
                    try {
                        String path;
                        if (source.getPath() == null) {
                            continue;
                        }
                        File dir = new File(this.rootDir, path);
                        if (dir.exists()) {
                            ((SmartList)r).add((Object)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build());
                            continue;
                        }
                        IcsManagerKt.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exists");
                    }
                    catch (Exception e) {
                        IcsManagerKt.getLOG().error((Throwable)e);
                    }
                }
            }
            this._repositories = r;
        }
        return r;
    }

    public final void setSources(@NotNull List<ReadonlySource> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.settings.setReadOnlySources(sources);
        this._repositories = null;
    }

    @NotNull
    public final File sourceToDir(@NotNull ReadonlySource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        String string = source.getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new File(this.rootDir, string);
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public ReadOnlySourcesManager(@NotNull IcsSettings settings, @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.settings = settings;
        this.rootDir = rootDir;
    }
}

