/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class EditTaskDialog
extends DialogWrapper {
    private final LocalTaskImpl myTask;
    private JPanel myPanel;
    private JTextField mySummary;
    private JBLabel myBranchLabel;
    private ComboBox myBranch;
    private JBLabel myChangelistLabel;
    private ComboBox myChangelist;

    public static void editTask(LocalTaskImpl task, Project project) {
        new EditTaskDialog(project, task).show();
    }

    protected EditTaskDialog(Project project, LocalTaskImpl task) {
        super(project);
        this.myTask = task;
        this.$$$setupUI$$$();
        this.setTitle("Edit Task " + (task.isIssue() ? task.getId() : ""));
        this.mySummary.setText(task.getSummary());
        AbstractVcs vcs = TaskManager.getManager((Project)project).getActiveVcs();
        if (vcs == null) {
            this.myBranchLabel.setVisible(false);
            this.myBranch.setVisible(false);
            this.myChangelistLabel.setVisible(false);
            this.myChangelist.setVisible(false);
        } else {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            List changeLists = changeListManager.getChangeLists();
            changeLists.add(null);
            this.myChangelist.setModel((ComboBoxModel)new CollectionComboBoxModel(changeLists));
            List<ChangeListInfo> lists = task.getChangeLists();
            if (!lists.isEmpty()) {
                LocalChangeList list = changeListManager.getChangeList(lists.get((int)0).id);
                this.myChangelist.setSelectedItem((Object)list);
            } else {
                this.myChangelist.setSelectedItem(null);
            }
            VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers((Project)project);
            if (handlers.length == 0) {
                this.myBranchLabel.setVisible(false);
                this.myBranch.setVisible(false);
            } else {
                Object[] tasks = handlers[0].getAllExistingTasks();
                ArrayList<VcsTaskHandler.TaskInfo> infos = new ArrayList<VcsTaskHandler.TaskInfo>(Arrays.asList(tasks));
                Collections.sort(infos);
                infos.add(null);
                this.myBranch.setModel((ComboBoxModel)new CollectionComboBoxModel(infos));
                final List branches = task.getBranches(false);
                if (!branches.isEmpty()) {
                    VcsTaskHandler.TaskInfo info = (VcsTaskHandler.TaskInfo)ContainerUtil.find((Object[])tasks, (Condition)new Condition<VcsTaskHandler.TaskInfo>(){

                        public boolean value(VcsTaskHandler.TaskInfo info) {
                            return ((BranchInfo)branches.get((int)0)).name.equals(info.getName());
                        }
                    });
                    this.myBranch.setSelectedItem((Object)info);
                } else {
                    this.myBranch.setSelectedItem(null);
                }
            }
        }
        this.init();
    }

    protected void doOKAction() {
        this.myTask.setSummary(this.mySummary.getText());
        if (this.myChangelist.isVisible()) {
            List<ChangeListInfo> changeLists = this.myTask.getChangeLists();
            changeLists.clear();
            LocalChangeList item = (LocalChangeList)this.myChangelist.getSelectedItem();
            if (item != null) {
                changeLists.add(new ChangeListInfo(item));
            }
        }
        if (this.myBranch.isVisible()) {
            List<BranchInfo> branches = this.myTask.getBranches();
            branches.clear();
            VcsTaskHandler.TaskInfo branch = (VcsTaskHandler.TaskInfo)this.myBranch.getSelectedItem();
            if (branch != null) {
                List infos = BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)branch, (boolean)false);
                branches.addAll(infos);
            }
        }
        this.close(0);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySummary;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        ComboBox comboBox;
        JBLabel jBLabel;
        ComboBox comboBox2;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myBranchLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Associated branch");
        jBLabel2.setDisplayedMnemonic('B');
        jBLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBranch = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myChangelistLabel = jBLabel = new JBLabel();
        jBLabel.setText("Associated changelist");
        jBLabel.setDisplayedMnemonic('L');
        jBLabel.setDisplayedMnemonicIndex(17);
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myChangelist = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Summary");
        jBLabel3.setDisplayedMnemonic('S');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySummary = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(300, -1), null, null));
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

