/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.core.AbstractModelAction;
import org.gradle.model.internal.core.ChainingModelProjection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ProjectionBackedModelCreator
implements ModelCreator {
    private final ModelPath path;
    private final ModelRuleDescriptor descriptor;
    private final boolean service;
    private final boolean ephemeral;
    private final ModelProjection projection;
    private final List<ModelProjection> projections;
    private final ListMultimap<ModelActionRole, ? extends ModelAction> actions;

    public ProjectionBackedModelCreator(ModelPath path, ModelRuleDescriptor descriptor, boolean service, boolean ephemeral, final boolean hidden, Iterable<? extends ModelProjection> initialProjections, Multimap<ModelActionRole, ? extends ModelAction> actions) {
        this.path = path;
        this.descriptor = descriptor;
        this.service = service;
        this.ephemeral = ephemeral;
        this.projections = Lists.newArrayList(initialProjections);
        this.projection = new ChainingModelProjection(this.projections);
        ImmutableListMultimap.Builder actionsBuilder = ImmutableListMultimap.builder();
        actionsBuilder.putAll(actions);
        actionsBuilder.put((Object)ModelActionRole.DefineProjections, (Object)new AbstractModelAction<Object>(ModelReference.of(path), descriptor, new ModelReference[0]){

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                modelNode.setHidden(hidden);
            }
        });
        this.actions = actionsBuilder.build();
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelPromise getPromise() {
        return this.projection;
    }

    @Override
    public ModelAdapter getAdapter() {
        return this.projection;
    }

    @Override
    public ModelProjection getProjection() {
        return this.projection;
    }

    @Override
    public ListMultimap<ModelActionRole, ? extends ModelAction> getActions() {
        return this.actions;
    }

    @Override
    public Set<? extends ModelReference<?>> getInputs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModelAction action : this.actions.values()) {
            builder.addAll(action.getInputs());
        }
        return builder.build();
    }

    @Override
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @Override
    public boolean isService() {
        return this.service;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void addProjection(ModelProjection projection) {
        this.projections.add(projection);
    }
}

