/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectGeneration;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.RegeneratedClassContext;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.TypeRemapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;

public class InliningContext {
    @Nullable
    private final InliningContext parent;
    public final Map<Integer, LambdaInfo> expressionMap;
    public final GenerationState state;
    public final NameGenerator nameGenerator;
    public final TypeRemapper typeRemapper;
    public final ReifiedTypeInliner reifedTypeInliner;
    public final boolean isInliningLambda;
    public final boolean classRegeneration;

    protected InliningContext(@Nullable InliningContext parent2, @NotNull Map<Integer, LambdaInfo> map2, @NotNull GenerationState state2, @NotNull NameGenerator nameGenerator, @NotNull TypeRemapper typeRemapper, @NotNull ReifiedTypeInliner reifedTypeInliner, boolean isInliningLambda, boolean classRegeneration) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (nameGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameGenerator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (typeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRemapper", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (reifedTypeInliner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reifedTypeInliner", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        this.parent = parent2;
        this.expressionMap = map2;
        this.state = state2;
        this.nameGenerator = nameGenerator;
        this.typeRemapper = typeRemapper;
        this.reifedTypeInliner = reifedTypeInliner;
        this.isInliningLambda = isInliningLambda;
        this.classRegeneration = classRegeneration;
    }

    public InliningContext subInline(NameGenerator generator) {
        return this.subInline(generator, Collections.<String, String>emptyMap());
    }

    public InliningContext subInlineLambda(LambdaInfo lambdaInfo) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put(lambdaInfo.getLambdaClassType().getInternalName(), null);
        return this.subInline(this.nameGenerator.subGenerator("lambda"), map2, true);
    }

    private InliningContext subInline(NameGenerator generator, Map<String, String> additionalTypeMappings) {
        return this.subInline(generator, additionalTypeMappings, this.isInliningLambda);
    }

    public InliningContext subInlineWithClassRegeneration(@NotNull NameGenerator generator, @NotNull Map<String, String> newTypeMappings, @NotNull AnonymousObjectGeneration anonymousObjectGeneration, @NotNull InlineCallSiteInfo callSiteInfo) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        if (newTypeMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeMappings", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        if (anonymousObjectGeneration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousObjectGeneration", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        if (callSiteInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSiteInfo", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        return new RegeneratedClassContext(this, this.expressionMap, this.state, generator, TypeRemapper.createFrom(this.typeRemapper, newTypeMappings), this.reifedTypeInliner, this.isInliningLambda, anonymousObjectGeneration, callSiteInfo);
    }

    public InliningContext subInline(NameGenerator generator, Map<String, String> additionalTypeMappings, boolean isInliningLambda) {
        return this.subInline(generator, additionalTypeMappings, isInliningLambda, this.classRegeneration);
    }

    private InliningContext subInline(NameGenerator generator, Map<String, String> additionalTypeMappings, boolean isInliningLambda, boolean isRegeneration) {
        return new InliningContext(this, this.expressionMap, this.state, generator, TypeRemapper.createFrom(this.typeRemapper, additionalTypeMappings, isInliningLambda && !this.isInliningLambda), this.reifedTypeInliner, isInliningLambda, isRegeneration);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @NotNull
    public RootInliningContext getRoot() {
        if (this.isRoot()) {
            RootInliningContext rootInliningContext = (RootInliningContext)this;
            if (rootInliningContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "getRoot"));
            }
            return rootInliningContext;
        }
        RootInliningContext rootInliningContext = this.parent.getRoot();
        if (rootInliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "getRoot"));
        }
        return rootInliningContext;
    }

    @Nullable
    public InliningContext getParent() {
        return this.parent;
    }

    public boolean isInliningLambdaRootContext() {
        return this.isInliningLambda && !this.getParent().isInliningLambda;
    }

    public InlineCallSiteInfo getCallSiteInfo() {
        assert (this.parent != null) : "At least root context should return proper value";
        return this.parent.getCallSiteInfo();
    }
}

