/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

class HgCommandProcessHandler
extends OSProcessHandler {
    private final boolean myBinary;
    private final ByteArrayOutputStream myBinaryOutput;

    HgCommandProcessHandler(@NotNull GeneralCommandLine commandLine, boolean binary) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myBinary = binary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(@NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (sleepingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sleepingPolicy", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "createOutputDataReader"));
        }
        MyBinaryOutputReader myBinaryOutputReader = this.myBinary ? new MyBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy) : super.createOutputDataReader(sleepingPolicy);
        if (myBinaryOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "createOutputDataReader"));
        }
        return myBinaryOutputReader;
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        ByteArrayOutputStream byteArrayOutputStream = this.myBinaryOutput;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "getBinaryOutput"));
        }
        return byteArrayOutputStream;
    }

    private class MyBinaryOutputReader
    extends BinaryOutputReader {
        private MyBinaryOutputReader(@NotNull InputStream stream, BaseDataReader.SleepingPolicy simple) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "<init>"));
            }
            if (simple == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simple", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "<init>"));
            }
            super(stream, simple);
            this.start(HgCommandProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(@NotNull byte[] data, int size) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "onBinaryAvailable"));
            }
            HgCommandProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "executeOnPooledThread"));
            }
            Future future = HgCommandProcessHandler.this.executeOnPooledThread(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "executeOnPooledThread"));
            }
            return future;
        }
    }
}

