/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.ui.HgSetExecutablePathPanel;
import org.zmlx.hg4idea.util.HgVersion;

public class HgConfigurationProjectPanel {
    @NotNull
    private final HgProjectSettings myProjectSettings;
    private JPanel myMainPanel;
    private JCheckBox myCheckIncomingOutgoingCbx;
    private JCheckBox myIgnoredWhitespacesInAnnotationsCbx;
    private TextFieldWithBrowseButton myPathSelector;
    private JButton myTestButton;
    private JBCheckBox mySyncControl;
    private final HgVcs myVcs;

    public HgConfigurationProjectPanel(@NotNull HgProjectSettings projectSettings, @NotNull Project project) {
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "org/zmlx/hg4idea/ui/HgConfigurationProjectPanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/ui/HgConfigurationProjectPanel", "<init>"));
        }
        this.myProjectSettings = projectSettings;
        this.$$$setupUI$$$();
        this.myVcs = HgVcs.getInstance(project);
        this.loadSettings();
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgVersion version;
                String executable = HgConfigurationProjectPanel.this.getCurrentPath();
                try {
                    version = HgVersion.identifyVersion(executable);
                }
                catch (Exception exception) {
                    Messages.showErrorDialog((Component)HgConfigurationProjectPanel.this.myMainPanel, (String)exception.getMessage(), (String)HgVcsMessages.message("hg4idea.run.failed.title", new Object[0]));
                    return;
                }
                Messages.showInfoMessage((Component)HgConfigurationProjectPanel.this.myMainPanel, (String)String.format("Mercurial version is %s", version.toString()), (String)HgVcsMessages.message("hg4idea.run.success.title", new Object[0]));
            }
        });
        if (!project.isDefault()) {
            HgRepositoryManager repositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
            this.mySyncControl.setVisible(repositoryManager != null && repositoryManager.moreThanOneRoot());
        } else {
            this.mySyncControl.setVisible(true);
        }
        this.mySyncControl.setToolTipText(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Mercurial"}));
    }

    public boolean isModified() {
        boolean executableModified;
        boolean bl = executableModified = !this.getCurrentPath().equals(this.myProjectSettings.getHgExecutable());
        return executableModified || this.myCheckIncomingOutgoingCbx.isSelected() != this.myProjectSettings.isCheckIncomingOutgoing() || this.myProjectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || this.myIgnoredWhitespacesInAnnotationsCbx.isSelected() != this.myProjectSettings.isWhitespacesIgnoredInAnnotations();
    }

    public void saveSettings() {
        this.myProjectSettings.setCheckIncomingOutgoing(this.myCheckIncomingOutgoingCbx.isSelected());
        this.myProjectSettings.setIgnoreWhitespacesInAnnotations(this.myIgnoredWhitespacesInAnnotationsCbx.isSelected());
        this.myProjectSettings.setHgExecutable(this.getCurrentPath());
        this.myProjectSettings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        this.myVcs.checkVersion();
    }

    private String getCurrentPath() {
        return this.myPathSelector.getText().trim();
    }

    public void loadSettings() {
        this.myCheckIncomingOutgoingCbx.setSelected(this.myProjectSettings.isCheckIncomingOutgoing());
        this.myIgnoredWhitespacesInAnnotationsCbx.setSelected(this.myProjectSettings.isWhitespacesIgnoredInAnnotations());
        this.myPathSelector.setText(this.myProjectSettings.getGlobalSettings().getHgExecutable());
        this.mySyncControl.setSelected(this.myProjectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
    }

    public JPanel getPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myPathSelector = new HgSetExecutablePathPanel(this.myProjectSettings);
    }

    @NotNull
    public HgProjectSettings getProjectSettings() {
        HgProjectSettings hgProjectSettings = this.myProjectSettings;
        if (hgProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgConfigurationProjectPanel", "getProjectSettings"));
        }
        return hgProjectSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myPathSelector;
        textFieldWithBrowseButton.setEnabled(true);
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, new Dimension(100, -1), null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to hg executable");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setLabel(ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.configuration.test.label"));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.configuration.test"));
        jButton.setHorizontalAlignment(0);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 2, null, null, null));
        this.myCheckIncomingOutgoingCbx = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Check for incoming and outgoing changesets");
        jCheckBox2.setMnemonic('I');
        jCheckBox2.setDisplayedMnemonicIndex(10);
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoredWhitespacesInAnnotationsCbx = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/zmlx/hg4idea/HgVcsMessages").getString("hg4idea.configuration.ignore.whitespace.in.annotate"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySyncControl = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("sync.setting"));
        jBCheckBox.setToolTipText("");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

