/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.project.Project;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;

public class GradleConsoleFilterProvider
implements ConsoleFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider", "getDefaultFilters"));
        }
        Filter[] filterArray = new Filter[]{new GradleConsoleFilter(project), new RegexpFilter(project, "$FILE_PATH$:$LINE$"){

            public Filter.Result applyFilter(String line, int entireLength) {
                Filter.Result result = super.applyFilter(line, entireLength);
                if (result == null) {
                    return null;
                }
                Pattern pattern = this.getPattern();
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) {
                    return result;
                }
                int lineStart = entireLength - line.length();
                int start = lineStart + matcher.start();
                int end = lineStart + matcher.end();
                return new Filter.Result(start, end, result.getFirstHyperlinkInfo());
            }
        }};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider", "getDefaultFilters"));
        }
        return filterArray;
    }
}

