/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DeviceChooserListener;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchUtils;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceChooser
implements Disposable,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String[] COLUMN_TITLES = new String[]{"Device", "State", "Compatible", "Serial Number"};
    private static final int DEVICE_NAME_COLUMN_INDEX = 0;
    private static final int DEVICE_STATE_COLUMN_INDEX = 1;
    private static final int COMPATIBILITY_COLUMN_INDEX = 2;
    private static final int SERIAL_COLUMN_INDEX = 3;
    public static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    private final List<DeviceChooserListener> myListeners;
    private final MergingUpdateQueue myUpdateQueue;
    private volatile boolean myProcessSelectionFlag;
    private final JComponent myPanel;
    private final JBTable myDeviceTable;
    private final Predicate<IDevice> myFilter;
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;
    private int[] mySelectedRows;
    private final AtomicBoolean myDevicesDetected;

    public DeviceChooser(boolean multipleSelection, final @NotNull Action okAction, @NotNull AndroidFacet facet, @NotNull IAndroidTarget projectTarget, @Nullable Predicate<IDevice> filter) {
        if (okAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okAction", "com/android/tools/idea/run/DeviceChooser", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/DeviceChooser", "<init>"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTarget", "com/android/tools/idea/run/DeviceChooser", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProcessSelectionFlag = true;
        this.myDevicesDetected = new AtomicBoolean();
        this.myFilter = filter;
        this.myMinSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        this.myProjectTarget = projectTarget;
        this.myRequiredHardwareFeatures = LaunchUtils.isWatchFeatureRequired(facet) ? EnumSet.of(IDevice.HardwareFeature.WATCH) : EnumSet.noneOf(IDevice.HardwareFeature.class);
        this.myDeviceTable = new JBTable();
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)this.myDeviceTable);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)220));
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(EMPTY_DEVICE_ARRAY));
        this.myDeviceTable.setSelectionMode(multipleSelection ? 2 : 0);
        this.myDeviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeviceChooser.this.myProcessSelectionFlag) {
                    DeviceChooser.this.fireSelectedDevicesChanged();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (DeviceChooser.this.myDeviceTable.isEnabled() && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myDeviceTable);
        this.myDeviceTable.setDefaultRenderer(LaunchCompatibility.class, (TableCellRenderer)((Object)new LaunchCompatibilityRenderer()));
        this.myDeviceTable.setDefaultRenderer(IDevice.class, (TableCellRenderer)((Object)new DeviceRenderer.DeviceNameRenderer(facet.getAvdManagerSilently())));
        this.myDeviceTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.myDeviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int i;
                if (e.getButton() == 3 && (i = DeviceChooser.this.myDeviceTable.rowAtPoint(e.getPoint())) >= 0) {
                    Object serial = DeviceChooser.this.myDeviceTable.getValueAt(i, 3);
                    final String serialString = serial.toString();
                    JBPopupMenu popupMenu = new JBPopupMenu();
                    AbstractAction action = new AbstractAction("Copy Serial Number"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(serialString));
                        }
                    };
                    popupMenu.add((Action)action);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
                super.mouseReleased(e);
            }
        });
        DeviceChooser.setColumnWidth(this.myDeviceTable, 0, "Samsung Galaxy Nexus Android 4.1 (API 17)");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 1, "offline");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 2, "Compatible");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 3, "123456");
        this.myDeviceTable.setAutoCreateColumnsFromModel(false);
        this.myDeviceTable.setAutoCreateRowSorter(true);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    private static void setColumnWidth(JBTable deviceTable, int columnIndex, String sampleText) {
        int width = DeviceChooser.getWidth(deviceTable, sampleText);
        deviceTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private static int getWidth(JBTable deviceTable, String sampleText) {
        FontMetrics metrics = deviceTable.getFontMetrics(deviceTable.getFont());
        return metrics.stringWidth(sampleText);
    }

    public void init(@Nullable String[] selectedSerials) {
        this.updateTable();
        if (selectedSerials != null) {
            this.resetSelection(selectedSerials);
        }
    }

    private void resetSelection(@NotNull String[] selectedSerials) {
        if (selectedSerials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSerials", "com/android/tools/idea/run/DeviceChooser", "resetSelection"));
        }
        MyDeviceTableModel model = (MyDeviceTableModel)this.myDeviceTable.getModel();
        HashSet selectedSerialsSet = new HashSet();
        Collections.addAll(selectedSerialsSet, selectedSerials);
        IDevice[] myDevices = model.myDevices;
        ListSelectionModel selectionModel = this.myDeviceTable.getSelectionModel();
        boolean cleared = false;
        int n = myDevices.length;
        for (int i = 0; i < n; ++i) {
            String serialNumber = myDevices[i].getSerialNumber();
            if (!selectedSerialsSet.contains(serialNumber)) continue;
            if (!cleared) {
                selectionModel.clearSelection();
                cleared = true;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }

    private void updateTable() {
        final IDevice[] devices = this.getFilteredDevices();
        if (devices.length > 1) {
            Arrays.sort(devices, new Comparator<IDevice>(){

                @Override
                public int compare(IDevice device1, IDevice device2) {
                    int apiLevel1 = this.safeGetApiLevel(device1);
                    int apiLevel2 = this.safeGetApiLevel(device2);
                    return apiLevel2 - apiLevel1;
                }

                private int safeGetApiLevel(IDevice device) {
                    try {
                        String s = device.getProperty("ro.build.version.sdk");
                        return StringUtil.isNotEmpty((String)s) ? Integer.parseInt(s) : 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DeviceChooser.this.myDevicesDetected.set(devices.length > 0);
                DeviceChooser.this.refreshTable(devices);
            }
        });
    }

    private void refreshTable(IDevice[] devices) {
        Object[] selectedDevices = this.getSelectedDevices(false);
        TIntArrayList selectedRows = new TIntArrayList();
        for (int i = 0; i < devices.length; ++i) {
            if (ArrayUtil.indexOf((Object[])selectedDevices, (Object)devices[i]) < 0) continue;
            selectedRows.add(i);
        }
        this.myProcessSelectionFlag = false;
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(devices));
        if (selectedRows.size() == 0 && devices.length > 0) {
            this.myDeviceTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        for (int selectedRow : selectedRows.toNativeArray()) {
            if (selectedRow >= devices.length) continue;
            this.myDeviceTable.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        this.fireSelectedDevicesChanged();
        this.myProcessSelectionFlag = true;
    }

    public boolean hasDevices() {
        return this.myDevicesDetected.get();
    }

    public JComponent getPreferredFocusComponent() {
        return this.myDeviceTable;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ValidationInfo doValidate() {
        String message;
        if (!this.myDeviceTable.isEnabled()) {
            return null;
        }
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        boolean hasIncompatible = false;
        boolean hasCompatible = false;
        for (int row : rows) {
            if (!this.isRowCompatible(row)) {
                hasIncompatible = true;
                continue;
            }
            hasCompatible = true;
        }
        if (!hasIncompatible) {
            return null;
        }
        if (hasCompatible) {
            message = "At least one of the selected devices is incompatible. Will only install on compatible devices.";
        } else {
            String devicesAre = rows.length > 1 ? "devices are" : "device is";
            message = "The selected " + devicesAre + " incompatible.";
        }
        return new ValidationInfo(message);
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        IDevice[] iDeviceArray = this.getSelectedDevices(true);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceChooser", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @NotNull
    private IDevice[] getSelectedDevices(boolean onlyCompatible) {
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        block0: for (int row : rows) {
            IDevice[] devices;
            if (row < 0 || onlyCompatible && !this.isRowCompatible(row)) continue;
            Object serial = this.myDeviceTable.getValueAt(row, 3);
            for (IDevice device : devices = this.getFilteredDevices()) {
                if (!device.getSerialNumber().equals(serial.toString())) continue;
                result.add(device);
                continue block0;
            }
        }
        IDevice[] iDeviceArray = result.toArray(new IDevice[result.size()]);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceChooser", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @NotNull
    private IDevice[] getFilteredDevices() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            if (EMPTY_DEVICE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceChooser", "getFilteredDevices"));
            }
            return EMPTY_DEVICE_ARRAY;
        }
        ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            if (this.myFilter != null && !this.myFilter.apply((Object)device)) continue;
            filteredDevices.add(device);
        }
        IDevice[] iDeviceArray = filteredDevices.toArray(new IDevice[filteredDevices.size()]);
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceChooser", "getFilteredDevices"));
        }
        return iDeviceArray;
    }

    private boolean isRowCompatible(int row) {
        Object compatibility = this.myDeviceTable.getValueAt(row, 2);
        return compatibility instanceof LaunchCompatibility && ((LaunchCompatibility)compatibility).isCompatible() != ThreeState.NO;
    }

    public void finish() {
        this.mySelectedRows = this.myDeviceTable.getSelectedRows();
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void setEnabled(boolean enabled) {
        this.myDeviceTable.setEnabled(enabled);
    }

    @NotNull
    private static String getDeviceState(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceChooser", "getDeviceState"));
        }
        IDevice.DeviceState state = device.getState();
        String string = state != null ? StringUtil.capitalize((String)state.name().toLowerCase()) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceChooser", "getDeviceState"));
        }
        return string;
    }

    private void fireSelectedDevicesChanged() {
        for (DeviceChooserListener listener : this.myListeners) {
            listener.selectedDevicesChanged();
        }
    }

    public void addListener(@NotNull DeviceChooserListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/DeviceChooser", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(IDevice device) {
        this.postUpdate();
    }

    public void deviceDisconnected(IDevice device) {
        this.postUpdate();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.postUpdate();
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateTable"){

            public void run() {
                DeviceChooser.this.updateTable();
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private static class LaunchCompatibilityRenderer
    extends ColoredTableCellRenderer {
        private LaunchCompatibilityRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof LaunchCompatibility)) {
                return;
            }
            LaunchCompatibility compatibility = (LaunchCompatibility)value;
            ThreeState compatible = compatibility.isCompatible();
            if (compatible == ThreeState.YES) {
                this.append("Yes");
            } else {
                if (compatible == ThreeState.NO) {
                    this.append("No", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append("Maybe");
                }
                String reason = compatibility.getReason();
                if (reason != null) {
                    this.append(", ");
                    this.append(reason);
                }
            }
        }
    }

    private class MyDeviceTableModel
    extends AbstractTableModel {
        private final IDevice[] myDevices;

        public MyDeviceTableModel(IDevice[] devices) {
            this.myDevices = devices;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_TITLES[column];
        }

        @Override
        public int getRowCount() {
            return this.myDevices.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.myDevices.length) {
                return null;
            }
            IDevice device = this.myDevices[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return device;
                }
                case 3: {
                    return device.getSerialNumber();
                }
                case 1: {
                    return DeviceChooser.getDeviceState(device);
                }
                case 2: {
                    return LaunchCompatibility.canRunOnDevice(DeviceChooser.this.myMinSdkVersion, DeviceChooser.this.myProjectTarget, DeviceChooser.this.myRequiredHardwareFeatures, new ConnectedAndroidDevice(device, null), null);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return LaunchCompatibility.class;
            }
            if (columnIndex == 0) {
                return IDevice.class;
            }
            return String.class;
        }
    }
}

