/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagNameProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidLayoutXmlTagNameProvider
implements XmlTagNameProvider {
    private static final List<String> NAMESPACES = Collections.singletonList("");

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidLayoutXmlTagNameProvider", "addTagNameVariants"));
        }
        PsiFile file = tag.getContainingFile();
        if (!(file instanceof XmlFile) || !LayoutDomFileDescription.isLayoutFile((XmlFile)file)) {
            return;
        }
        XmlExtension xmlExtension = XmlExtension.getExtension((PsiFile)file);
        List variants = TagNameVariantCollector.getTagDescriptors((XmlTag)tag, NAMESPACES, null);
        HashSet<String> addedNames = new HashSet<String>();
        for (XmlElementDescriptor descriptor : variants) {
            String simpleName;
            String qualifiedName = descriptor.getName((PsiElement)tag);
            if (!addedNames.add(qualifiedName) || (simpleName = AndroidUtils.getUnqualifiedName(qualifiedName)) == null) continue;
            PsiElement declaration = descriptor.getDeclaration();
            LookupElementBuilder lookupElement = declaration == null ? LookupElementBuilder.create((String)qualifiedName) : LookupElementBuilder.create((Object)declaration, (String)qualifiedName);
            lookupElement = lookupElement.withLookupString(simpleName);
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)0.5));
        }
    }
}

