/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.javacvsImpl.io.ReadThread;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.openapi.application.ApplicationManager;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;

public class InputStreamWrapper
extends InputStream {
    private final ReadThread myReadThread;
    private final ReadWriteStatistics myStatistics;

    public InputStreamWrapper(InputStream original, ICvsCommandStopper cvsCommandStopper, ReadWriteStatistics statistics) {
        this.myReadThread = new ReadThread(original, cvsCommandStopper);
        this.myReadThread.prepareForWait();
        this.startThread(this.myReadThread);
        this.myReadThread.waitForStart();
        this.myStatistics = statistics;
    }

    protected void startThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    @Override
    public int read() throws IOException {
        this.myStatistics.read(1L);
        return this.myReadThread.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.myReadThread.read(b, off, len);
        this.myStatistics.read(result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.myReadThread.skip(n);
        this.myStatistics.read(result);
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.myReadThread.available();
    }

    @Override
    public void close() throws IOException {
        this.myReadThread.close();
    }
}

