/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class KotlinAndroidGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    public static final String NAME = "android-gradle";
    private static final String APPLY_KOTLIN_ANDROID = "apply plugin: 'kotlin-android'";

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JvmPlatform jvmPlatform = JvmPlatform.INSTANCE;
        if (jvmPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "getTargetPlatform"));
        }
        return jvmPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("Android with Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "getPresentableText"));
        }
        return "Android with Gradle";
    }

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "isApplicable"));
        }
        return KotlinPluginUtil.isAndroidGradleModule(module);
    }

    @Override
    protected String getApplyPluginDirective() {
        return APPLY_KOTLIN_ANDROID;
    }

    @Override
    protected void addSourceSetsBlock(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "addSourceSetsBlock"));
        }
        GrClosableBlock androidBlock = KotlinAndroidGradleModuleConfigurator.getAndroidBlock(file);
        KotlinAndroidGradleModuleConfigurator.addLastExpressionInBlockIfNeeded("main.java.srcDirs += 'src/main/kotlin'\n", KotlinAndroidGradleModuleConfigurator.getSourceSetsBlock((GrStatementOwner)androidBlock));
    }

    @NotNull
    private static GrClosableBlock getAndroidBlock(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "getAndroidBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinAndroidGradleModuleConfigurator.getBlockOrCreate((GrStatementOwner)file, "android");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinAndroidGradleModuleConfigurator", "getAndroidBlock"));
        }
        return grClosableBlock;
    }

    KotlinAndroidGradleModuleConfigurator() {
    }
}

