/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class JSLibraryStdPresentationProvider
extends LibraryPresentationProvider<LibraryVersionProperties> {
    public static JSLibraryStdPresentationProvider getInstance() {
        return (JSLibraryStdPresentationProvider)((Object)LibraryPresentationProvider.EP_NAME.findExtension(JSLibraryStdPresentationProvider.class));
    }

    protected JSLibraryStdPresentationProvider() {
        super(JSLibraryStdDescription.KOTLIN_JAVASCRIPT_KIND);
    }

    @Nullable
    public Icon getIcon() {
        return KotlinIcons.SMALL_LOGO_13;
    }

    @Nullable
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JSLibraryStdPresentationProvider", "detect"));
        }
        String version = JsLibraryStdDetectionUtil.getJsLibraryStdVersion(classesRoots);
        return version == null ? null : new LibraryVersionProperties(version);
    }

    public static boolean detectOld(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JSLibraryStdPresentationProvider", "detectOld"));
        }
        if (library.getFiles(OrderRootType.CLASSES).length == 0) {
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                if (!file.getName().equals("kotlin-jslib.jar")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static VirtualFile getJsStdLibJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JSLibraryStdPresentationProvider", "getJsStdLibJar"));
        }
        return LibraryUtils.getJarFile(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), "kotlin-jslib.jar");
    }

    @Nullable
    public static VirtualFile getJsStdLibSrcJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JSLibraryStdPresentationProvider", "getJsStdLibSrcJar"));
        }
        return LibraryUtils.getJarFile(Arrays.asList(library.getFiles(OrderRootType.SOURCES)), "kotlin-jslib-sources.jar");
    }
}

