/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableFromResolvedCall(@NotNull BindingContext bindingContext2, @Nullable KtElement callElement2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "extractVariableFromResolvedCall"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(callElement2, bindingContext2);
        if (resolvedCall == null || !(resolvedCall.getResultingDescriptor() instanceof VariableDescriptor)) {
            return null;
        }
        return (VariableDescriptor)resolvedCall.getResultingDescriptor();
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull BindingContext bindingContext2, @Nullable KtElement element2, boolean onlyReference) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "extractVariableDescriptorIfAny"));
        }
        DeclarationDescriptor descriptor2 = null;
        if (!onlyReference && (element2 instanceof KtVariableDeclaration || element2 instanceof KtParameter)) {
            descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
        } else if (element2 instanceof KtSimpleNameExpression) {
            descriptor2 = bindingContext2.get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)element2);
        } else if (element2 instanceof KtQualifiedExpression) {
            descriptor2 = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext2, ((KtQualifiedExpression)element2).getSelectorExpression(), onlyReference);
        }
        if (descriptor2 instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor2;
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement2, @NotNull SimpleFunctionDescriptor function2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (psiElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        trace.record(BindingContext.FUNCTION, psiElement2, function2);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext2, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V v = BindingContextUtils.getNotNull(bindingContext2, slice, key, "Value at " + slice + " must not be null for " + key);
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static KotlinType getTypeNotNull(@NotNull BindingContext bindingContext2, @NotNull KtExpression expression2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        KotlinType result2 = bindingContext2.getType(expression2);
        if (result2 == null) {
            throw new IllegalStateException("Type must be not null for " + expression2);
        }
        KotlinType kotlinType = result2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        return kotlinType;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext2, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (messageIfNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageIfNull", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V value2 = bindingContext2.get(slice, key);
        if (value2 == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v = value2;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull KtElement element2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        KtNamedDeclaration declaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, KtNamedDeclaration.class);
        if (declaration instanceof KtFunctionLiteral) {
            DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(context, declaration);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor2 != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        return declarationDescriptor;
    }

    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull KtElement element2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        KtFunction function2 = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, KtFunction.class);
        return (FunctionDescriptor)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull KtSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (declarationsByLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsByLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        ArrayList targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor2 : declarationsByLabel) {
            PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            assert (element2 != null) : "Label can only point to something in the same lexical scope";
            targets.add(element2);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static KotlinType updateRecordedType(@Nullable KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression2, type2);
        return type2;
    }

    @Nullable
    public static KotlinTypeInfo getRecordedTypeInfo(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (!context.get(BindingContext.PROCESSED, expression2).booleanValue()) {
            return null;
        }
        KotlinTypeInfo result2 = context.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        return result2 != null ? result2 : TypeInfoFactoryKt.noTypeInfo(DataFlowInfoFactory.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (expression2 instanceof KtCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, context);
            return resolvedCall instanceof VariableAsFunctionResolvedCall;
        }
        return expression2 instanceof KtReferenceExpression;
    }

    public static boolean isVarCapturedInClosure(BindingContext bindingContext2, DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof VariableDescriptor) || descriptor2 instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
        return bindingContext2.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null && variableDescriptor.isVar();
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement2 = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof KtFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        Pair pair2 = new Pair((Object)containingFunctionDescriptor, (Object)containingFunction);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getContainingFunctionSkipFunctionLiterals"));
        }
        return pair2;
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext2, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        return bindingContext2.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(final @NotNull BindingTrace trace, final @Nullable TraceEntryFilter filter2, boolean commitDiagnostics, @NotNull MutableSlicedMap map2, MutableDiagnosticsWithSuppression diagnostics) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        map2.forEach(new Function3<WritableSlice, Object, Object, Void>(){

            public Void invoke(WritableSlice slice, Object key, Object value2) {
                if (filter2 == null || filter2.accept(slice, null, key)) {
                    trace.record(slice, key, value2);
                }
                return null;
            }
        });
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics.getOwnDiagnostics()) {
            if (filter2 != null && !filter2.accept(null, diagnostic, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }
}

