/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0011\u0010\t\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000b\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\u000b\u001a\n\u0010\u000f\u001a\u00020\r*\u00020\u0010\u001a \u0010\u0011\u001a\u00020\r*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0014H\u0002\u001a\n\u0010\u0015\u001a\u00020\r*\u00020\u0012\u001a\n\u0010\u0016\u001a\u00020\r*\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_STATIC_ANNOTATION_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "argumentValue", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "findJvmSyntheticAnnotation", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasJvmStaticAnnotation", "", "hasJvmSyntheticAnnotation", "isInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isPlatformStaticIn", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "predicate", "Lkotlin/Function1;", "isPlatformStaticInCompanionObject", "isPlatformStaticInObjectOrClass", "frontend"})
public final class AnnotationUtilKt {
    private static final FqName JVM_STATIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");
    private static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    public static final boolean hasJvmStaticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().findAnnotation(JVM_STATIC_ANNOTATION_FQ_NAME) != null;
    }

    public static final boolean hasJvmSyntheticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationUtilKt.findJvmSyntheticAnnotation($receiver) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmSyntheticAnnotation(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
    }

    public static final boolean isPlatformStaticInObjectOrClass(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)isPlatformStaticInObjectOrClass.1.INSTANCE));
    }

    public static final boolean isPlatformStaticInCompanionObject(CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationUtilKt.isPlatformStaticIn($receiver, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)isPlatformStaticInCompanionObject.1.INSTANCE));
    }

    private static final boolean isPlatformStaticIn(CallableDescriptor $receiver, Function1<? super DeclarationDescriptor, Boolean> predicate) {
        boolean bl;
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"propertyDescriptor.containingDeclaration");
            bl = ((Boolean)predicate.invoke((Object)declarationDescriptor)).booleanValue() && (AnnotationUtilKt.hasJvmStaticAnnotation($receiver) || AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor));
        } else {
            DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
            bl = (Boolean)predicate.invoke((Object)declarationDescriptor) != false && AnnotationUtilKt.hasJvmStaticAnnotation($receiver);
        }
        return bl;
    }

    @Nullable
    public static final Object argumentValue(AnnotationDescriptor $receiver, @NotNull String parameterName) {
        ConstantValue constant;
        Object v0;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
            Iterable $receiver$iv = $receiver.getAllValueArguments().entrySet();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it.getKey()).getName().asString(), (Object)parameterName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Map.Entry entry = v0;
        ConstantValue constantValue = constant = entry != null ? (ConstantValue)entry.getValue() : null;
        if (constant == null || constant instanceof ErrorValue) {
            return null;
        }
        return constant.getValue();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnly(MemberDescriptor $receiver) {
        void var1_1;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof FunctionDescriptor)) {
            return false;
        }
        Object $receiver$iv = ((FunctionDescriptor)$receiver).getTypeParameters();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
            if (!it.isReified()) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (!((FunctionDescriptor)$receiver).getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME)) return false;
        $receiver$iv = InlineUtil.isInline($receiver);
        boolean $receiver2 = (Boolean)$receiver$iv;
        if (_Assertions.ENABLED) {
            if (!$receiver2) {
                String message$iv = "Function is not inline: " + $receiver;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if ((Boolean)var1_1 == false) return false;
        return true;
    }
}

