/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.util.Condition;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.VisibleGraph;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PermanentGraph<Id> {
    @NotNull
    public VisibleGraph<Id> createVisibleGraph(@NotNull SortType var1, @Nullable Set<Id> var2, @Nullable Set<Id> var3);

    @NotNull
    public List<GraphCommit<Id>> getAllCommits();

    @NotNull
    public List<Id> getChildren(@NotNull Id var1);

    @NotNull
    public Set<Id> getContainingBranches(@NotNull Id var1);

    @NotNull
    public Condition<Id> getContainedInBranchCondition(@NotNull Collection<Id> var1);

    public static enum SortType {
        Normal("Off", "Sort commits topologically and by date"),
        Bek("Standard", "In case of merge show incoming commits first (directly below merge commit)"),
        LinearBek("Linear", "In case of merge show incoming commits on top of main branch commits as if they were rebased");

        @NotNull
        private final String myPresentation;
        @NotNull
        private final String myDescription;

        private SortType(String presentation, String description) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/vcs/log/graph/PermanentGraph$SortType", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/vcs/log/graph/PermanentGraph$SortType", "<init>"));
            }
            this.myPresentation = presentation;
            this.myDescription = description;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/PermanentGraph$SortType", "getName"));
            }
            return string;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/PermanentGraph$SortType", "getDescription"));
            }
            return string;
        }
    }
}

