/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TaskManagerImpl
extends TaskManager
implements ProjectComponent,
PersistentStateComponent<Config>,
ChangeListDecorator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.impl.TaskManagerImpl");
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = new Comparator<Task>(){

        @Override
        public int compare(@NotNull Task o1, @NotNull Task o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/tasks/impl/TaskManagerImpl$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/tasks/impl/TaskManagerImpl$1", "compare"));
            }
            int i = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
            return i == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i;
        }
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = new Convertor<Task, String>(){

        public String convert(Task o) {
            return o.getId();
        }
    };
    static final String TASKS_NOTIFICATION_GROUP = "Task Group";
    private final Project myProject;
    private final WorkingContextManager myContextManager;
    private final Map<String, Task> myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, LocalTask> myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTask>(){

        @Override
        public LocalTask put(String key, LocalTask task) {
            LocalTask result = super.put(key, task);
            if (this.size() > ((TaskManagerImpl)TaskManagerImpl.this).myConfig.taskHistoryLength) {
                ArrayList list = new ArrayList(this.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<String, LocalTask>>(){

                    @Override
                    public int compare(@NotNull Map.Entry<String, LocalTask> o1, @NotNull Map.Entry<String, LocalTask> o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/tasks/impl/TaskManagerImpl$3$1", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/tasks/impl/TaskManagerImpl$3$1", "compare"));
                        }
                        return TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue());
                    }
                });
                for (Map.Entry oldest : list) {
                    if (((LocalTask)oldest.getValue()).isDefault()) continue;
                    this.remove(oldest.getKey());
                    break;
                }
            }
            return result;
        }
    });
    @NotNull
    private LocalTask myActiveTask = TaskManagerImpl.createDefaultTask();
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig = new Config();
    private final ChangeListAdapter myChangeListListener;
    private final ChangeListManager myChangeListManager;
    private final List<TaskRepository> myRepositories = new ArrayList<TaskRepository>();
    private final EventDispatcher<TaskListener> myDispatcher = EventDispatcher.create(TaskListener.class);
    private Set<TaskRepository> myBadRepositories = ContainerUtil.newConcurrentSet();

    public TaskManagerImpl(Project project, WorkingContextManager contextManager, ChangeListManager changeListManager) {
        this.myProject = project;
        this.myContextManager = contextManager;
        this.myChangeListManager = changeListManager;
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListRemoved(ChangeList list) {
                LocalTask task = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list);
                if (task != null) {
                    for (ChangeListInfo info : task.getChangeLists()) {
                        if (!Comparing.equal((String)info.id, (String)((LocalChangeList)list).getId())) continue;
                        info.id = "";
                    }
                }
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                final LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals((Object)associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskManagerImpl.this.activateTask((Task)associatedTask, true);
                        }
                    }, TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
    }

    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[this.myRepositories.size()]);
    }

    public <T extends TaskRepository> void setRepositories(List<T> repositories) {
        HashSet<TaskRepository> set = new HashSet<TaskRepository>(this.myRepositories);
        set.removeAll(repositories);
        this.myBadRepositories.removeAll(set);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
    }

    public void removeTask(LocalTask task) {
        if (task.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals((Object)task)) {
            this.activateTask((Task)this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task.getId());
        ((TaskListener)this.myDispatcher.getMulticaster()).taskRemoved(task);
        this.myContextManager.removeContext((Task)task);
    }

    public void addTaskListener(TaskListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addTaskListener(@NotNull TaskListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/tasks/impl/TaskManagerImpl", "addTaskListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/tasks/impl/TaskManagerImpl", "addTaskListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeTaskListener(TaskListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    public LocalTask getActiveTask() {
        LocalTask localTask = this.myActiveTask;
        if (localTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "getActiveTask"));
        }
        return localTask;
    }

    @Nullable
    public LocalTask findTask(String id) {
        return this.myTasks.get(id);
    }

    @NotNull
    public List<Task> getIssues(@Nullable String query) {
        List<Task> list = this.getIssues(query, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "getIssues"));
        }
        return list;
    }

    public List<Task> getIssues(@Nullable String query, boolean forceRequest) {
        return this.getIssues(query, 0, 50, true, (ProgressIndicator)new EmptyProgressIndicator(), forceRequest);
    }

    public List<Task> getIssues(@Nullable String query, int offset, int limit, final boolean withClosed, @NotNull ProgressIndicator indicator, boolean forceRequest) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl", "getIssues"));
        }
        List<Task> tasks = this.getIssuesFromRepositories(query, offset, limit, withClosed, forceRequest, indicator);
        if (tasks == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, (Condition)new Condition<Task>(){

            public boolean value(Task task) {
                return withClosed || !task.isClosed();
            }
        });
    }

    public List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    public List<Task> getCachedIssues(final boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), (Condition)new Condition<Task>(){

            public boolean value(Task task) {
                return withClosed || !task.isClosed();
            }
        });
    }

    @Nullable
    public Task updateIssue(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/impl/TaskManagerImpl", "updateIssue"));
        }
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id) == null) continue;
            try {
                LOG.info("Searching for task '" + id + "' in " + repository);
                Task issue = repository.findTask(id);
                if (issue == null) continue;
                LocalTask localTask = this.findTask(id);
                if (localTask != null) {
                    localTask.updateFromIssue(issue);
                    return localTask;
                }
                return issue;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    public List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalTask> getLocalTasks(final boolean withClosed) {
        Map<String, LocalTask> map = this.myTasks;
        synchronized (map) {
            return ContainerUtil.filter(this.myTasks.values(), (Condition)new Condition<LocalTask>(){

                public boolean value(LocalTask task) {
                    return withClosed || !TaskManagerImpl.this.isLocallyClosed(task);
                }
            });
        }
    }

    public LocalTask addTask(Task issue) {
        LocalTaskImpl task = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task);
        return task;
    }

    public LocalTaskImpl createLocalTask(@NotNull String summary) {
        if (summary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "summary", "com/intellij/tasks/impl/TaskManagerImpl", "createLocalTask"));
        }
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary);
    }

    private static LocalTaskImpl createTask(@NotNull String id, @NotNull String summary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/impl/TaskManagerImpl", "createTask"));
        }
        if (summary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "summary", "com/intellij/tasks/impl/TaskManagerImpl", "createTask"));
        }
        LocalTaskImpl task = new LocalTaskImpl(id, summary);
        Date date = new Date();
        task.setCreated(date);
        task.setUpdated(date);
        return task;
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/tasks/impl/TaskManagerImpl", "activateTask"));
        }
        LocalTask activeTask = this.getActiveTask();
        if (origin.equals((Object)activeTask)) {
            return activeTask;
        }
        this.saveActiveTask();
        if (clearContext) {
            this.myContextManager.clearContext();
        }
        this.myContextManager.restoreContext(origin);
        LocalTask task = this.doActivate(origin, true);
        return this.restoreVcsContext(task);
    }

    private LocalTask restoreVcsContext(LocalTask task) {
        if (!this.isVcsEnabled()) {
            return task;
        }
        List changeLists = task.getChangeLists();
        if (!changeLists.isEmpty()) {
            ChangeListInfo info = (ChangeListInfo)changeLists.get(0);
            LocalChangeList changeList = this.myChangeListManager.getChangeList(info.id);
            if (changeList == null) {
                changeList = this.myChangeListManager.addChangeList(info.name, info.comment);
                info.id = changeList.getId();
            }
            this.myChangeListManager.setDefaultChangeList(changeList);
        }
        List branches = task.getBranches(false);
        MultiMap multiMap = new MultiMap();
        for (BranchInfo branch : branches) {
            multiMap.putValue((Object)branch.repository, (Object)branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get((Object)repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                BranchInfo info = (BranchInfo)iterator.next();
                if (existing.contains(info)) continue;
                iterator.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info = TaskManagerImpl.fromBranches(new ArrayList<BranchInfo>(multiMap.values()));
        this.switchBranch(info);
        return task;
    }

    private List<BranchInfo> getAllBranches(final String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info : tasks = handler.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter((Collection)BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)info, (boolean)false), (Condition)new Condition<BranchInfo>(){

                    public boolean value(BranchInfo info) {
                        return Comparing.equal((String)info.repository, (String)repo);
                    }
                }));
            }
        }
        return infos;
    }

    private void switchBranch(VcsTaskHandler.TaskInfo info) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler.switchToTask(info, null);
        }
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap map = new MultiMap();
        for (BranchInfo branch : branches) {
            map.putValue((Object)branch.name, (Object)branch.repository);
        }
        Map.Entry next = (Map.Entry)map.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), (Collection)next.getValue());
    }

    public void createBranch(LocalTask task, LocalTask previousActive, String name) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] info = handler.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info, false);
            }
            TaskManagerImpl.addBranches(task, info, true);
            TaskManagerImpl.addBranches(task, new VcsTaskHandler.TaskInfo[]{handler.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task.getBranches(false));
        for (VcsTaskHandler handler : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler.closeTask(feature, original);
        }
    }

    private static void addBranches(LocalTask task, VcsTaskHandler.TaskInfo[] info, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info) {
            List branchInfos = BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)taskInfo, (boolean)original);
            for (BranchInfo branchInfo : branchInfos) {
                task.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        this.myContextManager.saveContext((Task)this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTask oldActiveTask;
        LocalTaskImpl task;
        LocalTaskImpl localTaskImpl = task = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            task.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task.setActive(true);
        this.addTask(task);
        if (task.isIssue()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)new Task.Backgroundable(TaskManagerImpl.this.myProject, "Updating " + task.getId()){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$9$1", "run"));
                            }
                            TaskManagerImpl.this.updateIssue(task.getId());
                        }
                    });
                }
            });
        }
        boolean isChanged = !task.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task;
        if (isChanged) {
            ((TaskListener)this.myDispatcher.getMulticaster()).taskDeactivated(oldActiveTask);
            ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated((LocalTask)task);
        }
        return task;
    }

    private void addTask(LocalTaskImpl task) {
        this.myTasks.put(task.getId(), task);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskAdded((LocalTask)task);
    }

    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task = new TestConnectionTask("Test connection"){

            /*
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"indicator", "com/intellij/tasks/impl/TaskManagerImpl$10", "run"}));
                }
                indicator.setText("Connecting to " + repository.getUrl() + "...");
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = (Exception)future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.access$200().info((Throwable)e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }
        };
        ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)task);
        Exception e = task.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog((Project)this.myProject, (String)"Connection is successful", (String)"Connection", (Icon)Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = "Unknown host: " + message;
            }
            if (message == null) {
                LOG.error((Throwable)e);
                message = "Unknown error";
            }
            Messages.showErrorDialog((Project)this.myProject, (String)StringUtil.capitalize((String)message), (String)"Error");
        }
        return e == null;
    }

    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), (Function)new Function<Task, LocalTaskImpl>(){

            public LocalTaskImpl fun(Task task) {
                return new LocalTaskImpl(task);
            }
        });
        this.myConfig.servers = XmlSerializer.serialize((Object)this.getAllRepositories());
        Config config = this.myConfig;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "getState"));
        }
        return config;
    }

    public void loadState(Config config) {
        XmlSerializerUtil.copyBean((Object)config, (Object)this.myConfig);
        this.myTasks.clear();
        for (LocalTaskImpl task : config.tasks) {
            this.addTask(task);
        }
        this.myRepositories.clear();
        Element element = config.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element);
        this.myRepositories.addAll(repositories);
    }

    public static ArrayList<TaskRepository> loadRepositories(Element element) {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Object o : element.getChildren()) {
                if (!((Element)o).getName().equals(repositoryType.getName())) continue;
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize((Element)((Element)o), (Class)repositoryType.getRepositoryClass());
                    if (repository == null) continue;
                    repository.setRepositoryType(repositoryType);
                    repositories.add(repository);
                }
                catch (XmlSerializationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return repositories;
    }

    public void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        this.myContextManager.pack(200, 50);
        LocalTask defaultTask = this.findTask("Default");
        LocalChangeList defaultList = this.myChangeListManager.findChangeList(LocalChangeList.DEFAULT_NAME);
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!defaultTask.getChangeLists().contains(listInfo)) {
                defaultTask.addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator iterator = localTask.getChangeLists().iterator();
            while (iterator.hasNext()) {
                ChangeListInfo changeListInfo = (ChangeListInfo)iterator.next();
                if (this.myChangeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator.remove();
            }
        }
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return (TaskProjectConfiguration)ServiceManager.getService((Project)this.myProject, TaskProjectConfiguration.class);
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("Task Manager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "getComponentName"));
        }
        return "Task Manager";
    }

    public void initComponent() {
        LocalTask defaultTask;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCacheRefreshTimer = UIUtil.createNamedTimer((String)"TaskManager refresh", (int)(this.myConfig.updateInterval * 60 * 1000), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/impl/TaskManagerImpl$12", "actionPerformed"));
                    }
                    if (((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                        LOG.info("Updating issues cache (every " + ((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateInterval + " min)");
                        TaskManagerImpl.this.updateIssues(null);
                    }
                }
            });
            this.myCacheRefreshTimer.setInitialDelay(0);
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    TaskManagerImpl.this.myCacheRefreshTimer.start();
                }
            });
        }
        if ((defaultTask = this.findTask("Default")) == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask((Task)defaultTask);
        }
        LocalTask activeTask = null;
        List<LocalTask> tasks = this.getLocalTasks();
        Collections.sort(tasks, TASK_UPDATE_COMPARATOR);
        for (LocalTask task : tasks) {
            if (activeTask == null) {
                if (!task.isActive()) continue;
                activeTask = task;
                continue;
            }
            task.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate((Task)this.myActiveTask, false);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(this.myActiveTask);
    }

    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task = new LocalTaskImpl("Default", "Default task");
        Date date = new Date();
        task.setCreated(date);
        task.setUpdated(date);
        return task;
    }

    public void disposeComponent() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    public void updateIssues(final @Nullable Runnable onComplete) {
        TaskRepository first = (TaskRepository)ContainerUtil.find((Object[])this.getAllRepositories(), (Condition)new Condition<TaskRepository>(){

            public boolean value(TaskRepository repository) {
                return repository.isConfigured();
            }
        });
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    TaskManagerImpl.this.doUpdate(onComplete);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, (ProgressIndicator)new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map = this.myIssueCache;
            synchronized (map) {
                this.myIssueCache.clear();
                for (Task task : issues) {
                    this.myIssueCache.put(task.getId(), task);
                }
            }
            map = this.myTasks;
            synchronized (map) {
                for (Map.Entry entry : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry.getKey());
                    if (issue == null) continue;
                    ((LocalTask)entry.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelled", "com/intellij/tasks/impl/TaskManagerImpl", "getIssuesFromRepositories"));
        }
        ArrayList issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start = System.currentTimeMillis();
                Object[] tasks = repository.getIssues(request, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start;
                LOG.info(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList(tasks.length);
                }
                if (!repository.isSupported(16) && request != null) {
                    List<Task> filteredTasks = TaskSearchSupport.filterTasks(request, ContainerUtil.list((Object[])tasks));
                    ContainerUtil.addAll(issues, filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, (Object[])tasks);
            }
            catch (ProcessCanceledException start) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException) {
                    LOG.warn("Socket timeout from " + repository);
                } else {
                    LOG.warn("Cannot connect to " + repository, (Throwable)e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                this.notifyAboutConnectionFailure(repository, reason);
            }
        }
        return issues;
    }

    private void notifyAboutConnectionFailure(final TaskRepository repository, String details) {
        Notifications.Bus.register((String)TASKS_NOTIFICATION_GROUP, (NotificationDisplayType)NotificationDisplayType.BALLOON);
        String content = "<p><a href=\"\">Configure server...</a></p>";
        if (!StringUtil.isEmpty((String)details)) {
            content = "<p>" + details + "</p>" + content;
        }
        Notifications.Bus.notify((Notification)new Notification(TASKS_NOTIFICATION_GROUP, "Cannot connect to " + repository.getUrl(), content, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/tasks/impl/TaskManagerImpl$16", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tasks/impl/TaskManagerImpl$16", "hyperlinkUpdate"));
                }
                TaskRepositoriesConfigurable configurable = new TaskRepositoriesConfigurable(TaskManagerImpl.this.myProject);
                ShowSettingsUtil.getInstance().editConfigurable(TaskManagerImpl.this.myProject, (Configurable)configurable);
                if (!ArrayUtil.contains((Object)repository, (Object[])TaskManagerImpl.this.getAllRepositories())) {
                    notification.expire();
                }
            }
        }), (Project)this.myProject);
    }

    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length > 0;
    }

    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (localTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTask", "com/intellij/tasks/impl/TaskManagerImpl", "isLocallyClosed"));
        }
        if (this.isVcsEnabled()) {
            List lists = localTask.getChangeLists();
            if (lists.isEmpty()) {
                return true;
            }
            for (ChangeListInfo list : lists) {
                if (!StringUtil.isEmpty((String)list.id)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tasks/impl/TaskManagerImpl", "getAssociatedTask"));
        }
        for (LocalTask task : this.getLocalTasks()) {
            for (ChangeListInfo changeListInfo : task.getChangeLists()) {
                if (!changeListInfo.id.equals(list.getId())) continue;
                return task;
            }
        }
        return null;
    }

    public void trackContext(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/tasks/impl/TaskManagerImpl", "trackContext"));
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task = this.createLocalTask(changeListName);
        task.addChangelist(changeListInfo);
        this.addTask(task);
        if (changeList.isDefault()) {
            this.activateTask((Task)task, false);
        }
    }

    public void disassociateFromTask(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/tasks/impl/TaskManagerImpl", "disassociateFromTask"));
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        for (LocalTask localTask : this.getLocalTasks()) {
            if (!localTask.getChangeLists().contains(changeListInfo)) continue;
            localTask.removeChangelist(changeListInfo);
        }
    }

    public void decorateChangeList(@NotNull LocalChangeList changeList, @NotNull ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/tasks/impl/TaskManagerImpl", "decorateChangeList"));
        }
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/intellij/tasks/impl/TaskManagerImpl", "decorateChangeList"));
        }
        LocalTask task = this.getAssociatedTask(changeList);
        if (task != null && task.isIssue()) {
            cellRenderer.setIcon(task.getIcon());
        }
    }

    public void createChangeList(@NotNull LocalTask task, String name) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/impl/TaskManagerImpl", "createChangeList"));
        }
        String comment = TaskUtil.getChangeListComment((Task)task);
        this.createChangeList(task, name, comment);
    }

    private void createChangeList(LocalTask task, String name, @Nullable String comment) {
        LocalChangeList changeList = this.myChangeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = this.myChangeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            changeList.setComment(comment);
        }
        task.addChangelist(new ChangeListInfo(changeList));
        this.myChangeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task) {
        String name = task.isIssue() && this.myConfig.changelistNameFormat != null ? TaskUtil.formatTask(task, this.myConfig.changelistNameFormat) : task.getSummary();
        return StringUtil.shortenTextWithEllipsis((String)name, (int)100, (int)0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/impl/TaskManagerImpl", "suggestBranchName"));
        }
        String name = this.constructDefaultBranchName(task);
        if (task.isIssue()) {
            String string = name.replace(' ', '-');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "suggestBranchName"));
            }
            return string;
        }
        List words = StringUtil.getWordsIn((String)name);
        String[] strings = ArrayUtil.toStringArray((Collection)words);
        String string = StringUtil.join((String[])strings, (int)0, (int)Math.min(2, strings.length), (String)"-");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "suggestBranchName"));
        }
        return string;
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/impl/TaskManagerImpl", "constructDefaultBranchName"));
        }
        String string = task.isIssue() ? TaskUtil.formatTask(task, this.myConfig.branchNameFormat) : task.getSummary();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskManagerImpl", "constructDefaultBranchName"));
        }
        return string;
    }

    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    public void reconfigureRepositoryClients() {
        for (TaskRepository repository : this.myRepositories) {
            if (!(repository instanceof BaseRepositoryImpl)) continue;
            ((BaseRepositoryImpl)repository).reconfigureClient();
        }
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        public TestConnectionTask(String title) {
            super(TaskManagerImpl.this.myProject, title, true);
        }

        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        public int updateInterval = 20;
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "{id} {summary}";
        public String branchNameFormat = "{id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }
}

