/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.editorActions.wordSelection.DocTagSelectioner;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaDocCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaDocCompletionContributor");
    @NonNls
    private static final String VALUE_TAG = "value";
    @NonNls
    private static final String LINK_TAG = "link";

    public JavaDocCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaDocTokenType.DOC_TAG_NAME), new TagChooser());
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().inside(PsiDocComment.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$1", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                boolean isArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)position);
                PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocTag.class);
                boolean onlyConstants = !isArg && tag != null && tag.getName().equals(JavaDocCompletionContributor.VALUE_TAG);
                PsiReference ref = position.getContainingFile().findReferenceAt(parameters.getOffset());
                if (ref instanceof PsiJavaReference) {
                    result.stopHere();
                    for (LookupElement item : JavaDocCompletionContributor.this.completeJavadocReference(position, (PsiJavaReference)ref)) {
                        PsiField field;
                        Object o;
                        if (onlyConstants && (!((o = item.getObject()) instanceof PsiField) || !(field = (PsiField)o).hasModifierProperty("static") || field.getInitializer() == null || JavaConstantExpressionEvaluator.computeConstantExpression(field.getInitializer(), false) == null)) continue;
                        if (isArg) {
                            item = AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(item);
                        }
                        result.addElement(item);
                    }
                    JavaCompletionContributor.addAllClasses(parameters, result, new InheritorsHolder(result));
                }
                if (tag != null && "author".equals(tag.getName())) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)SystemProperties.getUserName()));
                }
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PsiDocTag.class).withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"throws", "exception"}))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$2", "addCompletions"));
                }
                PsiElement element = parameters.getPosition();
                HashSet<PsiClass> throwsSet = new HashSet<PsiClass>();
                PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)element, PsiMethod.class, (boolean)true);
                if (method != null) {
                    for (PsiClassType ref : method.getThrowsList().getReferencedTypes()) {
                        PsiClass exception = ref.resolve();
                        if (exception == null || !throwsSet.add(exception)) continue;
                        result.addElement(TailTypeDecorator.withTail(new JavaPsiClassReferenceElement(exception), TailType.HUMBLE_SPACE_BEFORE_WORD));
                    }
                }
            }
        });
    }

    @NotNull
    private List<LookupElement> completeJavadocReference(PsiElement position, PsiJavaReference ref) {
        JavaCompletionProcessor processor2 = new JavaCompletionProcessor(position, TrueFilter.INSTANCE, JavaCompletionProcessor.Options.CHECK_NOTHING, (Condition<String>)Conditions.alwaysTrue());
        ref.processVariants((PsiScopeProcessor)processor2);
        List list = ContainerUtil.map(processor2.getResults(), completionResult -> {
            LookupElement item = this.createReferenceLookupItem(completionResult.getElement());
            item.putUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR, (Object)Boolean.TRUE);
            return item;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "completeJavadocReference"));
        }
        return list;
    }

    private LookupElement createReferenceLookupItem(Object element) {
        if (element instanceof PsiMethod) {
            return new JavaMethodCallElement((PsiMethod)element){

                @Override
                public void handleInsert(InsertionContext context) {
                    new MethodSignatureInsertHandler().handleInsert(context, this);
                }
            };
        }
        if (element instanceof PsiClass) {
            JavaPsiClassReferenceElement classElement = new JavaPsiClassReferenceElement((PsiClass)element);
            classElement.setInsertHandler((InsertHandler)JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER);
            return classElement;
        }
        return LookupItemUtil.objectToLookupItem(element);
    }

    private static PsiParameter getDocTagParam(PsiElement tag) {
        PsiDocTagValue value;
        if (tag instanceof PsiDocTag && "param".equals(((PsiDocTag)tag).getName()) && (value = ((PsiDocTag)tag).getValueElement()) instanceof PsiDocParamRef) {
            PsiElement target;
            PsiReference psiReference = value.getReference();
            PsiElement psiElement = target = psiReference != null ? psiReference.resolve() : null;
            if (target instanceof PsiParameter) {
                return (PsiParameter)target;
            }
        }
        return null;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        if (PsiJavaPatterns.psiElement((IElementType)JavaDocTokenType.DOC_COMMENT_DATA).accepts((Object)position)) {
            PsiParameter param = JavaDocCompletionContributor.getDocTagParam(position.getParent());
            if (param != null) {
                JavaDocCompletionContributor.suggestSimilarParameterDescriptions(result, position, param);
            }
            this.suggestLinkWrappingVariants(parameters, result.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix(parameters)), position);
            if (!result.getPrefixMatcher().getPrefix().isEmpty()) {
                for (String keyword : (String[])ContainerUtil.ar((Object[])new String[]{"null", "true", "false"})) {
                    String tagText = "{@code " + keyword + "}";
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).withPresentableText(tagText).withInsertHandler((context, item) -> context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)tagText)));
                }
            }
            return;
        }
        super.fillCompletionVariants(parameters, result);
    }

    private void suggestLinkWrappingVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiElement position) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "suggestLinkWrappingVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "suggestLinkWrappingVariants"));
        }
        PrefixMatcher matcher = result.getPrefixMatcher();
        int prefixStart = parameters.getOffset() - matcher.getPrefix().length() - position.getTextRange().getStartOffset();
        if (prefixStart > 0 && position.getText().charAt(prefixStart - 1) == '#') {
            String mockCommentPrefix = "/** {@link ";
            String mockText = mockCommentPrefix + position.getText().substring(prefixStart - 1) + "}*/";
            PsiDocComment mockComment = JavaPsiFacade.getElementFactory((Project)position.getProject()).createDocCommentFromText(mockText, position);
            PsiJavaReference ref = (PsiJavaReference)mockComment.findReferenceAt(mockCommentPrefix.length() + 1);
            assert (ref != null) : mockText;
            for (LookupElement element : this.completeJavadocReference(ref.getElement(), ref)) {
                result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)element, JavaDocCompletionContributor.wrapIntoLinkTag((context, item) -> element.handleInsert(context))));
            }
        } else {
            InsertHandler<JavaPsiClassReferenceElement> handler2 = JavaDocCompletionContributor.wrapIntoLinkTag(JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER);
            AllClassesGetter.processJavaClasses(parameters, matcher, parameters.getInvocationCount() == 1, (Consumer<PsiClass>)((Consumer)psiClass -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "lambda$suggestLinkWrappingVariants$4"));
                }
                result.addElement((LookupElement)AllClassesGetter.createLookupItem(psiClass, handler2));
            }));
        }
    }

    @NotNull
    private static <T extends LookupElement> InsertHandler<T> wrapIntoLinkTag(InsertHandler<T> delegate) {
        InsertHandler insertHandler = (context, item) -> {
            Document document = context.getDocument();
            String link = "{@link ";
            int startOffset = context.getStartOffset();
            int sharpLength = document.getCharsSequence().charAt(startOffset - 1) == '#' ? 1 : 0;
            document.insertString(startOffset - sharpLength, (CharSequence)link);
            document.insertString(context.getTailOffset(), (CharSequence)"}");
            context.setTailOffset(context.getTailOffset() - 1);
            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + link.length() + sharpLength);
            context.commitDocument();
            delegate.handleInsert(context, item);
        };
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaDocCompletionContributor", "wrapIntoLinkTag"));
        }
        return insertHandler;
    }

    private static void suggestSimilarParameterDescriptions(CompletionResultSet result, PsiElement position, final PsiParameter param) {
        final HashSet descriptions = ContainerUtil.newHashSet();
        position.getContainingFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                PsiParameter param1 = JavaDocCompletionContributor.getDocTagParam(element);
                if (param1 != null && param1 != param && Comparing.equal((String)param1.getName(), (String)param.getName()) && Comparing.equal((Object)param1.getType(), (Object)param.getType())) {
                    String text = "";
                    for (PsiElement psiElement : ((PsiDocTag)element).getDataElements()) {
                        if (psiElement == ((PsiDocTag)element).getValueElement()) continue;
                        text = text + psiElement.getText();
                    }
                    if ((text = text.trim()).contains(" ")) {
                        descriptions.add(text);
                    }
                }
                super.visitElement(element);
            }
        });
        for (String description : descriptions) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)description).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    if (context.getCompletionChar() != '\t') {
                        return;
                    }
                    context.commitDocument();
                    PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiDocTag.class, (boolean)false);
                    if (docTag != null) {
                        Document document = context.getDocument();
                        int tagEnd = DocTagSelectioner.getDocTagRange(docTag, document.getCharsSequence(), 0).getEndOffset();
                        int tail = context.getTailOffset();
                        if (tail < tagEnd) {
                            document.deleteString(tail, tagEnd);
                        }
                    }
                }
            }));
        }
    }

    private static class MethodSignatureInsertHandler
    implements InsertHandler<JavaMethodCallElement> {
        private MethodSignatureInsertHandler() {
        }

        public void handleInsert(InsertionContext context, JavaMethodCallElement item) {
            PsiDocTagValue valueElement;
            int afterSharp;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
            Editor editor = context.getEditor();
            PsiMethod method = (PsiMethod)item.getObject();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            StringBuilder buffer = new StringBuilder();
            CharSequence chars = editor.getDocument().getCharsSequence();
            int endOffset = editor.getCaretModel().getOffset();
            Project project2 = context.getProject();
            int signatureOffset = afterSharp = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(endOffset - 1), (String)"#") + 1;
            PsiElement element = context.getFile().findElementAt(signatureOffset - 1);
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
            PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
            if (context.getCompletionChar() == '\t' && tag != null && (valueElement = tag.getValueElement()) != null) {
                endOffset = valueElement.getTextRange().getEndOffset();
                context.setTailOffset(endOffset);
            }
            editor.getDocument().deleteString(afterSharp, endOffset);
            editor.getCaretModel().moveToOffset(signatureOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            buffer.append(method.getName()).append("(");
            int afterParenth = afterSharp + buffer.length();
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = TypeConversionUtil.erasure((PsiType)parameters[i].getType());
                buffer.append(type.getCanonicalText());
                if (i >= parameters.length - 1) continue;
                buffer.append(",");
                if (!styleSettings.SPACE_AFTER_COMMA) continue;
                buffer.append(" ");
            }
            buffer.append(")");
            if (!(tag instanceof PsiInlineDocTag)) {
                buffer.append(" ");
            } else {
                int currentOffset = editor.getCaretModel().getOffset();
                if (chars.charAt(currentOffset) == '}') {
                    ++afterSharp;
                } else {
                    buffer.append("} ");
                }
            }
            String insertString = buffer.toString();
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertString);
            editor.getCaretModel().moveToOffset(afterSharp + buffer.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            MethodSignatureInsertHandler.shortenReferences(project2, editor, context, afterParenth);
        }

        private static void shortenReferences(Project project2, Editor editor, InsertionContext context, int offset) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiElement element = context.getFile().findElementAt(offset);
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class);
            if (!JavaDocUtil.isInsidePackageInfo(docComment)) {
                PsiDocTagValue tagValue = (PsiDocTagValue)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTagValue.class);
                if (tagValue != null) {
                    try {
                        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)tagValue);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            }
        }
    }

    private static class InlineInsertHandler
    implements InsertHandler<LookupElement> {
        private InlineInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            if (context.getCompletionChar() == '\t') {
                int currentOffset;
                Project project2 = context.getProject();
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                Editor editor = context.getEditor();
                CaretModel caretModel = editor.getCaretModel();
                int offset = caretModel.getOffset();
                PsiElement element = context.getFile().findElementAt(offset - 1);
                PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
                assert (tag != null);
                for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    PsiDocToken token;
                    if (!(child instanceof PsiDocToken) || (token = (PsiDocToken)child).getTokenType() != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                    return;
                }
                String name = tag.getName();
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (chars.charAt(currentOffset = caretModel.getOffset()) == '}') {
                    caretModel.moveToOffset(offset + 1);
                } else if (chars.charAt(currentOffset + 1) == '}' && chars.charAt(currentOffset) == ' ') {
                    caretModel.moveToOffset(offset + 2);
                } else if (name.equals(JavaDocCompletionContributor.LINK_TAG)) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" }");
                    caretModel.moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor.getSelectionModel().removeSelection();
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}");
                    caretModel.moveToOffset(offset + 1);
                }
            }
        }
    }

    private static class TagChooser
    extends CompletionProvider<CompletionParameters> {
        private TagChooser() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiJavaFile file2;
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$TagChooser", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JavaDocCompletionContributor$TagChooser", "addCompletions"));
            }
            ArrayList<String> ret = new ArrayList<String>();
            PsiElement position = parameters.getPosition();
            PsiDocComment comment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class);
            assert (comment != null);
            PsiElement parent = comment.getContext();
            if (parent instanceof PsiJavaFile && "package-info.java".equals((file2 = (PsiJavaFile)parent).getName())) {
                String string = file2.getPackageName();
                parent = JavaPsiFacade.getInstance((Project)position.getProject()).findPackage(string);
            }
            boolean isInline = position.getContext() instanceof PsiInlineDocTag;
            for (JavadocTagInfo info : JavadocManager.SERVICE.getInstance((Project)position.getProject()).getTagInfos(parent)) {
                String tagName = info.getName();
                if (tagName.equals("noinspection") || isInline != info.isInline()) continue;
                ret.add(tagName);
                TagChooser.addSpecialTags(ret, comment, tagName);
            }
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(position.getProject()).getInspectionProfile();
            JavaDocLocalInspection inspection = (JavaDocLocalInspection)inspectionProfile.getUnwrappedTool("JavaDoc", position);
            if (inspection != null) {
                StringTokenizer tokenizer = new StringTokenizer(inspection.myAdditionalJavadocTags, ", ");
                while (tokenizer.hasMoreTokens()) {
                    ret.add(tokenizer.nextToken());
                }
            }
            for (String s : ret) {
                if (isInline) {
                    result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)LookupElementBuilder.create((String)s), (InsertHandler)new InlineInsertHandler()));
                    continue;
                }
                result.addElement(TailTypeDecorator.withTail(LookupElementBuilder.create((String)s), TailType.INSERT_SPACE));
            }
            result.stopHere();
        }

        private static void addSpecialTags(final List<String> result, PsiDocComment comment, String tagName) {
            PsiMember member;
            if ("author".equals(tagName)) {
                result.add(tagName + " " + SystemProperties.getUserName());
                return;
            }
            if ("param".equals(tagName)) {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)comment, PsiMethod.class);
                if (psiMethod != null) {
                    PsiDocTag[] tags = comment.getTags();
                    for (PsiParameter param : psiMethod.getParameterList().getParameters()) {
                        if (JavaDocLocalInspectionBase.isFound(tags, (PsiElement)param)) continue;
                        result.add(tagName + " " + param.getName());
                    }
                }
                return;
            }
            if ("see".equals(tagName) && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)comment, PsiMember.class)) instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)((PsiClass)member), (boolean)false, (Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        String name = psiClass.getQualifiedName();
                        if (StringUtil.isNotEmpty((String)name) && !"java.lang.Object".equals(name)) {
                            result.add("see " + name);
                        }
                        return true;
                    }
                });
            }
        }
    }
}

