/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.XmlSmartCompletionProvider;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.emmet.completion.EmmetAbbreviationCompletionProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> WORD_COMPLETION_COMPATIBLE = Key.create((String)"WORD_COMPLETION_COMPATIBLE");
    @NonNls
    public static final String TAG_NAME_COMPLETION_FEATURE = "tag.name.completion";
    private static final InsertHandlerDecorator<LookupElement> QUOTE_EATER = new InsertHandlerDecorator<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
            char completionChar = context.getCompletionChar();
            if (completionChar == '\'' || completionChar == '\"') {
                char c;
                context.setAddCompletionChar(false);
                item.getDelegate().handleInsert(context);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int tailOffset = editor.getCaretModel().getOffset();
                if (document.getTextLength() > tailOffset && ((c = document.getCharsSequence().charAt(tailOffset)) == completionChar || completionChar == '\'')) {
                    editor.getCaretModel().moveToOffset(tailOffset + 1);
                }
            } else {
                item.getDelegate().handleInsert(context);
            }
        }
    };

    public XmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlFile()), new EmmetAbbreviationCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlCompletionContributor$2", "addCompletions"));
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttributeValue.class, (boolean)false);
                if (attributeValue == null) {
                    return;
                }
                THashSet usedWords = new THashSet();
                final Ref addWordVariants = Ref.create((Object)true);
                result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>((Set)usedWords, result){
                    final /* synthetic */ Set val$usedWords;
                    final /* synthetic */ CompletionResultSet val$result;
                    {
                        this.val$usedWords = set;
                        this.val$result = completionResultSet;
                    }

                    public void consume(CompletionResult r) {
                        if (r.getLookupElement().getUserData(WORD_COMPLETION_COMPATIBLE) == null) {
                            addWordVariants.set((Object)false);
                        }
                        this.val$usedWords.add(r.getLookupElement().getLookupString());
                        this.val$result.passResult(r.withLookupElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)r.getLookupElement(), (InsertHandler)QUOTE_EATER)));
                    }
                });
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    addWordVariants.set((Object)(attributeValue.getReferences().length == 0 ? 1 : 0));
                }
                if (((Boolean)addWordVariants.get()).booleanValue() && parameters.getInvocationCount() > 0) {
                    WordCompletionContributor.addWordCompletionVariants(result, parameters, (Set<String>)usedWords);
                }
            }
        });
    }

    public static boolean isXmlNameCompletion(CompletionParameters parameters) {
        ASTNode node = parameters.getPosition().getNode();
        return node != null && node.getElementType() == XmlTokenType.XML_NAME;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, result);
        if (result.isStopped()) {
            return;
        }
        PsiElement element = parameters.getPosition();
        if (parameters.isExtendedCompletion()) {
            XmlCompletionContributor.completeTagName(parameters, result);
        } else if (parameters.getCompletionType() == CompletionType.SMART) {
            new XmlSmartCompletionProvider().complete(parameters, result, element);
        }
    }

    static void completeTagName(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement element = parameters.getPosition();
        if (!XmlCompletionContributor.isXmlNameCompletion(parameters)) {
            return;
        }
        result.stopHere();
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlTag) || !(parameters.getOriginalFile() instanceof XmlFile)) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        String namespace = tag.getNamespace();
        String prefix = result.getPrefixMatcher().getPrefix();
        int pos = prefix.indexOf(58);
        PsiReference reference = tag.getReference();
        String namespacePrefix = tag.getNamespacePrefix();
        if (reference != null && !namespace.isEmpty() && !namespacePrefix.isEmpty()) {
            result.runRemainingContributors(parameters, true);
        } else {
            CompletionResultSet newResult = result.withPrefixMatcher(pos >= 0 ? prefix.substring(pos + 1) : prefix);
            XmlFile file2 = (XmlFile)parameters.getOriginalFile();
            List<XmlExtension.TagInfo> names = XmlExtension.getExtension((PsiFile)file2).getAvailableTagNames(file2, tag);
            for (XmlExtension.TagInfo info : names) {
                LookupElement item = XmlCompletionContributor.createLookupElement(info, info.namespace, namespacePrefix.isEmpty() ? null : namespacePrefix);
                newResult.addElement(item);
            }
        }
    }

    public static LookupElement createLookupElement(XmlExtension.TagInfo tagInfo, String tailText, @Nullable String namespacePrefix) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)tagInfo, (String)tagInfo.name).withInsertHandler((InsertHandler)new ExtendedTagInsertHandler(tagInfo.name, tagInfo.namespace, namespacePrefix));
        if (!StringUtil.isEmpty((String)tailText)) {
            builder = builder.withTypeText(tailText, true);
        }
        return builder;
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlCompletionContributor", "advertise"));
        }
        if (XmlCompletionContributor.isXmlNameCompletion(parameters) && parameters.getCompletionType() == CompletionType.BASIC && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(TAG_NAME_COMPLETION_FEATURE, parameters.getPosition().getProject())) {
            String shortcut = XmlCompletionContributor.getActionShortcut((String)"CodeCompletion");
            return XmlBundle.message((String)"tag.name.completion.hint", (Object[])new Object[]{shortcut});
        }
        return super.advertise(parameters);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement at;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/XmlCompletionContributor", "beforeCompletion"));
        }
        int offset = context.getStartOffset();
        PsiFile file2 = context.getFile();
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, XmlAttributeValue.class, (boolean)true);
        if (attributeValue != null && offset == attributeValue.getTextRange().getStartOffset()) {
            context.setDummyIdentifier("");
        }
        if ((at = file2.findElementAt(offset)) != null && at.getNode().getElementType() == XmlTokenType.XML_NAME && at.getParent() instanceof XmlAttribute) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, at.getTextRange().getEndOffset());
        }
    }
}

