/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.ui.classFilter.ClassFilterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class DebuggerSteppingConfigurable
implements ConfigurableUi<DebuggerSettings> {
    private JCheckBox myCbStepInfoFiltersEnabled;
    private JCheckBox myCbSkipSyntheticMethods;
    private JCheckBox myCbSkipConstructors;
    private JCheckBox myCbSkipClassLoaders;
    private ClassFilterEditor mySteppingFilterEditor;
    private JCheckBox myCbSkipSimpleGetters;
    private JRadioButton myRbEvaluateFinallyAlways;
    private JRadioButton myRbEvaluateFinallyNever;
    private JRadioButton myRbEvaluateFinallyAsk;
    private JCheckBox myCbResumeOnlyCurrentThread;

    DebuggerSteppingConfigurable() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/debugger/settings/DebuggerSteppingConfigurable", "reset"));
        }
        this.myCbSkipSimpleGetters.setSelected(settings.SKIP_GETTERS);
        this.myCbSkipSyntheticMethods.setSelected(settings.SKIP_SYNTHETIC_METHODS);
        this.myCbSkipConstructors.setSelected(settings.SKIP_CONSTRUCTORS);
        this.myCbSkipClassLoaders.setSelected(settings.SKIP_CLASSLOADERS);
        this.myCbStepInfoFiltersEnabled.setSelected(settings.TRACING_FILTERS_ENABLED);
        this.mySteppingFilterEditor.setFilters(settings.getSteppingFilters());
        this.mySteppingFilterEditor.setEnabled(settings.TRACING_FILTERS_ENABLED);
        if ("EvaluateFinallyAlways".equals(settings.EVALUATE_FINALLY_ON_POP_FRAME)) {
            this.myRbEvaluateFinallyAlways.setSelected(true);
        } else if ("EvaluateFinallyNever".equals(settings.EVALUATE_FINALLY_ON_POP_FRAME)) {
            this.myRbEvaluateFinallyNever.setSelected(true);
        } else {
            this.myRbEvaluateFinallyAsk.setSelected(true);
        }
        this.myCbResumeOnlyCurrentThread.setSelected(settings.RESUME_ONLY_CURRENT_THREAD);
    }

    public void apply(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/debugger/settings/DebuggerSteppingConfigurable", "apply"));
        }
        this.mySteppingFilterEditor.stopEditing();
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.SKIP_GETTERS = this.myCbSkipSimpleGetters.isSelected();
        settings.SKIP_SYNTHETIC_METHODS = this.myCbSkipSyntheticMethods.isSelected();
        settings.SKIP_CONSTRUCTORS = this.myCbSkipConstructors.isSelected();
        settings.SKIP_CLASSLOADERS = this.myCbSkipClassLoaders.isSelected();
        settings.TRACING_FILTERS_ENABLED = this.myCbStepInfoFiltersEnabled.isSelected();
        settings.EVALUATE_FINALLY_ON_POP_FRAME = this.myRbEvaluateFinallyAlways.isSelected() ? "EvaluateFinallyAlways" : (this.myRbEvaluateFinallyNever.isSelected() ? "EvaluateFinallyNever" : "EvaluateFinallyAsk");
        settings.RESUME_ONLY_CURRENT_THREAD = this.myCbResumeOnlyCurrentThread.isSelected();
        settings.setSteppingFilters(this.mySteppingFilterEditor.getFilters());
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        if (currentSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSettings", "com/intellij/debugger/settings/DebuggerSteppingConfigurable", "isModified"));
        }
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        Insets insets;
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbSkipSyntheticMethods = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.synthetic.methods", (Object[])new Object[0]));
        this.myCbSkipConstructors = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.constructors", (Object[])new Object[0]));
        this.myCbSkipClassLoaders = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.classLoaders", (Object[])new Object[0]));
        this.myCbSkipSimpleGetters = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.simple.getters", (Object[])new Object[0]));
        this.myCbStepInfoFiltersEnabled = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.step.filters.list.header", (Object[])new Object[0]));
        panel.add((Component)this.myCbSkipSyntheticMethods, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipConstructors, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipClassLoaders, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipSimpleGetters, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbStepInfoFiltersEnabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.mySteppingFilterEditor = new ClassFilterEditor(JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables(), null, "reference.viewBreakpoints.classFilters.newPattern");
        panel.add((Component)this.mySteppingFilterEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.myCbStepInfoFiltersEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebuggerSteppingConfigurable.this.mySteppingFilterEditor.setEnabled(DebuggerSteppingConfigurable.this.myCbStepInfoFiltersEnabled.isSelected());
            }
        });
        this.myRbEvaluateFinallyAlways = new JRadioButton(DebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.always", (Object[])new Object[0]));
        this.myRbEvaluateFinallyNever = new JRadioButton(DebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.never", (Object[])new Object[0]));
        this.myRbEvaluateFinallyAsk = new JRadioButton(DebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.ask", (Object[])new Object[0]));
        int cbLeftOffset = 0;
        Border border = this.myCbSkipSimpleGetters.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.myCbSkipSimpleGetters)) != null) {
            cbLeftOffset = insets.left;
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbEvaluateFinallyAlways);
        group.add(this.myRbEvaluateFinallyNever);
        group.add(this.myRbEvaluateFinallyAsk);
        Box box = Box.createHorizontalBox();
        box.add(this.myRbEvaluateFinallyAlways);
        box.add(this.myRbEvaluateFinallyNever);
        box.add(this.myRbEvaluateFinallyAsk);
        JPanel evalFinallyPanel = new JPanel(new BorderLayout());
        evalFinallyPanel.add((Component)box, "Center");
        evalFinallyPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.on.pop", (Object[])new Object[0])), "West");
        panel.add((Component)evalFinallyPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, cbLeftOffset, 0, 0), 0, 0));
        this.myCbResumeOnlyCurrentThread = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.resume.only.current.thread", (Object[])new Object[0]));
        panel.add((Component)this.myCbResumeOnlyCurrentThread, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/DebuggerSteppingConfigurable", "getComponent"));
        }
        return jPanel;
    }
}

