/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.DebuggerTreeBase;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class DebuggerTree
extends DebuggerTreeBase
implements DataProvider {
    private static final Logger LOG = Logger.getInstance(DebuggerTree.class);
    protected static final Key<Rectangle> VISIBLE_RECT = Key.create((String)"VISIBLE_RECT");
    public static final DataKey<DebuggerTree> DATA_KEY = DataKey.create((String)"DebuggerTree");
    protected final NodeManagerImpl myNodeManager;
    private DebuggerContextImpl myDebuggerContext = DebuggerContextImpl.EMPTY_CONTEXT;
    private DebuggerTreeNodeImpl myEditedNode;

    public DebuggerTree(Project project2) {
        super(null, project2);
        this.setScrollsOnExpand(false);
        this.myNodeManager = this.createNodeManager(project2);
        TreeBuilder model = new TreeBuilder((Object)this){

            @Override
            public void buildChildren(TreeBuilderNode node) {
                DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
                if (debuggerTreeNode.getDescriptor() instanceof DefaultNodeDescriptor) {
                    return;
                }
                DebuggerTree.this.buildNode(debuggerTreeNode);
            }

            @Override
            public boolean isExpandable(TreeBuilderNode builderNode) {
                return DebuggerTree.this.isExpandable((DebuggerTreeNodeImpl)builderNode);
            }
        };
        model.setRoot(this.getNodeFactory().getDefaultNode());
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent event) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent event) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent event) {
                DebuggerTree.this.hideTooltip();
            }
        });
        this.setModel(model);
        TreeSpeedSearch search = new TreeSpeedSearch((JTree)((Object)this));
        search.setComparator(new SpeedSearchComparator(false));
    }

    protected NodeManagerImpl createNodeManager(Project project2) {
        return new NodeManagerImpl(project2, this);
    }

    @Override
    public void dispose() {
        this.myNodeManager.dispose();
        this.myDebuggerContext = DebuggerContextImpl.EMPTY_CONTEXT;
        super.dispose();
    }

    protected boolean isExpandable(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        return descriptor.isExpandable();
    }

    public Object getData(String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    private void buildNode(DebuggerTreeNodeImpl node) {
        DebuggerCommandImpl command;
        if (node == null || node.getDescriptor() == null) {
            return;
        }
        DebugProcessImpl debugProcess = this.getDebuggerContext().getDebugProcess();
        if (debugProcess != null && (command = this.getBuildNodeCommand(node)) != null) {
            node.add(this.myNodeManager.createMessageNode(MessageDescriptor.EVALUATING));
            debugProcess.getManagerThread().schedule(command);
        }
    }

    protected DebuggerCommandImpl getBuildNodeCommand(DebuggerTreeNodeImpl node) {
        if (node.getDescriptor() instanceof StackFrameDescriptorImpl) {
            return new BuildStackFrameCommand(node);
        }
        if (node.getDescriptor() instanceof ValueDescriptorImpl) {
            return new BuildValueNodeCommand(node);
        }
        if (node.getDescriptor() instanceof StaticDescriptorImpl) {
            return new BuildStaticNodeCommand(node);
        }
        if (node.getDescriptor() instanceof ThreadDescriptorImpl) {
            return new BuildThreadCommand(node);
        }
        if (node.getDescriptor() instanceof ThreadGroupDescriptorImpl) {
            return new BuildThreadGroupCommand(node);
        }
        LOG.assertTrue(false);
        return null;
    }

    public void saveState(DebuggerTreeNodeImpl node) {
        if (node.getDescriptor() != null) {
            TreePath path = new TreePath(node.getPath());
            node.getDescriptor().myIsExpanded = this.isExpanded(path);
            node.getDescriptor().myIsSelected = this.getSelectionModel().isPathSelected(path);
            Rectangle rowBounds = this.getRowBounds(this.getRowForPath(path));
            if (rowBounds != null && this.getVisibleRect().contains(rowBounds)) {
                node.getDescriptor().putUserData(VISIBLE_RECT, this.getVisibleRect());
                node.getDescriptor().myIsVisible = true;
            } else {
                node.getDescriptor().putUserData(VISIBLE_RECT, null);
                node.getDescriptor().myIsVisible = false;
            }
        }
        Enumeration e = node.rawChildren();
        while (e.hasMoreElements()) {
            DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
            this.saveState(child);
        }
    }

    public void restoreState(DebuggerTreeNodeImpl node) {
        this.restoreStateImpl(node);
        this.scrollToVisible(node);
    }

    protected final void scrollToVisible(DebuggerTreeNodeImpl scopeNode) {
        TreePath rootPath = new TreePath(scopeNode.getPath());
        int rowCount = this.getRowCount();
        for (int idx = rowCount - 1; idx >= 0; --idx) {
            DebuggerTreeNodeImpl pathNode;
            NodeDescriptorImpl descriptor;
            TreePath treePath = this.getPathForRow(idx);
            if (treePath == null || !rootPath.isDescendant(treePath) || (descriptor = (pathNode = (DebuggerTreeNodeImpl)treePath.getLastPathComponent()).getDescriptor()) == null || !descriptor.myIsVisible) continue;
            Rectangle visibleRect = descriptor.getUserData(VISIBLE_RECT);
            if (visibleRect != null) {
                this.scrollRectToVisible(visibleRect);
                break;
            }
            this.scrollPathToVisible(treePath);
            break;
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
        aRect.width += aRect.x;
        aRect.x = 0;
        super.scrollRectToVisible(aRect);
    }

    private void restoreStateImpl(DebuggerTreeNodeImpl node) {
        this.restoreNodeState(node);
        if (node.getDescriptor().myIsExpanded) {
            Enumeration e = node.rawChildren();
            while (e.hasMoreElements()) {
                DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
                this.restoreStateImpl(child);
            }
        }
    }

    public void restoreState() {
        this.clearSelection();
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (root != null) {
            this.restoreState(root);
        }
    }

    protected void restoreNodeState(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (descriptor != null) {
            if (node.getParent() == null) {
                descriptor.myIsExpanded = true;
            }
            TreePath path = new TreePath(node.getPath());
            if (descriptor.myIsExpanded) {
                this.expandPath(path);
            }
            if (descriptor.myIsSelected) {
                this.addSelectionPath(path);
            }
        }
    }

    public NodeManagerImpl getNodeFactory() {
        return this.myNodeManager;
    }

    public TreeBuilder getMutableModel() {
        return (TreeBuilder)this.getModel();
    }

    public void removeAllChildren() {
        DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        root.removeAllChildren();
        this.treeChanged();
    }

    public void showMessage(MessageDescriptor messageDesc) {
        DebuggerTreeNodeImpl root = this.getNodeFactory().getDefaultNode();
        this.getMutableModel().setRoot(root);
        DebuggerTreeNodeImpl message = root.add(messageDesc);
        this.treeChanged();
        this.expandPath(new TreePath(message.getPath()));
    }

    public void showMessage(String messageText) {
        this.showMessage(new MessageDescriptor(messageText));
    }

    public final void treeChanged() {
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (node != null) {
            this.getMutableModel().nodeStructureChanged(node);
            this.restoreState();
        }
    }

    protected abstract void build(DebuggerContextImpl var1);

    protected final void buildWhenPaused(DebuggerContextImpl context, RefreshDebuggerTreeCommand command) {
        DebuggerSession session = context.getDebuggerSession();
        if (ApplicationManager.getApplication().isUnitTestMode() || session != null && session.getState() == DebuggerSession.State.PAUSED) {
            this.showMessage(MessageDescriptor.EVALUATING);
            context.getDebugProcess().getManagerThread().schedule(command);
        } else {
            this.showMessage(session != null ? session.getStateDescription() : DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]));
            if (session == null || session.isStopped()) {
                this.getNodeFactory().clearHistory();
            }
        }
    }

    public void rebuild(final DebuggerContextImpl context) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessImpl process = context.getDebugProcess();
        if (process == null) {
            return;
        }
        this.myDebuggerContext = context;
        this.saveState();
        process.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                DebuggerTree.this.getNodeFactory().setHistoryByContext(context);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }
        });
        this.build(context);
    }

    public void saveState() {
        this.saveState((DebuggerTreeNodeImpl)this.getModel().getRoot());
    }

    public void onEditorShown(DebuggerTreeNodeImpl node) {
        this.myEditedNode = node;
        this.hideTooltip();
    }

    public void onEditorHidden(DebuggerTreeNodeImpl node) {
        if (this.myEditedNode != null) {
            assert (this.myEditedNode == node);
            this.myEditedNode = null;
        }
    }

    @Override
    public JComponent createToolTip(MouseEvent e) {
        return this.myEditedNode != null ? null : super.createToolTip(e);
    }

    public DebuggerContextImpl getDebuggerContext() {
        return this.myDebuggerContext;
    }

    public void hideTooltip() {
        this.myTipManager.hideTooltip();
    }

    private class BuildThreadGroupCommand
    extends DebuggerCommandImpl {
        private final DebuggerTreeNodeImpl myNode;
        protected final List<DebuggerTreeNodeImpl> myChildren = new LinkedList<DebuggerTreeNodeImpl>();

        public BuildThreadGroupCommand(DebuggerTreeNodeImpl node) {
            this.myNode = node;
        }

        @Override
        protected void action() throws Exception {
            ThreadGroupDescriptorImpl groupDescriptor = (ThreadGroupDescriptorImpl)this.myNode.getDescriptor();
            ThreadGroupReferenceProxyImpl threadGroup = groupDescriptor.getThreadGroupReference();
            ArrayList<ThreadReferenceProxyImpl> threads = new ArrayList<ThreadReferenceProxyImpl>(threadGroup.threads());
            Collections.sort(threads, ThreadReferenceProxyImpl.ourComparator);
            DebuggerContextImpl debuggerContext = DebuggerTree.this.getDebuggerContext();
            SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
            EvaluationContextImpl evaluationContext = suspendContext != null && !suspendContext.isResumed() ? debuggerContext.createEvaluationContext() : null;
            boolean showCurrent = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD;
            for (ThreadGroupReferenceProxyImpl group : threadGroup.threadGroups()) {
                if (group == null) continue;
                DebuggerTreeNodeImpl threadNode = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadGroupDescriptor(groupDescriptor, group), evaluationContext);
                if (showCurrent && ((ThreadGroupDescriptorImpl)threadNode.getDescriptor()).isCurrent()) {
                    this.myChildren.add(0, threadNode);
                    continue;
                }
                this.myChildren.add(threadNode);
            }
            ArrayList<DebuggerTreeNodeImpl> threadNodes = new ArrayList<DebuggerTreeNodeImpl>();
            for (ThreadReferenceProxyImpl thread : threads) {
                if (thread == null) continue;
                DebuggerTreeNodeImpl threadNode = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadDescriptor(groupDescriptor, thread), evaluationContext);
                if (showCurrent && ((ThreadDescriptorImpl)threadNode.getDescriptor()).isCurrent()) {
                    threadNodes.add(0, threadNode);
                    continue;
                }
                threadNodes.add(threadNode);
            }
            this.myChildren.addAll(threadNodes);
            this.updateUI(true);
        }

        protected void updateUI(final boolean scrollToVisible) {
            DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    BuildThreadGroupCommand.this.myNode.removeAllChildren();
                    for (DebuggerTreeNodeImpl debuggerTreeNode : BuildThreadGroupCommand.this.myChildren) {
                        BuildThreadGroupCommand.this.myNode.add(debuggerTreeNode);
                    }
                    BuildThreadGroupCommand.this.myNode.childrenChanged(scrollToVisible);
                }
            });
        }
    }

    private class BuildThreadCommand
    extends BuildNodeCommand {
        public BuildThreadCommand(DebuggerTreeNodeImpl threadNode) {
            super(threadNode, ((ThreadDescriptorImpl)threadNode.getDescriptor()).getThreadReference());
        }

        @Override
        public void threadAction() {
            int status;
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)this.getNode().getDescriptor();
            ThreadReferenceProxyImpl threadProxy = threadDescriptor.getThreadReference();
            if (!threadProxy.isCollected() && this.getDebuggerContext().getDebugProcess().getSuspendManager().isSuspended(threadProxy) && (status = threadProxy.status()) != -1 && status != 5 && status != 0) {
                try {
                    for (StackFrameProxyImpl stackFrame : threadProxy.frames()) {
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getStackFrameDescriptor(threadDescriptor, stackFrame), this.getDebuggerContext().createEvaluationContext()));
                    }
                }
                catch (EvaluateException e) {
                    this.myChildren.clear();
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(e.getMessage()));
                    LOG.debug((Throwable)e);
                }
            }
            this.updateUI(true);
        }
    }

    private class BuildStaticNodeCommand
    extends BuildNodeCommand {
        public BuildStaticNodeCommand(DebuggerTreeNodeImpl node) {
            super(node);
        }

        @Override
        public void threadAction() {
            StaticDescriptorImpl sd = (StaticDescriptorImpl)this.getNode().getDescriptor();
            ReferenceType refType = sd.getType();
            List<Field> fields = refType.allFields();
            for (Field field : fields) {
                if (!field.isStatic()) continue;
                FieldDescriptorImpl fieldDescriptor = DebuggerTree.this.myNodeManager.getFieldDescriptor(sd, null, field);
                EvaluationContextImpl evaluationContext = this.getDebuggerContext().createEvaluationContext();
                DebuggerTreeNodeImpl node = DebuggerTree.this.myNodeManager.createNode(fieldDescriptor, evaluationContext);
                this.myChildren.add(node);
            }
            this.updateUI(true);
        }
    }

    private class BuildValueNodeCommand
    extends BuildNodeCommand
    implements ChildrenBuilder {
        public BuildValueNodeCommand(DebuggerTreeNodeImpl node) {
            super(node);
        }

        @Override
        public void threadAction() {
            final DebuggerTreeNodeImpl node = this.getNode();
            ValueDescriptorImpl descriptor = (ValueDescriptorImpl)node.getDescriptor();
            try {
                NodeRenderer renderer = descriptor.getRenderer(this.getSuspendContext().getDebugProcess());
                renderer.buildChildren(descriptor.getValue(), this, this.getDebuggerContext().createEvaluationContext());
            }
            catch (ObjectCollectedException e) {
                final String message = e.getMessage();
                DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        node.removeAllChildren();
                        node.add(DebuggerTree.this.getNodeFactory().createMessageNode(new MessageDescriptor(DebuggerBundle.message((String)"error.cannot.build.node.children.object.collected", (Object[])new Object[]{message}))));
                        node.childrenChanged(false);
                    }
                });
            }
        }

        @Override
        public NodeManagerImpl getNodeManager() {
            return DebuggerTree.this.myNodeManager;
        }

        @Override
        public NodeManagerImpl getDescriptorManager() {
            return DebuggerTree.this.myNodeManager;
        }

        @Override
        public ValueDescriptorImpl getParentDescriptor() {
            return (ValueDescriptorImpl)this.getNode().getDescriptor();
        }

        @Override
        public void setRemaining(int remaining) {
        }

        @Override
        public void initChildrenArrayRenderer(ArrayRenderer renderer) {
        }

        @Override
        public void setChildren(List<DebuggerTreeNode> children2) {
            for (DebuggerTreeNode child : children2) {
                if (!(child instanceof DebuggerTreeNodeImpl)) continue;
                this.myChildren.add((DebuggerTreeNodeImpl)child);
            }
            this.updateUI(false);
        }
    }

    protected class BuildStackFrameCommand
    extends BuildNodeCommand {
        public BuildStackFrameCommand(DebuggerTreeNodeImpl stackNode) {
            super(stackNode);
        }

        @Override
        public void threadAction() {
            try {
                ReferenceType thisRefType;
                StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)this.getNode().getDescriptor();
                StackFrameProxyImpl frame = stackDescriptor.getFrameProxy();
                DebuggerContextImpl debuggerContext = this.getDebuggerContext();
                EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
                if (!debuggerContext.isEvaluationPossible()) {
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(MessageDescriptor.EVALUATION_NOT_POSSIBLE, evaluationContext));
                }
                Location location = frame.location();
                LOG.assertTrue(location != null);
                ObjectReference thisObjectReference = frame.thisObject();
                NodeDescriptorImpl descriptor = thisObjectReference != null ? DebuggerTree.this.myNodeManager.getThisDescriptor(stackDescriptor, thisObjectReference) : DebuggerTree.this.myNodeManager.getStaticDescriptor(stackDescriptor, location.method().declaringType());
                this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(descriptor, evaluationContext));
                ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                if (classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && thisObjectReference != null && evaluationContext.getDebugProcess().getVirtualMachineProxy().canGetSyntheticAttribute() && (thisRefType = thisObjectReference.referenceType()) instanceof ClassType && thisRefType.equals(location.declaringType()) && thisRefType.name().contains("$")) {
                    ClassType clsType = (ClassType)thisRefType;
                    for (Field field : clsType.fields()) {
                        if (!DebuggerUtils.isSynthetic((TypeComponent)field) || !StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) continue;
                        FieldDescriptorImpl fieldDescriptor = DebuggerTree.this.myNodeManager.getFieldDescriptor(stackDescriptor, thisObjectReference, field);
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(fieldDescriptor, evaluationContext));
                    }
                }
                try {
                    this.buildVariables(stackDescriptor, evaluationContext);
                    if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                        Collections.sort(this.myChildren, NodeManagerImpl.getNodeComparator());
                    }
                }
                catch (EvaluateException e) {
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(e.getMessage())));
                }
                Pair<Method, Value> methodValuePair = debuggerContext.getDebugProcess().getLastExecutedMethod();
                if (methodValuePair != null) {
                    ValueDescriptorImpl returnValueDescriptor = DebuggerTree.this.myNodeManager.getMethodReturnValueDescriptor(stackDescriptor, (Method)methodValuePair.getFirst(), (Value)methodValuePair.getSecond());
                    this.myChildren.add(1, DebuggerTree.this.myNodeManager.createNode(returnValueDescriptor, evaluationContext));
                }
                for (Pair<Breakpoint, Event> pair : DebuggerUtilsEx.getEventDescriptors(this.getSuspendContext())) {
                    ObjectReference exception;
                    Event debugEvent = (Event)pair.getSecond();
                    if (!(debugEvent instanceof ExceptionEvent) || (exception = ((ExceptionEvent)debugEvent).exception()) == null) continue;
                    ValueDescriptorImpl exceptionDescriptor = DebuggerTree.this.myNodeManager.getThrownExceptionObjectDescriptor(stackDescriptor, exception);
                    DebuggerTreeNodeImpl exceptionNode = DebuggerTree.this.myNodeManager.createNode(exceptionDescriptor, evaluationContext);
                    this.myChildren.add(1, exceptionNode);
                }
            }
            catch (EvaluateException e) {
                this.myChildren.clear();
                this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(e.getMessage())));
            }
            catch (InvalidStackFrameException e) {
                LOG.info((Throwable)e);
                this.myChildren.clear();
                this.notifyCancelled();
            }
            catch (InternalException e) {
                if (e.errorCode() == 35) {
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}))));
                }
                throw e;
            }
            this.updateUI(true);
        }

        protected void buildVariables(StackFrameDescriptorImpl stackDescriptor, EvaluationContextImpl evaluationContext) throws EvaluateException {
            StackFrameProxyImpl frame = stackDescriptor.getFrameProxy();
            for (LocalVariableProxyImpl local : frame.visibleVariables()) {
                LocalVariableDescriptorImpl localVariableDescriptor = DebuggerTree.this.myNodeManager.getLocalVariableDescriptor(stackDescriptor, local);
                DebuggerTreeNodeImpl variableNode = DebuggerTree.this.myNodeManager.createNode(localVariableDescriptor, evaluationContext);
                this.myChildren.add(variableNode);
            }
        }
    }

    public abstract class BuildNodeCommand
    extends DebuggerContextCommandImpl {
        private final DebuggerTreeNodeImpl myNode;
        protected final List<DebuggerTreeNodeImpl> myChildren;

        protected BuildNodeCommand(DebuggerTreeNodeImpl node) {
            this(node, null);
        }

        protected BuildNodeCommand(DebuggerTreeNodeImpl node, ThreadReferenceProxyImpl thread) {
            super(DebuggerTree.this.getDebuggerContext(), thread);
            this.myChildren = new LinkedList<DebuggerTreeNodeImpl>();
            this.myNode = node;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.NORMAL;
        }

        public DebuggerTreeNodeImpl getNode() {
            return this.myNode;
        }

        protected void updateUI(final boolean scrollToVisible) {
            DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    BuildNodeCommand.this.myNode.removeAllChildren();
                    for (DebuggerTreeNodeImpl debuggerTreeNode : BuildNodeCommand.this.myChildren) {
                        BuildNodeCommand.this.myNode.add(debuggerTreeNode);
                    }
                    BuildNodeCommand.this.myNode.childrenChanged(scrollToVisible);
                }
            });
        }
    }

    protected static abstract class RefreshDebuggerTreeCommand
    extends SuspendContextCommandImpl {
        private final DebuggerContextImpl myDebuggerContext;

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.NORMAL;
        }

        public RefreshDebuggerTreeCommand(DebuggerContextImpl context) {
            super(context.getSuspendContext());
            this.myDebuggerContext = context;
        }

        public final DebuggerContextImpl getDebuggerContext() {
            return this.myDebuggerContext;
        }
    }
}

