/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAwareDocumentContent
extends DocumentContentImpl {
    @Nullable
    private final Project myProject;

    public FileAwareDocumentContent(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType, @Nullable VirtualFile highlightFile, @Nullable LineSeparator separator, @Nullable Charset charset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileAwareDocumentContent", "<init>"));
        }
        super(document, fileType, highlightFile, separator, charset);
        this.myProject = project2;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        if (this.myProject == null || this.getHighlightFile() == null || !this.getHighlightFile().isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.getHighlightFile(), offset);
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull String content, @NotNull FilePath path) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project2).init(path).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull String content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project2).init(highlightFile).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath path) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project2).init(path).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        FileAwareDocumentContent fileAwareDocumentContent = new Builder(project2).init(highlightFile).create(content).build();
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent", "create"));
        }
        return fileAwareDocumentContent;
    }

    private static class Builder {
        private final Project myProject;
        private Document myDocument;
        private FileType myFileType;
        private VirtualFile myHighlightFile;
        private LineSeparator mySeparator;
        private Charset myCharset;
        private Charset mySuggestedCharset;
        private boolean myMalformedContent;

        public Builder(@Nullable Project project2) {
            this.myProject = project2;
        }

        @NotNull
        private Builder init(@NotNull FilePath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            this.myHighlightFile = path.getVirtualFile();
            this.myFileType = path.getFileType();
            this.mySuggestedCharset = path.getCharset(this.myProject);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            return builder;
        }

        @NotNull
        private Builder init(@NotNull VirtualFile highlightFile) {
            if (highlightFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            this.myHighlightFile = highlightFile;
            this.myFileType = highlightFile.getFileType();
            this.mySuggestedCharset = highlightFile.getCharset();
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "init"));
            }
            return builder;
        }

        @NotNull
        private Builder create(@NotNull String content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            this.mySeparator = StringUtil.detectSeparators((CharSequence)content);
            this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)content));
            this.myDocument.setReadOnly(true);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            return builder;
        }

        @NotNull
        private Builder create(@NotNull byte[] content) {
            Builder builder;
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            assert (this.mySuggestedCharset != null);
            this.myCharset = this.mySuggestedCharset;
            try {
                String text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)this.mySuggestedCharset);
                builder = this.create(text);
            }
            catch (CharacterCodingException e) {
                String text = CharsetToolkit.decodeString((byte[])content, (Charset)this.mySuggestedCharset);
                this.myMalformedContent = true;
                Builder builder2 = this.create(text);
                if (builder2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
                }
                return builder2;
            }
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "create"));
            }
            return builder;
        }

        @Nullable
        private List<JComponent> createNotifications() {
            if (!this.myMalformedContent) {
                return null;
            }
            assert (this.mySuggestedCharset != null);
            String text = "Content was decoded with errors (using '" + this.mySuggestedCharset.name() + "' charset)";
            JPanel notification = DiffNotifications.createNotification(text, LightColors.RED);
            return Collections.singletonList(notification);
        }

        @NotNull
        public FileAwareDocumentContent build() {
            if (FileTypes.UNKNOWN.equals(this.myFileType)) {
                this.myFileType = PlainTextFileType.INSTANCE;
            }
            FileAwareDocumentContent content = new FileAwareDocumentContent(this.myProject, this.myDocument, this.myFileType, this.myHighlightFile, this.mySeparator, this.myCharset);
            content.putUserData(DiffUserDataKeys.NOTIFICATIONS, this.createNotifications());
            FileAwareDocumentContent fileAwareDocumentContent = content;
            if (fileAwareDocumentContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileAwareDocumentContent$Builder", "build"));
            }
            return fileAwareDocumentContent;
        }
    }
}

